/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib.html;

import java.util.ArrayList;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.internal.proposal.CustomProposalType;
import org.jboss.tools.jst.web.kb.internal.proposal.EnumerationProposalType;
import org.jboss.tools.jst.web.kb.internal.taglib.html.HtmlAttribute;

public class FileNameAttribute
extends HtmlAttribute {
    public FileNameAttribute(String name, String description, String[] values) {
        super(name, description, values);
    }

    @Override
    protected CustomProposalType createProposalType() {
        return new EnumerationProposalType(){

            @Override
            public TextProposal[] getProposals(KbQuery query) {
                if (this.params == null) {
                    return EMPTY_PROPOSAL_LIST;
                }
                String value = query.getValue();
                ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
                int i = 0;
                while (i < this.params.length) {
                    String text = this.params[i].getValue();
                    boolean createProposal = false;
                    String fileName = text;
                    int lastSl = text.lastIndexOf(47);
                    if (lastSl > -1) {
                        fileName = fileName.substring(lastSl + 1);
                    }
                    if (createProposal = text.startsWith(value) ? true : fileName.startsWith(value)) {
                        int rel = fileName == text ? 850 : 840;
                        TextProposal proposal = new TextProposal();
                        proposal.setLabel(text);
                        proposal.setReplacementString(text);
                        proposal.setAlternateMatch(fileName);
                        proposal.setPosition(text.length());
                        proposal.setImageDescriptor(EnumerationProposalType.IMAGE);
                        proposal.setContextInfo(text);
                        proposal.setRelevance(rel);
                        proposals.add(proposal);
                    }
                    ++i;
                }
                return proposals.toArray(new TextProposal[0]);
            }
        };
    }
}

