/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib;

import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.jst.web.kb.internal.KbObject;
import org.jboss.tools.jst.web.kb.taglib.IELFunction;
import org.jboss.tools.jst.web.model.project.ext.store.XMLValueInfo;
import org.w3c.dom.Element;

public class ELFunction
extends KbObject
implements IELFunction {
    public static final String SIGNATURE = "signature";
    public static final String FUNCTION_CLASS = "function-class";
    private String name;
    private String signature;
    private String functionClass;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFunctionSignature() {
        return this.signature;
    }

    @Override
    public String getFunctionClass() {
        return this.functionClass;
    }

    public void setName(IValueInfo s) {
        this.name = s == null ? null : s.getValue();
        this.attributesInfo.put("name", s);
    }

    public void setSignature(IValueInfo s) {
        this.signature = s == null ? null : s.getValue();
        this.attributesInfo.put(SIGNATURE, s);
    }

    public void setFunctionClass(IValueInfo s) {
        this.functionClass = s == null ? null : s.getValue();
        this.attributesInfo.put(FUNCTION_CLASS, s);
    }

    @Override
    public ELFunction clone() throws CloneNotSupportedException {
        return (ELFunction)super.clone();
    }

    @Override
    public String getXMLName() {
        return "function";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        if (this.attributesInfo.get("name") == null && this.name != null) {
            element.setAttribute("name", this.name);
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        this.setName((IValueInfo)this.attributesInfo.get("name"));
        this.setSignature((IValueInfo)this.attributesInfo.get(SIGNATURE));
        this.setFunctionClass((IValueInfo)this.attributesInfo.get(FUNCTION_CLASS));
        if (this.name == null && element.hasAttribute("name")) {
            this.name = element.getAttribute("name");
        }
    }

    @Override
    protected void saveAttributesInfo(Element element, Properties context) {
        if (context.get("model-object") != this.getId()) {
            super.saveAttributesInfo(element, context);
        }
    }

    @Override
    protected void loadAttributesInfo(Element element, Properties context) {
        if (context.get("model-object") == this.getId() && this.getId() != null) {
            XModelObject a = (XModelObject)this.getId();
            String attrname = a.getModelEntity().getAttribute("function-name") != null ? "function-name" : "name";
            this.attributesInfo.put("name", new XMLValueInfo(a, attrname));
            this.attributesInfo.put(SIGNATURE, new XMLValueInfo(a, "function-signature"));
            this.attributesInfo.put(FUNCTION_CLASS, new XMLValueInfo(a, FUNCTION_CLASS));
        } else {
            super.loadAttributesInfo(element, context);
        }
    }

    @Override
    public List<Change> merge(KbObject s) {
        List changes = super.merge(s);
        ELFunction a = (ELFunction)s;
        if (!this.stringsEqual(this.name, a.name)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, "name", (Object)this.name, (Object)a.name));
            this.name = a.name;
        }
        if (!this.stringsEqual(this.signature, a.signature)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, SIGNATURE, (Object)this.signature, (Object)a.signature));
            this.signature = a.signature;
        }
        if (!this.stringsEqual(this.functionClass, a.functionClass)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, FUNCTION_CLASS, (Object)this.functionClass, (Object)a.functionClass));
            this.functionClass = a.functionClass;
        }
        return changes;
    }
}

