/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal.taglib;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibAttribute;
import org.jboss.tools.jst.web.kb.internal.taglib.CustomTagLibComponent;
import org.jboss.tools.jst.web.kb.taglib.IAttribute;
import org.jboss.tools.jst.web.kb.taglib.IContextAttributeProvider;

public abstract class AbstractAttributeProvider
implements IContextAttributeProvider {
    protected static final CustomTagLibAttribute[] EMPTY = new CustomTagLibAttribute[0];
    protected CustomTagLibComponent parentComponent;
    protected KbQuery query;
    protected IPageContext context;

    public CustomTagLibAttribute[] getAttributes(IPageContext context, KbQuery query) {
        CustomTagLibAttribute attr;
        CustomTagLibAttribute[] attrs;
        this.query = query;
        this.context = context;
        ArrayList<CustomTagLibAttribute> attributes = new ArrayList<CustomTagLibAttribute>();
        CustomTagLibAttribute[] customTagLibAttributeArray = attrs = this.getRequiredAttributes();
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            attr = customTagLibAttributeArray[n2];
            attributes.add(attr);
            ++n2;
        }
        if (this.checkComponent()) {
            customTagLibAttributeArray = attrs = this.getConditionalAttributes();
            n = attrs.length;
            n2 = 0;
            while (n2 < n) {
                attr = customTagLibAttributeArray[n2];
                attributes.add(attr);
                ++n2;
            }
        }
        if (!attributes.isEmpty() && ((CustomTagLibAttribute)attributes.get(0)).getComponent() == null) {
            for (CustomTagLibAttribute attribute : attributes) {
                attribute.setParentComponent(this.getComponent());
            }
        }
        return attributes.toArray(new CustomTagLibAttribute[attributes.size()]);
    }

    @Override
    public IAttribute[] getAttributes(KbQuery query) {
        return this.getAttributes(null, query);
    }

    @Override
    public IAttribute getAttribute(KbQuery query, String name) {
        return this.getAttribute(null, query, name);
    }

    protected abstract boolean checkComponent();

    protected abstract CustomTagLibAttribute[] getConditionalAttributes();

    protected CustomTagLibAttribute[] getRequiredAttributes() {
        return EMPTY;
    }

    @Override
    public CustomTagLibAttribute getAttribute(IPageContext context, KbQuery query, String name) {
        CustomTagLibAttribute[] attrs;
        this.query = query;
        CustomTagLibAttribute[] customTagLibAttributeArray = attrs = this.getAttributes(context, query);
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            CustomTagLibAttribute attr = customTagLibAttributeArray[n2];
            if (attr.getName().equalsIgnoreCase(name)) {
                if (attr.getComponent() == null) {
                    attr.setParentComponent(this.getComponent());
                }
                return attr;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setComponent(CustomTagLibComponent parentComponent) {
        this.parentComponent = parentComponent;
    }

    @Override
    public CustomTagLibComponent getComponent() {
        return this.parentComponent;
    }

    protected boolean checkClassAttribute(String styleClassName) {
        String attr;
        boolean result = false;
        Map<String, String> attributes = this.query.getAttributes();
        if (attributes != null && (attr = attributes.get("class")) != null) {
            result = Pattern.matches(".*(^|\\s)(" + styleClassName + ")($|\\s).*", attr.toLowerCase());
        }
        return result;
    }

    protected boolean checkAttribute(String attributeName) {
        Map<String, String> attributes = this.query.getAttributes();
        if (attributes == null) {
            return false;
        }
        return attributes.get(attributeName) != null;
    }

    protected boolean checkAttribute(AttributeData attribute) {
        return this.checkAttribute(attribute.name, attribute.value);
    }

    protected boolean checkAttribute(String attributeName, String attributeValue) {
        Map<String, String> attributes = this.query.getAttributes();
        if (attributes == null) {
            return false;
        }
        String attr = attributes.get(attributeName);
        return attributeValue.equalsIgnoreCase(attr);
    }

    protected boolean checkAttributeForTag(AttributeData attribute, String tagName) {
        return this.checkAttributeForTag(attribute, tagName, false);
    }

    protected boolean checkAttributeForTag(AttributeData attribute, String tagName, boolean lookInParentTags) {
        if (!lookInParentTags) {
            return tagName == null ? this.checkAttribute(attribute) : this.checkCurrentTag(tagName) && this.checkAttribute(attribute);
        }
        KbQuery.Tag[] parents = this.query.getParentTagsWithAttributes();
        if (parents != null) {
            int i = parents.length - 1;
            while (i > -1) {
                String value;
                if ((tagName == null || tagName.equalsIgnoreCase(parents[i].getName())) && attribute.value.equalsIgnoreCase(value = parents[i].getAttributes().get(attribute.name))) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    protected boolean checkAttributesInParrents(String[] attributeNames) {
        KbQuery.Tag[] parents = this.query.getParentTagsWithAttributes();
        if (parents != null) {
            KbQuery.Tag[] tagArray = parents;
            int n = parents.length;
            int n2 = 0;
            while (n2 < n) {
                KbQuery.Tag tag = tagArray[n2];
                Map<String, String> attrs = tag.getAttributes();
                if (!attrs.isEmpty()) {
                    String[] stringArray = attributeNames;
                    int n3 = attributeNames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String att = stringArray[n4];
                        if (attrs.get(att) != null) {
                            return true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean checkParentTag(String tagName, boolean directParentOnly) {
        String[] parents = this.query.getParentTags();
        if (parents != null && parents.length > 1) {
            int i = parents.length - 2;
            while (!(i <= -1 || directParentOnly && i != parents.length - 2)) {
                if (tagName.equalsIgnoreCase(parents[i])) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    protected boolean checkCurrentTag(String tagName) {
        return tagName.equalsIgnoreCase(this.query.getLastParentTag());
    }

    public static class AttributeData {
        String name;
        String value;

        public AttributeData(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AttributeData) {
                AttributeData other = (AttributeData)obj;
                return this.name.equalsIgnoreCase(other.name) && this.value.equalsIgnoreCase(other.value);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + this.value.hashCode();
        }
    }
}

