/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.jboss.tools.common.el.core.resolver.ELContextImpl;
import org.jboss.tools.jst.web.kb.IXmlContext;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;

public class XmlContextImpl
extends ELContextImpl
implements IXmlContext {
    protected Set<String> uris = new HashSet<String>();
    RegionNameSpaces root = new RegionNameSpaces();
    static final Map<String, List<INameSpace>> EMPTY_NAME_SPACES = Collections.emptyMap();

    boolean areEqual(IRegion r1, IRegion r2) {
        return r1.getOffset() == r2.getOffset() && r1.getLength() == r2.getLength();
    }

    boolean contains(IRegion r1, IRegion r2) {
        return r2.getOffset() >= r1.getOffset() && r1.getOffset() + r1.getLength() >= r2.getOffset() + r2.getLength();
    }

    protected void modifyNameSpacesByUri(RegionNameSpaces s) {
    }

    public IDocument getDocument() {
        IDocument document = null;
        if (this.resource != null) {
            FileEditorInput editorInput = null;
            try {
                editorInput = new FileEditorInput(this.resource);
                document = this.getConnectedDocument((IEditorInput)editorInput);
            }
            catch (Throwable throwable) {
                this.releaseConnectedDocument((IEditorInput)editorInput);
                throw throwable;
            }
            this.releaseConnectedDocument((IEditorInput)editorInput);
        }
        return document;
    }

    public Map<String, List<INameSpace>> getNameSpaces(int offset) {
        RegionNameSpaces n = this.root.find(offset);
        return n != null ? n.getNameSpacesByUri() : EMPTY_NAME_SPACES;
    }

    @Override
    public Map<String, List<INameSpace>> getRootNameSpaces() {
        return this.root.getNameSpacesByUri();
    }

    public INameSpace findNameSpaceByPrefix(Set<INameSpace> namespaces, String prefix) {
        if (namespaces != null && prefix != null) {
            for (INameSpace ns : namespaces) {
                if (!prefix.equals(ns.getPrefix())) continue;
                return ns;
            }
        }
        return null;
    }

    public void addNameSpace(IRegion region, INameSpace nameSpace) {
        this.root.addNameSpace(region, nameSpace);
        String uri = nameSpace.getURI();
        if (!uri.isEmpty()) {
            this.uris.add(uri);
        }
    }

    @Override
    public Set<String> getURIs() {
        return this.uris;
    }

    private IDocument getConnectedDocument(IEditorInput input) {
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        try {
            provider.connect((Object)input);
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        return provider.getDocument((Object)input);
    }

    private void releaseConnectedDocument(IEditorInput input) {
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        provider.disconnect((Object)input);
    }

    protected class RegionNameSpaces {
        protected RegionNameSpaces parent;
        protected IRegion region;
        protected Map<String, INameSpace> nameSpacesByPrefix = new HashMap<String, INameSpace>();
        protected Map<String, List<INameSpace>> nameSpacesByUri = null;
        protected List<RegionNameSpaces> children = null;

        protected RegionNameSpaces() {
        }

        public void addNameSpace(IRegion region, INameSpace nameSpace) {
            RegionNameSpaces c2;
            if (this.region == null || this.region == region || XmlContextImpl.this.areEqual(this.region, region)) {
                this.region = region;
                this.nameSpacesByPrefix.put(nameSpace.getPrefix(), nameSpace);
                return;
            }
            if (this.children != null) {
                for (RegionNameSpaces c2 : this.children) {
                    if (!XmlContextImpl.this.contains(c2.region, region)) continue;
                    c2.addNameSpace(region, nameSpace);
                    return;
                }
            }
            if (this.children == null) {
                this.children = new ArrayList<RegionNameSpaces>();
            }
            c2 = new RegionNameSpaces();
            c2.parent = this;
            c2.region = region;
            this.children.add(c2);
            c2.addNameSpace(region, nameSpace);
        }

        public RegionNameSpaces find(int offset) {
            if (this.children != null) {
                for (RegionNameSpaces c : this.children) {
                    if (c.region.getOffset() > offset || c.region.getOffset() + c.region.getLength() < offset) continue;
                    return c.find(offset);
                }
            }
            if (this.region == null) {
                return this;
            }
            if (this.region.getOffset() <= offset && this.region.getOffset() + this.region.getLength() >= offset) {
                return this;
            }
            return null;
        }

        public Map<String, List<INameSpace>> getNameSpacesByUri() {
            if (this.nameSpacesByUri == null) {
                this.nameSpacesByUri = new HashMap<String, List<INameSpace>>();
                HashSet<String> prefixes = new HashSet<String>();
                RegionNameSpaces s = this;
                while (s != null) {
                    for (String prefix : s.nameSpacesByPrefix.keySet()) {
                        if (prefixes.contains(prefix)) continue;
                        INameSpace n = s.nameSpacesByPrefix.get(prefix);
                        prefixes.add(prefix);
                        String uri = n.getURI();
                        List<INameSpace> list = this.nameSpacesByUri.get(uri);
                        if (list == null) {
                            list = new ArrayList<INameSpace>();
                            this.nameSpacesByUri.put(uri, list);
                        }
                        list.add(n);
                    }
                    s = s.parent;
                }
                XmlContextImpl.this.modifyNameSpacesByUri(this);
            }
            return this.nameSpacesByUri;
        }
    }
}

