/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.util.HttpUtil;
import org.jboss.tools.jst.web.kb.WebKbPlugin;

public class RemoteFileManager {
    private static final String PREFERENCE_KEY = "org.jboss.tools.jst.web.kb.preferences.rfm.";
    public static final String UNAVAILABLE_MAX_PREFERENCE = "org.jboss.tools.jst.web.kb.preferences.rfm.unavailableUrlsMax";
    public static final String UNAVAILABLE_TIMEOUT_PREFERENCE = "org.jboss.tools.jst.web.kb.preferences.rfm.unavailableUrlsTimeout";
    public static final String FILE_CACHE_MAX_PREFERENCE = "org.jboss.tools.jst.web.kb.preferences.rfm.unavailableUrlsMax";
    public static final String FILE_CACHE_TIMEOUT_PREFERENCE = "org.jboss.tools.jst.web.kb.preferences.rfm.unavailableUrlsTimeout";
    public static final String FILE_UPDATE_TIMEOUT_PREFERENCE = "org.jboss.tools.jst.web.kb.preferences.rfm.fileUpdateTimeout";
    public static final String DOWNLOADING_TIMEOUT_PREFERENCE = "org.jboss.tools.jst.web.kb.preferences.rfm.downloadingTimeout";
    public static final String DOWNLOADING_IF_MODIFIED_TIMEOUT_PREFERENCE = "org.jboss.tools.jst.web.kb.preferences.rfm.downloadingIfModifiedTimeout";
    private static final String FILE_SAVE = "rfm-save";
    private static final RemoteFileManager INSTANCE = new RemoteFileManager();
    private LimitedStringSet unavailableUrls;
    private Map<String, Monitor> downloading;
    private ISavedState lastSavedState;
    private Boolean initialized = false;
    private LimitedStringSet usedFiles;
    private long cssFileUpdateTimeout;
    private long downloadingTimeout;
    private int downloadingIfModifiedTimeout;

    public static RemoteFileManager getInstance() {
        return INSTANCE;
    }

    protected RemoteFileManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Boolean bl = this.initialized;
        synchronized (bl) {
            if (!this.initialized.booleanValue()) {
                IEclipsePreferences preferences = DefaultScope.INSTANCE.getNode("org.jboss.tools.jst.web.kb");
                int max = preferences.getInt("org.jboss.tools.jst.web.kb.preferences.rfm.unavailableUrlsMax", 500);
                long timeout = preferences.getLong("org.jboss.tools.jst.web.kb.preferences.rfm.unavailableUrlsTimeout", 180000L);
                this.unavailableUrls = new LimitedStringSet(max, timeout);
                this.downloading = new HashMap<String, Monitor>();
                int cacheMax = preferences.getInt("org.jboss.tools.jst.web.kb.preferences.rfm.unavailableUrlsMax", 100);
                long cacheTimeout = preferences.getLong("org.jboss.tools.jst.web.kb.preferences.rfm.unavailableUrlsTimeout", 2592000000L);
                this.usedFiles = new LimitedStringSet(cacheMax, cacheTimeout);
                this.cssFileUpdateTimeout = preferences.getLong(FILE_UPDATE_TIMEOUT_PREFERENCE, 900000L);
                this.downloadingTimeout = preferences.getLong(DOWNLOADING_TIMEOUT_PREFERENCE, 200L);
                this.downloadingIfModifiedTimeout = preferences.getInt(DOWNLOADING_IF_MODIFIED_TIMEOUT_PREFERENCE, 200);
                this.readState(this.lastSavedState);
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doneSaving(ISaveContext context) {
        Boolean bl = this.initialized;
        synchronized (bl) {
            if (this.initialized.booleanValue()) {
                File file = this.getSaveFile(context.getPreviousSaveNumber());
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(ISaveContext context) {
        Boolean bl = this.initialized;
        synchronized (bl) {
            if (this.initialized.booleanValue()) {
                File file = this.getSaveFile(context.getSaveNumber());
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savingState(ISaveContext context) {
        Boolean bl = this.initialized;
        synchronized (bl) {
            if (this.initialized.booleanValue()) {
                File file = this.getSaveFile(context.getSaveNumber());
                this.saveState(file);
                context.map((IPath)new Path(FILE_SAVE), (IPath)new Path(file.getName()));
                context.needSaveNumber();
            }
        }
    }

    private void saveState(File file) {
        File folder = this.getStorageFolder();
        if (folder != null) {
            File[] files;
            if (folder.isDirectory() && (files = folder.listFiles()) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!this.usedFiles.contains(f.getName())) {
                        f.delete();
                    }
                    ++n2;
                }
            }
            this.usedFiles.save(file);
        }
    }

    private void readState(File file) {
        this.usedFiles.load(file);
    }

    private File getSaveFile(int saveNumber) {
        String saveFileName = "rfm-save-" + Integer.toString(saveNumber);
        File file = WebKbPlugin.getDefault().getStateLocation().append(saveFileName).toFile();
        return file;
    }

    private void readState(ISavedState state) {
        IPath location;
        if (state != null && (location = state.lookup((IPath)new Path(FILE_SAVE))) != null) {
            File file = WebKbPlugin.getDefault().getStateLocation().append(location).toFile();
            this.readState(file);
        }
    }

    public void setLastSavedState(ISavedState state) {
        this.lastSavedState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getFile(String url) {
        this.init();
        Result result = new Result(true);
        if (!this.unavailableUrls.contains(url)) {
            File localFile;
            String file;
            URL fullUrl = null;
            try {
                fullUrl = new URL(url);
            }
            catch (MalformedURLException malformedURLException) {
                return new Result(true);
            }
            String protocol = fullUrl.getProtocol();
            if (("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) && !(file = fullUrl.getFile()).isEmpty() && (localFile = this.getLocalFile(fullUrl)) != null) {
                Monitor monitor = null;
                Monitor newMonitor = null;
                Map<String, Monitor> map = this.downloading;
                synchronized (map) {
                    monitor = this.downloading.get(url);
                    if (monitor == null) {
                        newMonitor = new Monitor();
                        result = this.getPath(localFile, newMonitor);
                        if (result != null) {
                            return result;
                        }
                        this.downloading.put(url, newMonitor);
                    }
                }
                if (monitor == null) {
                    DownloadingJob job = new DownloadingJob("Downloading CSS file from " + url, localFile, url, newMonitor);
                    job.setPriority(30);
                    job.schedule();
                    result = this.waitForDownloading(newMonitor, url);
                } else {
                    result = this.waitForDownloading(monitor, url);
                }
            }
        }
        return result;
    }

    private Result getPath(File file, Monitor monitor) {
        Result result = null;
        if (file.exists()) {
            long lastModified = file.lastModified();
            if (System.currentTimeMillis() - lastModified <= this.cssFileUpdateTimeout) {
                this.usedFiles.add(file.getName());
                try {
                    String path = file.getCanonicalPath();
                    result = new Result(path);
                }
                catch (IOException e) {
                    WebKbPlugin.getDefault().logError(e);
                }
            } else {
                monitor.update = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result waitForDownloading(Monitor monitor, String url) {
        Result result = null;
        try {
            Monitor monitor2 = monitor;
            synchronized (monitor2) {
                if (monitor.locked) {
                    monitor.wait(this.downloadingTimeout);
                    if (monitor.locked) {
                        result = new Result();
                    }
                }
            }
            if (result == null) {
                result = this.getFile(url);
            }
        }
        catch (InterruptedException interruptedException) {
            result = new Result();
        }
        return result;
    }

    private File getLocalFile(URL url) {
        File folder = this.getStorageFolder();
        if (folder != null) {
            String fileName = null;
            try {
                fileName = URLEncoder.encode(url.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
            File file = new File(folder, fileName);
            return file;
        }
        return null;
    }

    private File getStorageFolder() {
        WebKbPlugin plugin = WebKbPlugin.getDefault();
        if (plugin != null) {
            IPath path = plugin.getStateLocation();
            File file = new File(path.toFile(), "downloadedCssFiles");
            return file;
        }
        return null;
    }

    protected IDownloader getDownloader(File file, String url) {
        return new DownloaderImpl(file, url, this.downloadingIfModifiedTimeout);
    }

    private static class DownloaderImpl
    implements IDownloader {
        private File file;
        private String url;
        private int timeout;

        public DownloaderImpl(File file, String url, int timeout) {
            this.file = file;
            this.url = url;
            this.timeout = timeout;
        }

        @Override
        public InputStreamReader getInputStream(boolean ifModified) throws IOException {
            InputStreamReader in = null;
            if (ifModified) {
                HttpURLConnection connection = HttpUtil.createHttpURLConnection((String)this.url, (int)this.timeout);
                connection.setIfModifiedSince(this.file.lastModified());
                if (connection != null) {
                    in = HttpUtil.getInputStreamReader((HttpURLConnection)connection);
                    if (in != null) {
                        this.file.delete();
                    } else {
                        this.file.setLastModified(System.currentTimeMillis());
                    }
                }
            } else {
                in = HttpUtil.getInputStreamReader((String)this.url, (int)2000);
            }
            return in;
        }
    }

    private class DownloadingJob
    extends Job {
        private File file;
        private String url;
        private Monitor monitor;
        private IDownloader downloader;

        public DownloadingJob(String name, File file, String url, Monitor monitor) {
            super(name);
            this.file = file;
            this.url = url;
            this.setSystem(true);
            this.monitor = monitor;
            this.downloader = RemoteFileManager.this.getDownloader(file, url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor progressMonitor) {
            block34: {
                InputStreamReader in = null;
                boolean log = false;
                try {
                    in = this.downloader.getInputStream(this.monitor.update);
                    if (in == null) {
                        RemoteFileManager.this.unavailableUrls.add(this.url);
                    } else {
                        log = true;
                        this.file.getParentFile().mkdirs();
                        FileOutputStream out = new FileOutputStream(this.file);
                        IOUtils.copy((Reader)in, (OutputStream)out);
                    }
                }
                catch (IOException e) {
                    if (!this.monitor.update) {
                        RemoteFileManager.this.unavailableUrls.add(this.url);
                    }
                    if (log) {
                        WebKbPlugin.getDefault().logError(e);
                    }
                    IOUtils.closeQuietly((Reader)in);
                    Object object = RemoteFileManager.this.downloading;
                    synchronized (object) {
                        RemoteFileManager.this.downloading.remove(this.url);
                    }
                    object = this.monitor;
                    synchronized (object) {
                        this.monitor.locked = false;
                        this.monitor.notifyAll();
                        break block34;
                    }
                }
                catch (Exception e) {
                    try {
                        RemoteFileManager.this.unavailableUrls.add(this.url);
                        WebKbPlugin.getDefault().logError(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        Object object = RemoteFileManager.this.downloading;
                        synchronized (object) {
                            RemoteFileManager.this.downloading.remove(this.url);
                        }
                        object = this.monitor;
                        synchronized (object) {
                            this.monitor.locked = false;
                            this.monitor.notifyAll();
                        }
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)in);
                    Object object = RemoteFileManager.this.downloading;
                    synchronized (object) {
                        RemoteFileManager.this.downloading.remove(this.url);
                    }
                    object = this.monitor;
                    synchronized (object) {
                        this.monitor.locked = false;
                        this.monitor.notifyAll();
                        break block34;
                    }
                }
                IOUtils.closeQuietly((Reader)in);
                Object object = RemoteFileManager.this.downloading;
                synchronized (object) {
                    RemoteFileManager.this.downloading.remove(this.url);
                }
                object = this.monitor;
                synchronized (object) {
                    this.monitor.locked = false;
                    this.monitor.notifyAll();
                }
            }
            return Status.OK_STATUS;
        }
    }

    public static enum DownloadingStatus {
        DOWNLOADED,
        DOWNLOADING,
        UNAVAILABLE;

    }

    public static interface IDownloader {
        public InputStreamReader getInputStream(boolean var1) throws IOException;
    }

    private static class LimitedStringSet {
        private int size;
        private long timeout;
        private TreeSet<TimestampedString> set = new TreeSet();
        private Map<String, TimestampedString> map = new HashMap<String, TimestampedString>();

        public LimitedStringSet(int size, long timeoutInMillis) {
            this.size = size;
            this.timeout = timeoutInMillis;
        }

        public synchronized void add(String string) {
            TimestampedString oldTs = this.map.get(string);
            TimestampedString newTs = new TimestampedString(string);
            this.map.put(string, newTs);
            if (oldTs == null) {
                this.set.add(newTs);
                while (this.set.size() > this.size) {
                    TimestampedString removed = this.set.pollFirst();
                    if (removed == null) continue;
                    this.map.remove(removed.string);
                }
            } else if (!oldTs.equals(newTs)) {
                this.set.add(newTs);
                this.set.remove(oldTs);
            }
        }

        public synchronized boolean contains(String string) {
            TimestampedString oldTs = this.map.get(string);
            if (oldTs != null) {
                long time = System.currentTimeMillis() - this.timeout;
                if (oldTs.timestamp > time) {
                    return true;
                }
                this.map.remove(oldTs.string);
                this.set.remove(oldTs);
            }
            return false;
        }

        public synchronized void save(File file) {
            StringBuilder sb = new StringBuilder();
            for (TimestampedString ts : this.set) {
                sb.append(ts.string).append(" ").append(ts.timestamp).append(" ");
            }
            if (sb.length() > 0) {
                FileUtil.writeFile((File)file, (String)sb.toString());
            }
        }

        private synchronized void reset() {
            this.set = new TreeSet();
            this.map = new HashMap<String, TimestampedString>();
        }

        public synchronized void load(File file) {
            this.reset();
            String content = FileUtil.readFile((File)file);
            StringTokenizer st = new StringTokenizer(content, " ");
            while (st.hasMoreTokens()) {
                String string = st.nextToken();
                if (!st.hasMoreTokens()) {
                    WebKbPlugin.getDefault().logError("Corrupted JBT KB remote file manager state file: " + file.getAbsolutePath());
                    this.reset();
                    return;
                }
                String timestampStr = st.nextToken();
                long timestamp = 0L;
                try {
                    timestamp = Long.parseLong(timestampStr);
                }
                catch (NumberFormatException e) {
                    WebKbPlugin.getDefault().logError(e);
                    this.reset();
                    return;
                }
                TimestampedString ts = new TimestampedString(string, timestamp);
                this.set.add(ts);
                this.map.put(string, ts);
            }
        }
    }

    private static class Monitor {
        boolean locked = true;
        boolean update;

        private Monitor() {
        }
    }

    public static class Result {
        private String localPath;
        private DownloadingStatus status;

        public Result() {
            this(false);
        }

        public Result(boolean unavailable) {
            this.status = unavailable ? DownloadingStatus.UNAVAILABLE : DownloadingStatus.DOWNLOADING;
        }

        public Result(String localPath) {
            this.localPath = localPath;
            this.status = DownloadingStatus.DOWNLOADED;
        }

        public String getLocalPath() {
            return this.localPath;
        }

        public void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public DownloadingStatus getStatus() {
            return this.status;
        }

        public void setStatus(DownloadingStatus status) {
            this.status = status;
        }

        public boolean isReady() {
            return this.status == DownloadingStatus.DOWNLOADED;
        }
    }

    private static class TimestampedString
    implements Comparable<TimestampedString> {
        String string;
        long timestamp;

        public TimestampedString(String string) {
            this(string, System.currentTimeMillis());
        }

        public TimestampedString(String string, long timestamp) {
            this.string = string;
            this.timestamp = timestamp;
        }

        public int hashCode() {
            return this.string.hashCode() + (int)this.timestamp;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TimestampedString) {
                TimestampedString ts = (TimestampedString)obj;
                return this.string.equals(ts.string) && this.timestamp == ts.timestamp;
            }
            return super.equals(obj);
        }

        @Override
        public int compareTo(TimestampedString o) {
            return (String.valueOf(this.timestamp) + this.string).compareTo(String.valueOf(o.timestamp) + o.string);
        }

        public String toString() {
            return "{" + this.string + ":" + this.timestamp + "}";
        }
    }
}

