/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.jboss.tools.jst.web.kb.taglib.INameSpaceStorage;
import org.w3c.dom.Element;

public class NameSpaceStorage
implements INameSpaceStorage {
    KbProject project;
    private Map<String, Set<String>> urisByPrefix = new HashMap<String, Set<String>>();
    static final String ELEMENT_URIS = "uris";
    static final String ELEMENT_URI = "uri";
    static final String ELEMENT_PREFIX = "prefix";

    public NameSpaceStorage(KbProject project) {
        this.project = project;
    }

    @Override
    public synchronized void add(String prefix, String uri) {
        Set<String> uris = this.urisByPrefix.get(prefix);
        if (!(uris != null && uris.contains(uri) || this.project.getTagLibraries(uri).length != 0)) {
            return;
        }
        if (uris == null) {
            uris = new HashSet<String>();
            this.urisByPrefix.put(prefix, uris);
        }
        uris.add(uri);
    }

    @Override
    public synchronized Set<String> getURIs(String prefix) {
        HashSet<String> result = new HashSet<String>();
        Set<String> urls = this.urisByPrefix.get(prefix);
        if (urls != null) {
            result.addAll(urls);
        }
        return result;
    }

    @Override
    public synchronized Set<String> getPrefixes(String prefixMask) {
        HashSet<String> result = new HashSet<String>();
        for (String prefix : this.urisByPrefix.keySet()) {
            Set<String> urls;
            if (!prefix.startsWith(prefixMask) || (urls = this.urisByPrefix.get(prefix)).isEmpty()) continue;
            result.add(prefix);
        }
        return result;
    }

    public synchronized void clear() {
        this.urisByPrefix.clear();
    }

    public synchronized void store(Element root) {
        Element urisElement = XMLUtilities.createElement((Element)root, (String)ELEMENT_URIS);
        Map<String, Set<String>> uris = this.revert();
        for (String uri : uris.keySet()) {
            Element uriElement = XMLUtilities.createElement((Element)urisElement, (String)ELEMENT_URI);
            uriElement.setAttribute("value", uri);
            Set<String> prefixes = uris.get(uri);
            for (String prefix : prefixes) {
                Element prefixElement = XMLUtilities.createElement((Element)uriElement, (String)ELEMENT_PREFIX);
                prefixElement.setTextContent(prefix);
            }
        }
    }

    public synchronized void load(Element root) {
        Element urisElement = XMLUtilities.getUniqueChild((Element)root, (String)ELEMENT_URIS);
        if (urisElement != null) {
            Element[] elementArray = XMLUtilities.getChildren((Element)urisElement, (String)ELEMENT_URI);
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element uriElement = elementArray[n2];
                String uri = uriElement.getAttribute("value");
                Element[] elementArray2 = XMLUtilities.getChildren((Element)uriElement, (String)ELEMENT_PREFIX);
                int n3 = elementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Element prefixElement = elementArray2[n4];
                    String prefix = prefixElement.getTextContent();
                    if (prefix != null && uri != null && prefix.length() > 0 && uri.length() > 0) {
                        this.add(prefix, uri);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private Map<String, Set<String>> revert() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String prefix : this.urisByPrefix.keySet()) {
            Set<String> uris = this.urisByPrefix.get(prefix);
            for (String uri : uris) {
                HashSet<String> prefixes = (HashSet<String>)result.get(uri);
                if (prefixes == null) {
                    prefixes = new HashSet<String>();
                    result.put(uri, prefixes);
                }
                prefixes.add(prefix);
            }
        }
        return result;
    }
}

