/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.jst.web.kb.IBrowserDataProvider;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.WebKbPlugin;

public class BrowserDataProviderManager {
    public static final String ELEMENT_ID_PARAM = "idParamName";
    public static final String ELEMENT_ID_VALUE_PARAM = "idParamValue";
    public static final Object DATA_LOADING = new Object();
    private static final BrowserDataProviderManager INSTANCE = new BrowserDataProviderManager();
    private Set<IBrowserDataProvider> providers;

    private BrowserDataProviderManager() {
    }

    public static BrowserDataProviderManager getInstance() {
        return INSTANCE;
    }

    private void init() {
        if (this.providers == null) {
            this.providers = new HashSet<IBrowserDataProvider>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.jboss.tools.jst.web.kb.browserDataProvider");
            if (extensionPoint != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] elements;
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        String className = element.getAttribute("class");
                        if (className != null) {
                            try {
                                Object obj = element.createExecutableExtension("class");
                                if (obj instanceof IBrowserDataProvider) {
                                    this.providers.add((IBrowserDataProvider)obj);
                                } else {
                                    WebKbPlugin.getDefault().logError("Browser Data Provider (class name: " + className + ", contributer: " + element.getContributor().getName() + ") must implement " + IBrowserDataProvider.class.getName());
                                }
                            }
                            catch (CoreException e) {
                                WebKbPlugin.getDefault().logError(e);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }

    public Collection<Object> evaluate(String js, IPageContext pageContext) {
        this.init();
        HashSet<Object> results = new HashSet<Object>();
        for (IBrowserDataProvider provider : this.providers) {
            Object result = provider.evaluate(js, pageContext);
            results.add(result);
        }
        return results;
    }

    public static String format(String js, Map<String, String> parameters) {
        for (String name : parameters.keySet()) {
            js = js.replaceAll("#\\{" + name + "\\}", parameters.get(name));
        }
        return js;
    }
}

