/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.include;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.jboss.tools.jst.web.kb.include.IncludeContextDefinition;

public class IncludeContextBuilder
extends RegistryReader {
    public static final String[] EMPTY = new String[0];
    public static final String PL_INCLUDE = "KbIncludeContext";
    public static final String TAG_INCLUDE = "include";
    public static final String TAG_TAG = "tag";
    public static final String TAG_ATTRIBUTE = "attribute";
    public static final String TAG_CONTEXTTYPE = "contexttype";
    public static final String TAG_CONTENTTYPE = "contenttype";
    public static final String TAG_CSSHOLDER = "cssholder";
    public static final String TAG_JSF2CSSHOLDER = "jsf2cssholder";
    public static final String ATT_ID = "id";
    public static final String ATT_URI = "uri";
    public static final String ATT_NAME = "name";
    private final List<IncludeContextDefinition> fIncludeContextDefs = new ArrayList<IncludeContextDefinition>();
    private IncludeContextDefinition fCurrentIncludeDefinition;
    private static final IncludeContextBuilder fInstance = new IncludeContextBuilder();

    private IncludeContextBuilder() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.readRegistry(registry, "org.jboss.tools.jst.web.kb", PL_INCLUDE);
    }

    public static IncludeContextBuilder getInstance() {
        return fInstance;
    }

    public static String getId(IConfigurationElement element) {
        return element.getAttribute(ATT_ID);
    }

    private static String getUri(IConfigurationElement element) {
        return element.getAttribute(ATT_URI);
    }

    public static String getName(IConfigurationElement element) {
        return element.getAttribute(ATT_NAME);
    }

    private void processIncludeContextElement(IConfigurationElement element) {
        String theUri = IncludeContextBuilder.getUri(element);
        theUri = theUri == null ? "" : theUri;
        this.fCurrentIncludeDefinition = this.getIncludeContextDefinition(theUri);
        if (this.fCurrentIncludeDefinition == null) {
            this.fCurrentIncludeDefinition = new IncludeContextDefinition(theUri);
            this.fIncludeContextDefs.add(this.fCurrentIncludeDefinition);
        }
    }

    private IncludeContextDefinition getIncludeContextDefinition(String uri) {
        for (IncludeContextDefinition def : this.fIncludeContextDefs) {
            if (!uri.equals(def.getUri())) continue;
            return def;
        }
        return null;
    }

    private void processTagElement(IConfigurationElement element) {
        String theName = IncludeContextBuilder.getName(element);
        if (this.fCurrentIncludeDefinition != null && theName != null) {
            this.fCurrentIncludeDefinition.addTag(theName, element);
        }
    }

    private void processAttributeElement(IConfigurationElement element) {
        String theName = IncludeContextBuilder.getName(element);
        if (this.fCurrentIncludeDefinition != null && theName != null) {
            this.fCurrentIncludeDefinition.addTagAttribute(theName, element);
        }
    }

    private void processContextTypeElement(IConfigurationElement element) {
        String theId = IncludeContextBuilder.getId(element);
        if (this.fCurrentIncludeDefinition != null && theId != null) {
            this.fCurrentIncludeDefinition.addContextType(theId, element);
        }
    }

    private boolean processContentTypeElement(IConfigurationElement element) {
        String theId = IncludeContextBuilder.getId(element);
        return this.fCurrentIncludeDefinition != null && theId != null && this.fCurrentIncludeDefinition.addContentType(theId, element);
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(TAG_INCLUDE) || tag.equals(TAG_CSSHOLDER) || tag.equals(TAG_JSF2CSSHOLDER)) {
            this.processIncludeContextElement(element);
            if (this.fCurrentIncludeDefinition != null) {
                this.readElementChildren(element);
            }
        } else if (tag.equals(TAG_TAG)) {
            this.processTagElement(element);
            if (this.fCurrentIncludeDefinition != null) {
                this.readElementChildren(element);
            }
        } else if (tag.equals(TAG_ATTRIBUTE)) {
            this.processAttributeElement(element);
        } else if (tag.equals(TAG_CONTEXTTYPE)) {
            this.processContextTypeElement(element);
            if (this.fCurrentIncludeDefinition != null) {
                this.readElementChildren(element);
            }
        } else {
            if (tag.equals(TAG_CONTENTTYPE)) {
                return this.processContentTypeElement(element);
            }
            return false;
        }
        return true;
    }

    public static String[] getIncludeAttributes(String uri, String tagName) {
        List<IncludeContextDefinition> defs = IncludeContextBuilder.fInstance.fIncludeContextDefs;
        String[] result = EMPTY;
        if (!defs.isEmpty()) {
            ArrayList<String> attrs = new ArrayList<String>();
            for (IncludeContextDefinition def : defs) {
                String[] defAttrs;
                if (!uri.equals(def.getUri())) continue;
                String[] stringArray = defAttrs = def.getIncludeTagAttributes(tagName);
                int n = defAttrs.length;
                int n2 = 0;
                while (n2 < n) {
                    String attr = stringArray[n2];
                    attrs.add(attr);
                    ++n2;
                }
            }
            if (!attrs.isEmpty()) {
                result = attrs.toArray(new String[attrs.size()]);
            }
        }
        return result;
    }

    public static String getContextType(String contentType) {
        if (contentType != null) {
            List<IncludeContextDefinition> defs = IncludeContextBuilder.fInstance.fIncludeContextDefs;
            for (IncludeContextDefinition def : defs) {
                String contextType = def.getContextType(contentType);
                if (contextType == null) continue;
                return contextType;
            }
        }
        return null;
    }

    public static boolean isCSSStyleSheetContainer(String uri, String tagName) {
        boolean isHolder = false;
        List<IncludeContextDefinition> defs = IncludeContextBuilder.fInstance.fIncludeContextDefs;
        for (IncludeContextDefinition def : defs) {
            String[] defTags;
            if (!uri.equals(def.getUri())) continue;
            String[] stringArray = defTags = def.getCSSTags();
            int n = defTags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (tagName.equals(tag) || uri.length() == 0 && tagName.equalsIgnoreCase(tag)) {
                    isHolder = true;
                    String[] attrs = def.getCSSTagAttributes(tagName);
                    isHolder ^= attrs != null && attrs.length > 0;
                }
                ++n2;
            }
        }
        return isHolder;
    }

    public static boolean isJSF2CSSStyleSheetContainer(String uri, String tagName) {
        boolean isHolder = false;
        List<IncludeContextDefinition> defs = IncludeContextBuilder.fInstance.fIncludeContextDefs;
        for (IncludeContextDefinition def : defs) {
            String[] defTags;
            if (!uri.equals(def.getUri())) continue;
            String[] stringArray = defTags = def.getJSF2CSSTags();
            int n = defTags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (tagName.equals(tag) || uri.length() == 0 && tagName.equalsIgnoreCase(tag)) {
                    isHolder = true;
                    String[] attrs = def.getJSF2CSSTagAttributes(tagName);
                    isHolder ^= attrs != null && attrs.length > 0;
                }
                ++n2;
            }
        }
        return isHolder;
    }

    public static String[] getCSSStyleSheetAttributes(String uri, String tagName) {
        String[] result = EMPTY;
        List<IncludeContextDefinition> defs = IncludeContextBuilder.fInstance.fIncludeContextDefs;
        if (!defs.isEmpty()) {
            ArrayList<String> attrs = new ArrayList<String>();
            for (IncludeContextDefinition def : defs) {
                String[] defAttrs;
                if (!uri.equals(def.getUri())) continue;
                String[] stringArray = defAttrs = def.getCSSTagAttributes(tagName);
                int n = defAttrs.length;
                int n2 = 0;
                while (n2 < n) {
                    String attr = stringArray[n2];
                    attrs.add(attr);
                    ++n2;
                }
            }
            if (!attrs.isEmpty()) {
                result = attrs.toArray(new String[attrs.size()]);
            }
        }
        return result;
    }

    public static String[] getJSF2CSSStyleSheetAttributes(String uri, String tagName) {
        String[] result = EMPTY;
        if (uri != null) {
            List<IncludeContextDefinition> defs = IncludeContextBuilder.fInstance.fIncludeContextDefs;
            ArrayList<String> attrs = new ArrayList<String>();
            for (IncludeContextDefinition def : defs) {
                String[] defAttrs;
                if (!uri.equals(def.getUri()) || (defAttrs = def.getJSF2CSSTagAttributes(tagName)) == null) continue;
                String[] stringArray = defAttrs;
                int n = defAttrs.length;
                int n2 = 0;
                while (n2 < n) {
                    String attr = stringArray[n2];
                    attrs.add(attr);
                    ++n2;
                }
            }
            result = attrs.toArray(new String[attrs.size()]);
        }
        return result;
    }
}

