/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.el;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.core.resolver.ELSegmentImpl;
import org.jboss.tools.common.el.core.resolver.IOpenableReference;
import org.jboss.tools.common.el.core.resolver.MessagePropertyELSegment;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.StringUtil;

public class MessagePropertyELSegmentImpl
extends ELSegmentImpl
implements MessagePropertyELSegment {
    private IFile messageBundleResource = null;
    private ITextSourceReference messagePropertySourceReference = null;
    private int propertyStart = 0;
    private int propertyLength = 0;
    private String baseName = null;
    private boolean isBundle = false;
    private List<XModelObject> objects = new ArrayList<XModelObject>();

    public MessagePropertyELSegmentImpl(LexicalToken token) {
        super(token);
    }

    public IFile getMessageBundleResource() {
        return this.messageBundleResource;
    }

    public void setMessageBundleResource(IFile resource) {
        this.messageBundleResource = resource;
        this.setResource((IResource)resource);
    }

    public void setBundleOnlySegment(boolean set) {
        this.isBundle = set;
    }

    public boolean isBundle() {
        return this.isBundle;
    }

    public boolean isProperty() {
        return !this.isBundle && this.messagePropertySourceReference != null;
    }

    public ITextSourceReference getMessagePropertySourceReference() {
        if (this.messagePropertySourceReference == null) {
            this.messagePropertySourceReference = new ITextSourceReference(){

                public int getStartPosition() {
                    return MessagePropertyELSegmentImpl.this.propertyStart;
                }

                public int getLength() {
                    return MessagePropertyELSegmentImpl.this.propertyLength;
                }

                public IResource getResource() {
                    return MessagePropertyELSegmentImpl.this.resource;
                }
            };
        }
        return this.messagePropertySourceReference;
    }

    public void setMessagePropertySourceReference(int start, int lenght) {
        this.propertyStart = start;
        this.propertyLength = lenght;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String name) {
        this.baseName = name;
    }

    public void addObject(XModelObject object) {
        this.objects.add(object);
    }

    public List<XModelObject> getObjects() {
        return this.objects;
    }

    public IOpenableReference[] getOpenable() {
        if (this.objects != null) {
            IOpenableReference[] result = new IOpenableReference[this.objects.size()];
            int i = 0;
            while (i < this.objects.size()) {
                final XModelObject o = this.objects.get(i);
                result[i] = new IOpenableReference(){

                    public boolean open() {
                        int q = FindObjectHelper.findModelObject((XModelObject)o, (int)FindObjectHelper.IN_EDITOR_ONLY);
                        return q < 1;
                    }

                    public String getLabel() {
                        String propertyName;
                        String baseName = MessagePropertyELSegmentImpl.this.getBaseName();
                        String string = propertyName = MessagePropertyELSegmentImpl.this.isBundle() ? null : StringUtil.trimQuotes((String)MessagePropertyELSegmentImpl.this.getToken().getText());
                        if (propertyName == null) {
                            return MessageFormat.format(ElCoreMessages.OpenBundle, baseName);
                        }
                        return MessageFormat.format(ElCoreMessages.OpenBundleProperty, propertyName, baseName);
                    }

                    public Image getImage() {
                        return null;
                    }
                };
                ++i;
            }
            return result;
        }
        return super.getOpenable();
    }
}

