/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb.action;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IMarkerResolution;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.scanner.UsedJavaProjectCheck;

public class EnableKBOnProject
implements IMarkerResolution {
    String label;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void run(IMarker marker) {
        IProject project;
        IResource resource = marker.getResource();
        Object object = resource instanceof IProject ? (IProject)resource : (project = resource != null ? resource.getProject() : null);
        if (project == null) {
            return;
        }
        try {
            WebKbPlugin.enableKB(project, (IProgressMonitor)new NullProgressMonitor());
            List<IProject> ps = new UsedJavaProjectCheck().getNonKbJavaProjects(project);
            for (IProject p : ps) {
                WebKbPlugin.enableKB(p, (IProgressMonitor)new NullProgressMonitor());
                p.deleteMarkers("org.jboss.tools.jst.web.kb.kbBuilderProblemMarker", true, 1);
            }
            project.deleteMarkers("org.jboss.tools.jst.web.kb.kbBuilderProblemMarker", true, 1);
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
    }
}

