/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.css.core.internal.provisional.adapters.IModelProvideAdapter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.html.core.internal.htmlcss.LinkElementAdapter;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.GlobalELReferenceList;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELContextImpl;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.common.el.core.resolver.ElVarSearcher;
import org.jboss.tools.common.el.core.resolver.SimpleELContext;
import org.jboss.tools.common.el.core.resolver.Var;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.common.util.EclipseUIUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.common.validation.ValidationELReference;
import org.jboss.tools.jst.web.WebUtils;
import org.jboss.tools.jst.web.kb.ICSSContainerSupport;
import org.jboss.tools.jst.web.kb.IIncludedContextSupport;
import org.jboss.tools.jst.web.kb.IKbProject;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbProjectFactory;
import org.jboss.tools.jst.web.kb.ProjectURLModelProvider;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.include.IncludeContextBuilder;
import org.jboss.tools.jst.web.kb.include.PageInclude;
import org.jboss.tools.jst.web.kb.internal.FaceletPageContextImpl;
import org.jboss.tools.jst.web.kb.internal.JspContextImpl;
import org.jboss.tools.jst.web.kb.internal.RemoteFileManager;
import org.jboss.tools.jst.web.kb.internal.ResourceBundle;
import org.jboss.tools.jst.web.kb.internal.XmlContextImpl;
import org.jboss.tools.jst.web.kb.internal.taglib.NameSpace;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.jboss.tools.jst.web.kb.taglib.TagLibraryManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleSheet;

public class PageContextFactory
implements IResourceChangeListener {
    private static PageContextFactory fInstance = new PageContextFactory();
    private static final String XHTML_TAG_LIB_URI = "http://www.w3.org/1999/xhtml";
    public static final String XML_PAGE_CONTEXT_TYPE = "XML_PAGE_CONTEXT_TYPE";
    public static final String JSP_PAGE_CONTEXT_TYPE = "JSP_PAGE_CONTEXT_TYPE";
    public static final String FACELETS_PAGE_CONTEXT_TYPE = "FACELETS_PAGE_CONTEXT_TYPE";
    private static final String JAVA_PROPERTIES_CONTENT_TYPE = "org.eclipse.jdt.core.javaProperties";
    public static final String EL_START_1 = "#{";
    public static final String EL_START_2 = "${";
    Map<IFile, DocListener> listeners = new HashMap<IFile, DocListener>();
    PartListener partListener;
    private Map<IFile, SimpleELContext> cache = new HashMap<IFile, SimpleELContext>();
    static String TAG_COMPOSITION = "composition";
    static String TAG_DECORATE = "decorate";
    static String ATTR_TEMPLATE = "template";
    static String ATTR_SRC = "src";
    static String NODE_PARAM = "param";
    static String ATTR_NAME = "name";
    static String ATTR_VALUE = "value";
    static Map<String, String> PATH_ATTRIBUTES = new HashMap<String, String>();
    private static final String JSF2_RESOURCES_FOLDER = "/resources";
    private static final String DOLLAR_PREFIX = "${";
    private static final String SUFFIX = "}";
    private static final String SHARP_PREFIX = "#{";
    public static final String CONTEXT_PATH_EXPRESSION = "^\\s*(\\#|\\$)\\{facesContext.externalContext.requestContextPath\\}";

    static {
        PATH_ATTRIBUTES.put(TAG_COMPOSITION, ATTR_TEMPLATE);
        PATH_ATTRIBUTES.put(TAG_DECORATE, ATTR_TEMPLATE);
        PATH_ATTRIBUTES.put("include", ATTR_SRC);
    }

    public static final PageContextFactory getInstance() {
        return fInstance;
    }

    public static boolean isPage(IFile file) {
        IContentType type = IDE.getContentType((IFile)file);
        String typeId = type == null ? null : type.getId();
        return JSP_PAGE_CONTEXT_TYPE.equals(typeId = IncludeContextBuilder.getContextType(typeId)) || FACELETS_PAGE_CONTEXT_TYPE.equals(typeId);
    }

    private PageContextFactory() {
        this.partListener = new PartListener();
        this.initDocumentListeners();
    }

    private void initDocumentListeners() {
        IWorkbenchWindow[] ws;
        IWorkbenchWindow[] iWorkbenchWindowArray = ws = WebKbPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int n = ws.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.initDocumentListenersForWindow(window);
            ++n2;
        }
        WebKbPlugin.getDefault().getWorkbench().addWindowListener((IWindowListener)new WindowListener());
    }

    void initDocumentListenersForWindow(IWorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor != null) {
                this.addListenerToPart(editor);
            }
            ++n2;
        }
        page.addPartListener((IPartListener)this.partListener);
    }

    private void addListenerToPart(IEditorPart editor) {
        IFileEditorInput i;
        IFile file;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (file = (i = (IFileEditorInput)input).getFile()) != null) {
            DocListener listener = this.listeners.get(file);
            if (listener == null) {
                IDocument doc = this.getConnectedDocument(input);
                if (doc != null) {
                    listener = new DocListener(file, doc);
                }
            } else {
                listener.add();
            }
        }
    }

    private IDocument getConnectedDocument(IEditorInput input) {
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input);
        IDocument result = null;
        try {
            provider.connect((Object)input);
            result = provider.getDocument((Object)input);
            provider.disconnect((Object)input);
        }
        catch (CoreException e) {
            WebKbPlugin.getDefault().logError(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleELContext getSavedContext(IFile resource) {
        Map<IFile, SimpleELContext> map = this.cache;
        synchronized (map) {
            return this.cache.get(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConvext(SimpleELContext context) {
        if (context.getResource() != null) {
            Map<IFile, SimpleELContext> map = this.cache;
            synchronized (map) {
                this.cache.put(context.getResource(), context);
            }
        }
    }

    public static ELContext createPageContext(IDocument document) {
        return PageContextFactory.createPageContext(document, null, false);
    }

    public static ELContext createPageContext(IDocument document, boolean dontUseCache) {
        return PageContextFactory.createPageContext(document, null, dontUseCache);
    }

    public static ELContext createPageContext(IDocument document, String contextType) {
        return PageContextFactory.createPageContext(document, null, contextType, false);
    }

    public static ELContext createPageContext(IDocument document, String contextType, boolean dontUseCache) {
        return PageContextFactory.createPageContext(document, null, contextType, dontUseCache);
    }

    public static ELContext createPageContext(IFile file) {
        return PageContextFactory.createPageContext(file, null);
    }

    public static ELContext createPageContext(IFile file, String contextType) {
        return PageContextFactory.createPageContext(null, file, null);
    }

    public static ELContext createPageContext(IDocument document, IFile file, String contextType) {
        return PageContextFactory.getInstance().createPageContext(document, file, new ArrayList<String>(), contextType, false);
    }

    public static ELContext createPageContext(IDocument document, IFile file, String contextType, boolean dontUseCache) {
        return PageContextFactory.getInstance().createPageContext(document, file, new ArrayList<String>(), contextType, dontUseCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(IFile file) {
        Map<IFile, SimpleELContext> map = this.cache;
        synchronized (map) {
            ELContext removedContext = (ELContext)this.cache.remove(file);
            if (removedContext == null || removedContext.getResource() == null) {
                return;
            }
            ELContext[] contexts = null;
            contexts = this.cache.values().toArray(new ELContext[this.cache.values().size()]);
            if (contexts != null) {
                ELContext[] eLContextArray = contexts;
                int n = contexts.length;
                int n2 = 0;
                while (n2 < n) {
                    ELContext context = eLContextArray[n2];
                    if (PageContextFactory.isDependencyContext(context, file)) {
                        this.cache.remove(file);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(IProject project) {
        Map<IFile, SimpleELContext> map = this.cache;
        synchronized (map) {
            IFile[] files;
            IFile[] iFileArray = files = this.cache.keySet().toArray(new IFile[this.cache.size()]);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (project.equals((Object)file.getProject())) {
                    this.cleanUp(file);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(IResourceDelta delta) {
        Map<IFile, SimpleELContext> map = this.cache;
        synchronized (map) {
            if (!this.cache.isEmpty() && PageContextFactory.checkDelta(delta)) {
                this.processDelta(delta);
            }
        }
    }

    private SimpleELContext createPropertiesContext(IFile file, IDocument document, boolean useLastSavedStateOfFile) {
        ELContextImpl context = new ELContextImpl();
        context.setResource(file);
        context.setElResolvers(ELResolverFactoryManager.getInstance().getResolvers((IResource)file));
        String content = null;
        content = document == null || useLastSavedStateOfFile ? FileUtil.getContentFromEditorOrFile((IFile)file) : document.get();
        if (content.indexOf(123) > -1 && content.indexOf("#{") > -1 || content.indexOf("${") > -1) {
            ValidationELReference elReference = new ValidationELReference();
            elReference.setResource(file);
            elReference.setLength(content.length());
            elReference.setStartPosition(0);
            context.addELReference((ELReference)elReference);
        }
        return context;
    }

    private static SimpleELContext createJavaContext(IFile file, IDocument document, boolean useLastSavedStateOfFile) {
        ELContextImpl context = new ELContextImpl();
        context.setResource(file);
        context.setElResolvers(ELResolverFactoryManager.getInstance().getResolvers((IResource)file));
        FastJavaPartitionScanner scaner = new FastJavaPartitionScanner();
        if (document == null || useLastSavedStateOfFile) {
            String content = FileUtil.getContentFromEditorOrFile((IFile)file);
            document = new Document(content);
        }
        scaner.setRange(document, 0, document.getLength());
        IToken token = scaner.nextToken();
        while (token != null && token != Token.EOF) {
            if ("__java_string".equals(token.getData())) {
                int length = scaner.getTokenLength();
                int offset = scaner.getTokenOffset();
                String value = null;
                try {
                    value = document.get(offset, length);
                }
                catch (BadLocationException e) {
                    WebKbPlugin.getDefault().logError(e);
                    return null;
                }
                if (value.indexOf(123) > -1) {
                    int startEl = value.indexOf("#{");
                    if (startEl == -1) {
                        startEl = value.indexOf("${");
                    }
                    if (startEl > -1) {
                        ValidationELReference elReference = new ValidationELReference();
                        elReference.setResource(file);
                        elReference.setLength(value.length());
                        elReference.setStartPosition(offset);
                        try {
                            elReference.setLineNumber(document.getLineOfOffset(startEl));
                        }
                        catch (BadLocationException e) {
                            WebKbPlugin.getDefault().logError(e);
                        }
                        context.addELReference((ELReference)elReference);
                    }
                }
            }
            token = scaner.nextToken();
        }
        return context;
    }

    private ELContext createPageContext(IDocument document, IFile file, List<String> parents, String defaultContextType, boolean dontUseCache) {
        SimpleELContext context;
        if (file == null) {
            file = PageContextFactory.getResource(document);
        }
        boolean modified = EclipseUIUtil.isOpenInActiveEditor((IFile)file);
        boolean isContextCachingAllowed = !dontUseCache && !modified;
        SimpleELContext simpleELContext = context = isContextCachingAllowed ? this.getSavedContext(file) : null;
        if (context == null) {
            block24: {
                String typeId = this.getContentTypeIdentifier(file == null ? document : file);
                if ("org.eclipse.jdt.core.javaSource".equalsIgnoreCase(typeId)) {
                    context = PageContextFactory.createJavaContext(file, document, !dontUseCache);
                } else if (JAVA_PROPERTIES_CONTENT_TYPE.equalsIgnoreCase(typeId)) {
                    context = this.createPropertiesContext(file, document, !dontUseCache);
                } else if (file != null && this.isXMLWithoutEL(file)) {
                    IProject project = file != null ? file.getProject() : PageContextFactory.getActiveProject();
                    context = new SimpleELContext();
                    context.setResource(file);
                    context.setElResolvers(ELResolverFactoryManager.getInstance().getResolvers((IResource)project));
                } else {
                    IModelManager manager = StructuredModelManager.getModelManager();
                    if (manager != null) {
                        IStructuredModel model = null;
                        try {
                            IStructuredModel iStructuredModel = model = file != null ? manager.getModelForRead(file) : manager.getExistingModelForRead(document);
                            if (model instanceof IDOMModel) {
                                IDOMModel domModel = (IDOMModel)model;
                                SimpleELContext simpleELContext2 = context = defaultContextType == null ? PageContextFactory.createPageContextInstance(domModel.getContentTypeIdentifier()) : PageContextFactory.createContextInstanceOfType(defaultContextType);
                                if (context != null) {
                                    IKbProject kbProject;
                                    IDOMDocument domDocument = domModel.getDocument();
                                    context.setResource(file);
                                    if (document == null && context instanceof XmlContextImpl) {
                                        document = model.getStructuredDocument();
                                    }
                                    IProject project = file != null ? file.getProject() : PageContextFactory.getActiveProject();
                                    context.setElResolvers(ELResolverFactoryManager.getInstance().getResolvers((IResource)project));
                                    if (document != null && context instanceof JspContextImpl && !(context instanceof FaceletPageContextImpl)) {
                                        PageContextFactory.fillJSPNameSpaces((JspContextImpl)context, document, dontUseCache);
                                    }
                                    if (file != null && (kbProject = KbProjectFactory.getKbProject(project, true)) != null) {
                                        kbProject.getIncludeModel().clean(file.getFullPath());
                                    }
                                    this.fillContextForChildNodes((IDocument)model.getStructuredDocument(), (IDOMNode)domDocument, (ELContext)context, parents, dontUseCache);
                                }
                            }
                        }
                        catch (CoreException e) {
                            WebKbPlugin.getDefault().logError(e);
                            if (model != null) {
                                model.releaseFromRead();
                            }
                            break block24;
                        }
                        catch (IOException e) {
                            try {
                                WebKbPlugin.getDefault().logError(e);
                                break block24;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (model != null) {
                                    model.releaseFromRead();
                                }
                            }
                        }
                        if (model == null) break block24;
                        model.releaseFromRead();
                    }
                }
            }
            if (context != null) {
                context.setDirty(modified);
                this.saveConvext(context);
            }
        }
        return context;
    }

    public static void updateContextWithCSSInfo(IPageContext context) {
        if (!(context instanceof ICSSContainerSupport)) {
            return;
        }
        IFile file = context.getResource();
        if (file == null) {
            return;
        }
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) {
            return;
        }
        IStructuredModel model = null;
        try {
            model = manager.getModelForRead(file);
            if (!(model instanceof IDOMModel)) {
                return;
            }
            try {
                PageContextFactory.fillCSSStyleSheetDescriptorsForChildNodes((IDOMNode)((IDOMModel)model).getDocument(), context);
            }
            catch (CoreException e) {
                WebKbPlugin.getDefault().logError(e);
            }
            catch (IOException e) {
                WebKbPlugin.getDefault().logError(e);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private static void fillCSSStyleSheetDescriptorsForChildNodes(IDOMNode parent, IPageContext context) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (children != null && i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof IDOMNode) {
                PageContextFactory.fillCSSStyleSheetDescriptorForNode((IDOMNode)child, context);
                PageContextFactory.fillCSSStyleSheetDescriptorsForChildNodes((IDOMNode)child, context);
            }
            ++i;
        }
    }

    private static void fillCSSStyleSheetDescriptorForNode(IDOMNode node, IPageContext context) {
        String[] uris;
        if (!(context instanceof ICSSContainerSupport) || !(node instanceof IDOMElement)) {
            return;
        }
        String prefix = node.getPrefix() == null ? "" : node.getPrefix();
        String tagName = node.getLocalName();
        Map<String, List<INameSpace>> nsMap = context.getNameSpaces(node.getStartOffset());
        String[] stringArray = uris = PageContextFactory.getUrisByPrefix(nsMap, prefix);
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            if (IncludeContextBuilder.isCSSStyleSheetContainer(uri, tagName)) {
                PageContextFactory.fillCSSStyleSheetFromElement((IDOMElement)node, (ICSSContainerSupport)((Object)context), false);
            } else if (IncludeContextBuilder.isJSF2CSSStyleSheetContainer(uri, tagName)) {
                PageContextFactory.fillCSSStyleSheetFromElement((IDOMElement)node, (ICSSContainerSupport)((Object)context), true);
            } else {
                String attr;
                String[] cssAttributes;
                String[] stringArray2 = cssAttributes = IncludeContextBuilder.getCSSStyleSheetAttributes(uri, tagName);
                int n3 = cssAttributes.length;
                int n4 = 0;
                while (n4 < n3) {
                    attr = stringArray2[n4];
                    PageContextFactory.fillCSSStyleSheetFromAttribute((IDOMElement)node, attr, (ICSSContainerSupport)((Object)context), false);
                    ++n4;
                }
                stringArray2 = cssAttributes = IncludeContextBuilder.getJSF2CSSStyleSheetAttributes(uri, tagName);
                n3 = cssAttributes.length;
                n4 = 0;
                while (n4 < n3) {
                    attr = stringArray2[n4];
                    PageContextFactory.fillCSSStyleSheetFromAttribute((IDOMElement)node, attr, (ICSSContainerSupport)((Object)context), true);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    boolean isXMLWithoutEL(IFile file) {
        if (!file.getName().endsWith(".xml")) {
            return false;
        }
        String content = FileUtil.getContentFromEditorOrFile((IFile)file);
        return content != null && content.indexOf("#{") < 0 && content.indexOf("${") < 0;
    }

    private static IProject getActiveProject() {
        ITextEditor editor = EclipseUIUtil.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editorInput).getFile();
            return file == null ? null : file.getProject();
        }
        if (editorInput instanceof IStorageEditorInput) {
            IStorage storage;
            try {
                storage = ((IStorageEditorInput)editorInput).getStorage();
            }
            catch (CoreException coreException) {
                return null;
            }
            if (storage instanceof IJarEntryResource) {
                Object parent = ((IJarEntryResource)storage).getParent();
                while (parent instanceof IJarEntryResource && !(parent instanceof IProject)) {
                    parent = ((IJarEntryResource)parent).getParent();
                }
                if (parent instanceof JarPackageFragmentRoot) {
                    return ((JarPackageFragmentRoot)parent).getJavaProject().getProject();
                }
                return null;
            }
        }
        return null;
    }

    protected String getContentTypeIdentifier(Object source) {
        if (source instanceof IFile) {
            IContentType type = IDE.getContentType((IFile)((IFile)source));
            if (type != null) {
                return type.getId();
            }
        } else if (source instanceof IDocument) {
            IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)source);
            try {
                if (sModel != null) {
                    String string = sModel.getContentTypeIdentifier();
                    return string;
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        }
        return null;
    }

    public static IFile getResource(IDocument document) {
        IFile file;
        IPath path;
        if (document == null) {
            return null;
        }
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        try {
            String baseLocation;
            IPath location;
            IFile result;
            if (sModel != null && (result = FileBuffers.getWorkspaceFileAtLocation((IPath)(location = new Path(baseLocation = sModel.getBaseLocation()).makeAbsolute()))) != null) {
                IFile iFile = result;
                return iFile;
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
        if (buffer != null && buffer.getLocation() != null && (path = buffer.getLocation()).segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).isAccessible()) {
            return file;
        }
        return null;
    }

    private static SimpleELContext createPageContextInstance(String contentType) {
        String contextType = IncludeContextBuilder.getContextType(contentType);
        if (contextType == null && contentType != null) {
            IContentType baseContentType = Platform.getContentTypeManager().getContentType(contentType);
            baseContentType = baseContentType == null ? null : baseContentType.getBaseType();
            while (contextType == null && baseContentType != null) {
                contextType = IncludeContextBuilder.getContextType(baseContentType.getId());
                baseContentType = baseContentType.getBaseType();
            }
        }
        return PageContextFactory.createContextInstanceOfType(contextType);
    }

    private static SimpleELContext createContextInstanceOfType(String contextType) {
        if (JSP_PAGE_CONTEXT_TYPE.equals(contextType)) {
            return new JspContextImpl();
        }
        if (FACELETS_PAGE_CONTEXT_TYPE.equals(contextType)) {
            return new FaceletPageContextImpl();
        }
        return new XmlContextImpl();
    }

    private static void fillJSPNameSpaces(JspContextImpl context, IDocument document, boolean dontUseCache) {
        IProject project;
        IProject iProject = project = context.getResource() != null ? context.getResource().getProject() : PageContextFactory.getActiveProject();
        if (project == null) {
            return;
        }
        TLDCMDocumentManager manager = TaglibController.getTLDCMDocumentManager((IDocument)document);
        List trackers = manager == null ? null : manager.getCMDocumentTrackers(document.getLength() - 1);
        int i = 0;
        while (trackers != null && i < trackers.size()) {
            String uri;
            TaglibTracker tt = (TaglibTracker)trackers.get(i);
            String prefix = tt.getPrefix() == null ? null : tt.getPrefix().trim();
            String string = uri = tt.getURI() == null ? null : tt.getURI().trim();
            if (prefix != null && prefix.length() > 0 && uri != null && uri.length() > 0) {
                IKbProject kbProject;
                Region region = new Region(0, document.getLength());
                NameSpace nameSpace = new NameSpace(uri, prefix, null, TagLibraryManager.getLibraries(project, uri));
                context.addNameSpace((IRegion)region, nameSpace);
                if (!dontUseCache && (kbProject = KbProjectFactory.getKbProject(project, true)) != null) {
                    kbProject.getNameSpaceStorage().add(prefix, uri);
                }
            }
            ++i;
        }
    }

    private void fillContextForChildNodes(IDocument document, IDOMNode parent, ELContext context, List<String> parents, boolean dontUseCache) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (children != null && i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof IDOMNode) {
                this.fillContextForNode(document, (IDOMNode)child, context, parents, dontUseCache);
                this.fillContextForChildNodes(document, (IDOMNode)child, context, parents, dontUseCache);
            }
            ++i;
        }
    }

    private void fillContextForNode(IDocument document, IDOMNode node, ELContext context, List<String> parents, boolean dontUseCache) {
        if (context instanceof XmlContextImpl) {
            XmlContextImpl xmlContext = (XmlContextImpl)context;
            PageContextFactory.fillElReferencesForNode(document, node, xmlContext);
            if (node instanceof IDOMElement) {
                PageContextFactory.fillXMLNamespacesForNode((Element)((IDOMElement)node), xmlContext, dontUseCache);
            }
        }
        if ((context instanceof JspContextImpl || context instanceof FaceletPageContextImpl) && node instanceof IDOMElement) {
            PageContextFactory.fillVarsForNode((IDOMElement)node, (ELContextImpl)context);
        }
        if (context instanceof FaceletPageContextImpl && node instanceof IDOMElement && context.getResource() != null && context.getResource().exists()) {
            PageContextFactory.fillUIParamsForNode((IDOMElement)node, (ELContextImpl)context);
        }
        if (context instanceof JspContextImpl && node instanceof IDOMElement) {
            PageContextFactory.fillResourceBundlesForNode((IDOMElement)node, (JspContextImpl)context);
        }
        if (context instanceof IPageContext && node instanceof IDOMElement) {
            this.fillAdditionalInfoForNode((IDOMElement)node, (IPageContext)context, parents);
        }
    }

    private static void fillVarsForNode(IDOMElement node, ELContextImpl context) {
        Var var = ElVarSearcher.findVar((Node)node, (ELParserFactory)ELParserUtil.getJbossFactory());
        if (var != null) {
            int start = node.getStartOffset();
            int length = node.getLength();
            start = node.getStartOffset();
            length = node.getEndOffset() - start;
            var.setFile(context.getResource());
            context.addVar(new Region(start, length), var);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillUIParamsForNode(IDOMElement node, ELContextImpl context) {
        IKbProject kbProject;
        String namespaceURI = node.getNamespaceURI();
        if (!"http://java.sun.com/jsf/facelets".equals(namespaceURI) && !"http://xmlns.jcp.org/jsf/facelets".equals(namespaceURI)) {
            return;
        }
        String pathAttr = PATH_ATTRIBUTES.get(node.getLocalName());
        if (pathAttr == null) {
            return;
        }
        String src = node.getAttribute(pathAttr);
        if (src == null || src.trim().length() == 0) {
            return;
        }
        IFile includedFile = PageContextFactory.getFile(src, context.getResource());
        if (includedFile == null) {
            return;
        }
        NodeList list = node.getElementsByTagNameNS(namespaceURI, NODE_PARAM);
        ArrayList<Var> vars = null;
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (n instanceof IDOMElement) {
                IDOMElement element;
                IDOMElement iDOMElement = element = (IDOMElement)n;
                synchronized (iDOMElement) {
                    if (element.hasAttribute(ATTR_NAME)) {
                        String var = element.getAttribute(ATTR_NAME);
                        int declOffset = 0;
                        int length = 0;
                        Attr varAttr = element.getAttributeNode(ATTR_NAME);
                        if (varAttr instanceof IDOMAttr) {
                            int varStart;
                            declOffset = varStart = ((IDOMAttr)varAttr).getValueRegionStartOffset() + 1;
                            length = var.length();
                        }
                        if (!"".equals(var = var.trim()) && element.hasAttribute(ATTR_VALUE)) {
                            String value = element.getAttribute(ATTR_VALUE);
                            value = value.trim();
                            Var newVar = new Var(ELParserUtil.getJbossFactory(), var, value, declOffset, length);
                            if (newVar.getElToken() == null) {
                                newVar = new Var(ELParserUtil.getJbossFactory(), var, "#{\"" + value + "\".toString()}", declOffset, length);
                            }
                            if (newVar.getElToken() != null) {
                                newVar.setFile(context.getResource());
                                if (vars == null) {
                                    vars = new ArrayList<Var>();
                                }
                                vars.add(newVar);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (vars != null && !vars.isEmpty() && (kbProject = KbProjectFactory.getKbProject(context.getResource().getProject(), true)) != null) {
            PageInclude include = new PageInclude(context.getResource().getFullPath(), includedFile.getFullPath(), (List<Var>)vars);
            kbProject.getIncludeModel().addInclude(context.getResource().getFullPath(), include);
        }
    }

    public static IFile getFile(String fileName, IFile includeFile) {
        IFile file = null;
        if (fileName.startsWith("/")) {
            IContainer[] webRootFolders = WebUtils.getWebRootFolders((IProject)includeFile.getProject());
            if (webRootFolders.length > 0) {
                IContainer[] iContainerArray = webRootFolders;
                int n = webRootFolders.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer webRootFolder = iContainerArray[n2];
                    IFile handle = webRootFolder.getFile((IPath)new Path(fileName));
                    if (handle.exists()) {
                        file = handle;
                        break;
                    }
                    ++n2;
                }
            } else {
                file = PageContextFactory.resolveRelatedPath(includeFile, fileName);
            }
        } else {
            file = PageContextFactory.resolveRelatedPath(includeFile, fileName);
        }
        return file;
    }

    private static IFile resolveRelatedPath(IFile baseFile, String relatedFilePath) {
        IPath currentFolder = baseFile.getParent().getFullPath();
        IPath path = currentFolder.append(relatedFilePath);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    private static void fillElReferencesForNode(IDocument document, IDOMNode node, XmlContextImpl context) {
        block10: {
            IStructuredDocumentRegion regionNode;
            block11: {
                if (context.getResource() == null) {
                    return;
                }
                regionNode = node.getFirstStructuredDocumentRegion();
                if (regionNode == null) {
                    return;
                }
                if (1 != node.getNodeType()) break block11;
                ITextRegionList regions = regionNode.getRegions();
                if (regions == null) {
                    return;
                }
                ITextRegion[] iTextRegionArray = regions.toArray();
                int n = iTextRegionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITextRegion region = iTextRegionArray[n2];
                    if ("XML_TAG_ATTRIBUTE_VALUE" == region.getType() || "XML_CONTENT" == region.getType()) {
                        PageContextFactory.fillElReferencesForRegionNode(document, node, regionNode, region, context);
                    }
                    ++n2;
                }
                break block10;
            }
            if (3 != node.getNodeType()) break block10;
            IStructuredDocumentRegion lastRegionNode = node.getLastStructuredDocumentRegion();
            while (regionNode != null) {
                ITextRegionList regions = regionNode.getRegions();
                if (regions == null) {
                    return;
                }
                ITextRegion[] iTextRegionArray = regions.toArray();
                int n = iTextRegionArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ITextRegion region = iTextRegionArray[n3];
                    if ("XML_TAG_ATTRIBUTE_VALUE" == region.getType() || "XML_CONTENT" == region.getType()) {
                        PageContextFactory.fillElReferencesForRegionNode(document, node, regionNode, region, context);
                    }
                    ++n3;
                }
                if (regionNode != lastRegionNode) {
                    regionNode = regionNode.getNext();
                    continue;
                }
                break;
            }
        }
    }

    private static void fillElReferencesForRegionNode(IDocument document, IDOMNode node, IStructuredDocumentRegion regionNode, ITextRegion region, XmlContextImpl context) {
        if (context.getResource() == null) {
            return;
        }
        String text = regionNode.getFullText(region);
        if (text.indexOf(123) > -1 && (text.indexOf("#{") > -1 || text.indexOf("${") > -1)) {
            int offset = regionNode.getStartOffset() + region.getStart();
            ValidationELReference elReference = new ValidationELReference();
            elReference.setResource(context.getResource());
            elReference.setLength(text.length());
            elReference.setStartPosition(offset);
            try {
                if (3 == node.getNodeType()) {
                    if (elReference.getEl().length == 1) {
                        elReference.setLineNumber(document.getLineOfOffset(elReference.getStartPossitionOfFirstEL()) + 1);
                    }
                } else {
                    elReference.setLineNumber(document.getLineOfOffset(offset) + 1);
                }
            }
            catch (BadLocationException e) {
                WebKbPlugin.getDefault().logError(e);
            }
            context.addELReference((ELReference)elReference);
        }
    }

    private void fillAdditionalInfoForNode(IDOMElement node, IPageContext context, List<String> parents) {
        String[] uris;
        if (context.getResource() == null) {
            return;
        }
        String prefix = node.getPrefix() == null ? "" : node.getPrefix();
        String tagName = node.getLocalName();
        Map<String, List<INameSpace>> nsMap = context.getNameSpaces(node.getStartOffset());
        String[] stringArray = uris = PageContextFactory.getUrisByPrefix(nsMap, prefix);
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            String[] includeAttributes;
            String uri = stringArray[n2];
            if (context instanceof IIncludedContextSupport && (includeAttributes = IncludeContextBuilder.getIncludeAttributes(uri, tagName)).length > 0) {
                ArrayList<String> newParentList = parents == null ? new ArrayList<String>() : new ArrayList<String>(parents);
                newParentList.add(context.getResource().getFullPath().toString());
                String[] stringArray2 = includeAttributes;
                int n3 = includeAttributes.length;
                int n4 = 0;
                while (n4 < n3) {
                    ELContext includedContext;
                    IFile file;
                    String attr = stringArray2[n4];
                    String fileName = node.getAttribute(attr);
                    if (fileName != null && !fileName.trim().isEmpty() && (file = PageContextFactory.getFileFromProject(fileName, context.getResource())) != null && PageContextFactory.checkCycling(parents, file) && (includedContext = this.createPageContext(null, file, newParentList, null, false)) != null) {
                        ((IIncludedContextSupport)((Object)context)).addIncludedContext(includedContext);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static boolean checkCycling(List<String> parents, IFile resource) {
        String resourceId = resource.getFullPath().toString();
        for (String parentId : parents) {
            if (!resourceId.equals(parentId)) continue;
            return false;
        }
        return true;
    }

    private static void fillXMLNamespacesForNode(Element node, XmlContextImpl context, boolean dontUseCache) {
        IProject project;
        IProject iProject = project = context.getResource() != null ? context.getResource().getProject() : PageContextFactory.getActiveProject();
        if (project == null) {
            return;
        }
        NamedNodeMap attrs = node.getAttributes();
        boolean mainNnIsRedefined = false;
        int j = 0;
        while (attrs != null && j < attrs.getLength()) {
            Attr a = (Attr)attrs.item(j);
            String name = a.getName();
            if (name.startsWith("xmlns:") || name.equals("xmlns")) {
                String prefix = name.startsWith("xmlns:") ? name.substring("xmlns:".length()) : "";
                String uri = a.getValue();
                prefix = prefix == null ? null : prefix.trim();
                String string = uri = uri == null ? null : uri.trim();
                if (!XHTML_TAG_LIB_URI.equalsIgnoreCase(uri) && prefix != null && uri != null && uri.length() > 0) {
                    IKbProject kbProject;
                    IDOMElement domElement;
                    int start = ((IndexedRegion)node).getStartOffset();
                    int length = ((IndexedRegion)node).getLength();
                    IDOMElement iDOMElement = domElement = node instanceof IDOMElement ? (IDOMElement)node : null;
                    if (domElement != null) {
                        start = domElement.getStartOffset();
                        length = domElement.hasEndTag() ? domElement.getEndStructuredDocumentRegion().getEnd() : ((IDOMNode)node.getOwnerDocument()).getEndOffset() - start;
                    }
                    Region region = new Region(start, length);
                    NameSpace nameSpace = new NameSpace(uri, prefix, node.getNodeName(), TagLibraryManager.getLibraries(project, uri));
                    context.addNameSpace((IRegion)region, nameSpace);
                    if (!dontUseCache && (kbProject = KbProjectFactory.getKbProject(project, true)) != null) {
                        kbProject.getNameSpaceStorage().add(prefix, uri);
                    }
                    if (prefix.length() == 0) {
                        mainNnIsRedefined = true;
                    }
                    if (context instanceof FaceletPageContextImpl && ("http://java.sun.com/jsf/facelets".equals(uri) || "http://xmlns.jcp.org/jsf/facelets".equals(uri)) && !mainNnIsRedefined) {
                        nameSpace = new NameSpace("http://www.w3.org/1999/xhtml/facelets", "", node.getNodeName(), TagLibraryManager.getLibraries(project, "http://www.w3.org/1999/xhtml/facelets"));
                        context.addNameSpace((IRegion)region, nameSpace);
                    }
                }
            }
            ++j;
        }
    }

    private static void fillResourceBundlesForNode(IDOMElement node, JspContextImpl context) {
        String var;
        String name = node.getNodeName();
        if (name == null || !name.endsWith("loadBundle") || name.indexOf(58) == -1) {
            return;
        }
        String prefix = name.substring(0, name.indexOf(58));
        Map<String, List<INameSpace>> ns = context.getNameSpaces(node.getStartOffset());
        if (!PageContextFactory.containsPrefix(ns, prefix)) {
            return;
        }
        NamedNodeMap attributes = node.getAttributes();
        String basename = attributes.getNamedItem("basename") == null ? null : attributes.getNamedItem("basename").getNodeValue();
        String string = var = attributes.getNamedItem("var") == null ? null : attributes.getNamedItem("var").getNodeValue();
        if (basename == null || basename.length() == 0 || var == null || var.length() == 0) {
            return;
        }
        context.addResourceBundle(new ResourceBundle(basename, var));
    }

    private static void fillCSSStyleSheetFromAttribute(IDOMElement node, String attribute, ICSSContainerSupport context, boolean jsf2Source) {
        context.addCSSStyleSheetDescriptor(new CSSStyleSheetDescriptorForAttribute((Node)node, attribute, jsf2Source));
    }

    private static void fillCSSStyleSheetFromElement(IDOMElement node, ICSSContainerSupport context, boolean jsf2Source) {
        context.addCSSStyleSheetDescriptor(new CSSStyleSheetDescriptor(context.getResource().getFullPath().toString(), (Node)node, jsf2Source));
    }

    private static boolean containsPrefix(Map<String, List<INameSpace>> ns, String prefix) {
        for (List<INameSpace> n : ns.values()) {
            for (INameSpace nameSpace : n) {
                if (!prefix.equals(nameSpace.getPrefix())) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] getUrisByPrefix(Map<String, List<INameSpace>> nsMap, String prefix) {
        String[] stringArray;
        if (nsMap.isEmpty()) {
            return new String[0];
        }
        HashSet<String> uris = new HashSet<String>();
        for (List<INameSpace> nsList : nsMap.values()) {
            for (INameSpace ns : nsList) {
                if (!prefix.equals(ns.getPrefix())) continue;
                uris.add(ns.getURI());
            }
        }
        if (uris.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = prefix;
        } else {
            stringArray = uris.toArray(new String[uris.size()]);
        }
        return stringArray;
    }

    public static IFile getFileFromProject(String fileName, IFile documentFile) {
        if (documentFile == null || !documentFile.isAccessible()) {
            return null;
        }
        fileName = PageContextFactory.findAndReplaceElVariable(fileName);
        IProject project = documentFile.getProject();
        String name = Utils.trimFilePath((String)fileName);
        IPath currentPath = documentFile.getLocation().removeLastSegments(1);
        IFile member = null;
        StructureEdit se = StructureEdit.getStructureEditForRead((IProject)project);
        if (se == null) {
            return null;
        }
        WorkbenchComponent[] modules = se.getWorkbenchModules();
        int i = 0;
        while (i < modules.length) {
            if (name.startsWith("/")) {
                member = PageContextFactory.findFileByAbsolutePath(project, modules[i], name);
            } else {
                member = PageContextFactory.findFileByRelativePath(project, modules[i], currentPath, name);
                if (member == null && name.length() > 0) {
                    member = PageContextFactory.findFileByAbsolutePath(project, modules[i], "/" + name);
                }
            }
            if (member != null && member instanceof IFile && member.exists()) {
                return member;
            }
            ++i;
        }
        return null;
    }

    private static IFile findFileByRelativePath(IProject project, WorkbenchComponent module, IPath basePath, String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        path = PageContextFactory.findAndReplaceElVariable(path);
        ComponentResource[] resources = module.findResourcesBySourcePath((IPath)new Path("/"), 0);
        IPath projectPath = project.getLocation();
        IFile member = null;
        int i = 0;
        while (i < resources.length) {
            IPath webRootPath;
            IPath relativePath;
            IPath filePath;
            IPath runtimePath = resources[i].getRuntimePath();
            IPath sourcePath = resources[i].getSourcePath();
            member = project.getFile(sourcePath.append(filePath = (relativePath = Utils.getRelativePath((IPath)(webRootPath = projectPath.append(sourcePath)), (IPath)basePath)).append(path)));
            if (member.exists()) {
                return member;
            }
            if (runtimePath.segmentCount() >= 1 && (member = project.getFile(runtimePath.append(filePath = (relativePath = Utils.getRelativePath((IPath)(webRootPath = projectPath.append(runtimePath)), (IPath)basePath)).append(path)))).exists()) {
                return member;
            }
            ++i;
        }
        return null;
    }

    private static IFile findFileByAbsolutePath(IProject project, WorkbenchComponent module, String path) {
        ComponentResource[] resources = module.findResourcesBySourcePath((IPath)new Path("/"), 0);
        path = PageContextFactory.findAndReplaceElVariable(path);
        IFile member = null;
        int i = 0;
        while (resources != null && i < resources.length) {
            IPath runtimePath = resources[i].getRuntimePath();
            IPath sourcePath = resources[i].getSourcePath();
            member = project.getFile(sourcePath.append(path));
            if (member.exists()) {
                return member;
            }
            if (runtimePath.segmentCount() >= 1 && (member = project.getFile(runtimePath.append(path))).exists()) {
                return member;
            }
            ++i;
        }
        return null;
    }

    private static String findAndReplaceElVariable(String fileName) {
        ResourceReference[] sortedReferences;
        if (fileName != null) {
            fileName = fileName.replaceFirst(CONTEXT_PATH_EXPRESSION, "");
        }
        IPath workspacePath = Platform.getLocation();
        ResourceReference[] gResources = GlobalELReferenceList.getInstance().getAllResources(workspacePath);
        String result = fileName;
        ResourceReference[] resourceReferenceArray = sortedReferences = PageContextFactory.sortReferencesByScope(gResources);
        int n = sortedReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceReference rf = resourceReferenceArray[n2];
            String dollarEl = "${" + rf.getLocation() + SUFFIX;
            String sharpEl = "#{" + rf.getLocation() + SUFFIX;
            if (fileName.contains(dollarEl)) {
                result = result.replace(dollarEl, rf.getProperties());
            }
            if (fileName.contains(sharpEl)) {
                result = result.replace(sharpEl, rf.getProperties());
            }
            ++n2;
        }
        return result;
    }

    private static ResourceReference[] sortReferencesByScope(ResourceReference[] references) {
        ResourceReference[] sortedReferences = (ResourceReference[])references.clone();
        Arrays.sort(sortedReferences, new Comparator<ResourceReference>(){

            @Override
            public int compare(ResourceReference r1, ResourceReference r2) {
                return r1.getScope() - r2.getScope();
            }
        });
        return sortedReferences;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null || event.getDelta() == null) {
            return;
        }
        this.cleanUp(event.getDelta());
    }

    private static boolean checkDelta(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource instanceof IWorkspaceRoot) {
            IResourceDelta[] d = delta.getAffectedChildren();
            return d.length > 0 && PageContextFactory.checkDelta(d[0]);
        }
        return true;
    }

    private void processDelta(IResourceDelta delta) {
        if (delta != null) {
            int kind = delta.getKind();
            IResource resource = delta.getResource();
            if (resource instanceof IProject && kind == 2) {
                this.cleanUp((IProject)resource);
            } else if (resource instanceof IFile && (kind == 4 || kind == 1 || kind == 2 || kind == 256)) {
                this.cleanUp((IFile)resource);
            }
            IResourceDelta[] cs = delta.getAffectedChildren();
            int i = 0;
            while (i < cs.length) {
                this.processDelta(cs[i]);
                ++i;
            }
        }
    }

    private static boolean isDependencyContext(ELContext context, IFile resource) {
        if (resource.equals((Object)context.getResource())) {
            return true;
        }
        if (context instanceof IIncludedContextSupport) {
            List<ELContext> includedContexts = ((IIncludedContextSupport)context).getIncludedContexts();
            for (ELContext includedContext : includedContexts) {
                if (!PageContextFactory.isDependencyContext(includedContext, resource)) continue;
                return true;
            }
        }
        return false;
    }

    public static class CSSStyleSheetDescriptor {
        protected Node stylesheetContainer;
        protected String source;
        protected boolean jsf2Source;
        protected boolean initialized = false;

        CSSStyleSheetDescriptor(String source, Node styleheetContainer, boolean jsf2Source) {
            this.source = source;
            this.stylesheetContainer = styleheetContainer;
            this.jsf2Source = jsf2Source;
        }

        public String getFilePath() {
            String library;
            Attr libraryAttr;
            if (!this.initialized) {
                this.getStylesheet();
            }
            if (!this.jsf2Source) {
                return this.source;
            }
            String jsf2Library = null;
            if (this.jsf2Source && this.stylesheetContainer instanceof Element && (libraryAttr = ((Element)this.stylesheetContainer).getAttributeNode("library")) != null && libraryAttr.getNodeValue() != null) {
                jsf2Library = libraryAttr.getNodeValue().trim();
                String string = jsf2Library = jsf2Library.length() == 0 ? null : jsf2Library;
            }
            if (jsf2Library != null && (library = jsf2Library.trim()).length() != 0) {
                return "/resources/" + library + '/' + this.source;
            }
            return "/resources/" + this.source;
        }

        public Node getContainerNode() {
            return this.stylesheetContainer;
        }

        public String getSource() {
            if (!this.initialized) {
                this.getStylesheet();
            }
            return this.source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CSSStyleSheet getStylesheet() {
            if (this.stylesheetContainer == null) {
                return null;
            }
            INodeNotifier notifier = (INodeNotifier)this.stylesheetContainer;
            CSSStyleSheet sheet = null;
            INodeNotifier iNodeNotifier = notifier;
            synchronized (iNodeNotifier) {
                IStyleSheetAdapter adapter = (IStyleSheetAdapter)notifier.getAdapterFor(IStyleSheetAdapter.class);
                if (adapter != null) {
                    sheet = (CSSStyleSheet)adapter.getSheet();
                }
            }
            this.initialized = true;
            return sheet;
        }
    }

    public static class CSSStyleSheetDescriptorForAttribute
    extends CSSStyleSheetDescriptor {
        public String attribute;

        public CSSStyleSheetDescriptorForAttribute(Node styleheetContainer, String attribute, boolean jsf2Source) {
            super(null, styleheetContainer, jsf2Source);
            this.attribute = attribute;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CSSStyleSheet getStylesheet() {
            if (this.stylesheetContainer == null) {
                return null;
            }
            INodeNotifier notifier = (INodeNotifier)this.stylesheetContainer;
            CSSStyleSheet sheet = null;
            INodeNotifier iNodeNotifier = notifier;
            synchronized (iNodeNotifier) {
                IStyleSheetAdapter originalAdapter = (IStyleSheetAdapter)notifier.getAdapterFor(IStyleSheetAdapter.class);
                if (originalAdapter != null) {
                    notifier.removeAdapter((INodeAdapter)originalAdapter);
                }
                ExtendedLinkElementAdapter tempAdapter = new ExtendedLinkElementAdapter((Element)this.stylesheetContainer, this.attribute, this.jsf2Source);
                sheet = (CSSStyleSheet)tempAdapter.getSheet();
                this.source = tempAdapter.getSource();
                if (sheet != null && this.source != null) {
                    notifier.addAdapter((INodeAdapter)tempAdapter);
                }
                sheet = (CSSStyleSheet)tempAdapter.getSheet();
                this.source = tempAdapter.getSource();
                notifier.removeAdapter((INodeAdapter)tempAdapter);
                if (originalAdapter != null) {
                    notifier.addAdapter((INodeAdapter)originalAdapter);
                }
            }
            this.initialized = true;
            return sheet;
        }
    }

    class DocListener
    implements IDocumentListener {
        IFile file;
        IDocument document;
        int references;

        public DocListener(IFile file, IDocument document) {
            this.file = file;
            this.document = document;
            PageContextFactory.this.listeners.put(file, this);
            document.addDocumentListener((IDocumentListener)this);
            this.add();
        }

        public void documentChanged(DocumentEvent event) {
            PageContextFactory.this.cleanUp(this.file);
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void add() {
            ++this.references;
        }

        public void remove() {
            if (this.document == null) {
                return;
            }
            --this.references;
            if (this.references <= 0) {
                this.document.removeDocumentListener((IDocumentListener)this);
                this.document = null;
                PageContextFactory.this.listeners.remove(this.file);
            }
        }
    }

    public static class ExtendedLinkElementAdapter
    extends LinkElementAdapter {
        private Element element;
        private String hrefAttrName;
        private String source = null;
        private boolean jsf2Source;
        private String prefix = null;

        public ExtendedLinkElementAdapter(Element element, String hrefAttrName, boolean jsf2Source) {
            this.element = element;
            this.hrefAttrName = hrefAttrName;
            this.jsf2Source = jsf2Source;
        }

        public Element getElement() {
            return this.element;
        }

        public String getSource() {
            return this.source;
        }

        protected boolean isValidAttribute() {
            boolean result = true;
            if (!super.isValidAttribute()) {
                String href = this.getElement().getAttribute(this.hrefAttrName);
                result = href != null && !href.isEmpty();
            }
            return result;
        }

        public ICSSModel getModel() {
            if (super.isValidAttribute()) {
                this.source = this.getSourceFromAttribute("href");
            } else if (this.isValidAttribute()) {
                if (this.jsf2Source) {
                    String library = null;
                    Attr libraryAttr = this.element.getAttributeNode("library");
                    if (libraryAttr != null && libraryAttr.getNodeValue() != null) {
                        library = libraryAttr.getNodeValue().trim();
                        library = library.length() == 0 ? null : library;
                    }
                    this.prefix = library != null ? "/resources/" + library + '/' : "/resources/";
                }
                this.source = this.getSourceFromAttribute(this.hrefAttrName);
            } else {
                return null;
            }
            ICSSModel model = this.retrieveModel();
            this.setModel(model);
            return model;
        }

        private String getSourceFromAttribute(String hrefAttributeName) {
            String hrefExtracted = PageContextFactory.findAndReplaceElVariable(this.element.getAttribute(this.hrefAttrName));
            return hrefExtracted;
        }

        private ICSSModel retrieveModel() {
            IStructuredModel newModel;
            IModelProvideAdapter adapter;
            block11: {
                block10: {
                    IDOMModel baseModel;
                    RemoteFileManager.Result result;
                    if (!this.isValidAttribute() || this.source == null) {
                        return null;
                    }
                    if ((this.source.startsWith("http://") || this.source.startsWith("https://")) && (result = RemoteFileManager.getInstance().getFile(this.source)).isReady()) {
                        this.source = result.getLocalPath();
                    }
                    if ((baseModel = ((IDOMNode)this.element).getModel()) == null) {
                        return null;
                    }
                    String id = baseModel.getId();
                    if (!(id instanceof String)) {
                        return null;
                    }
                    adapter = (IModelProvideAdapter)((INodeNotifier)this.getElement()).getAdapterFor(IModelProvideAdapter.class);
                    ProjectURLModelProvider provider = new ProjectURLModelProvider();
                    newModel = provider.getModelForRead((IStructuredModel)baseModel, this.prefix == null ? this.source : String.valueOf(this.prefix) + this.source);
                    if (newModel != null) break block10;
                    return null;
                }
                if (newModel instanceof ICSSModel) break block11;
                newModel.releaseFromRead();
                return null;
            }
            try {
                if (adapter != null) {
                    adapter.modelProvided(newModel);
                }
                return (ICSSModel)newModel;
            }
            catch (UnsupportedEncodingException e) {
                WebKbPlugin.getDefault().logError(e);
            }
            catch (IOException e) {
                WebKbPlugin.getDefault().logError(e);
            }
            return null;
        }
    }

    class PartListener
    implements IPartListener {
        PartListener() {
        }

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                PageContextFactory.this.addListenerToPart((IEditorPart)part);
            }
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            DocListener listener;
            IFileEditorInput i;
            IFile file;
            IEditorPart editor;
            IEditorInput input;
            if (part instanceof IEditorPart && (input = (editor = (IEditorPart)part).getEditorInput()) instanceof IFileEditorInput && (file = (i = (IFileEditorInput)input).getFile()) != null && (listener = PageContextFactory.this.listeners.get(file)) != null) {
                listener.remove();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }
    }

    class WindowListener
    implements IWindowListener {
        WindowListener() {
        }

        public void windowOpened(IWorkbenchWindow window) {
            PageContextFactory.this.initDocumentListenersForWindow(window);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }
    }
}

