/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.kb;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class KbQuery {
    public static final KbQuery EMPTY = new KbQuery("", new String[0], new Tag[0], new HashMap<String, String>(), "", Type.TAG_NAME, "");
    public static final String PREFIX_SEPARATOR = ":";
    private int offset;
    private String uri;
    private String[] parentTags;
    private Tag[] parentTagsWithAttributes;
    private Map<String, String> attributes;
    private String value;
    private String stringQuery;
    private boolean useAsMask;
    private String prefix;
    private Type type;
    private String parent;
    private String regionValuePrefix;
    private String regionValueSufix;
    private Set<String> cachedAttributes = null;

    public KbQuery() {
    }

    public KbQuery(String uri, String[] parentTags, Tag[] parentTagsWithAttributes, Map<String, String> attributes, String value, Type type, String parent) {
        this.uri = uri;
        this.parentTags = parentTags;
        this.parentTagsWithAttributes = parentTagsWithAttributes;
        this.attributes = attributes;
        this.value = value;
        this.type = type;
        this.parent = parent;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String[] getParentTags() {
        return this.parentTags;
    }

    public void setParentTags(String[] parentTags) {
        this.parentTags = parentTags;
    }

    public String getLastParentTag() {
        if (this.parentTags.length > 0) {
            return this.parentTags[this.parentTags.length - 1];
        }
        return null;
    }

    public String getParent() {
        if (this.type == Type.TAG_NAME) {
            return this.getLastParentTag();
        }
        return this.parent;
    }

    public void setParent(String name) {
        this.parent = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isMask() {
        return this.useAsMask;
    }

    public void setMask(boolean useAsMask) {
        this.useAsMask = useAsMask;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getStringQuery() {
        return this.stringQuery;
    }

    public void setStringQuery(String stringQuery) {
        this.stringQuery = stringQuery;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Tag[] getParentTagsWithAttributes() {
        return this.parentTagsWithAttributes;
    }

    public void setParentTagsWithAttributes(Tag[] tags) {
        this.parentTagsWithAttributes = tags;
        if (this.parentTags == null) {
            this.parentTags = new String[tags.length];
            int i = 0;
            while (i < tags.length) {
                this.parentTags[i] = tags[i].getName();
                ++i;
            }
        }
    }

    public Set<String> getCachedAttributes() {
        return this.cachedAttributes;
    }

    public void setCachedAttributes(Set<String> s) {
        this.cachedAttributes = s;
    }

    public String getRegionValuePrefix() {
        return this.regionValuePrefix;
    }

    public void setRegionValuePrefix(String regionValue) {
        this.regionValuePrefix = regionValue;
    }

    public String getRegionValueSufix() {
        return this.regionValueSufix;
    }

    public void setRegionValueSufix(String regionValue) {
        this.regionValueSufix = regionValue;
    }

    public static class Tag {
        private String name;
        private Map<String, String> attributes;

        public Tag(String name, Map<String, String> attributes) {
            this.setName(name);
            this.setAttributes(attributes);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }
    }

    public static enum Type {
        TEXT,
        TAG_NAME,
        ATTRIBUTE_NAME,
        ATTRIBUTE_VALUE,
        TAG_BODY;

    }
}

