/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InputPageUtil {
    private InputPageUtil() {
    }

    public static Composite createVisibilityControl(Composite parent, final IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
        List<Integer> allowedVisibilities = InputPageUtil.convertToIntegerList(availableVisibilities);
        if (allowedVisibilities.size() == 1) {
            return null;
        }
        Group group = new Group(parent, 0);
        group.setText(RefactoringMessages.VisibilityControlUtil_Access_modifier);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        String[] labels = new String[]{"&public", "pro&tected", RefactoringMessages.VisibilityControlUtil_defa_ult_4, "pri&vate"};
        Integer[] data = new Integer[]{new Integer(1), new Integer(4), new Integer(0), new Integer(2)};
        Integer initialVisibility = new Integer(correctVisibility);
        int i = 0;
        while (i < labels.length) {
            Button radio = new Button((Composite)group, 16);
            Integer visibilityCode = data[i];
            radio.setText(labels[i]);
            radio.setData((Object)visibilityCode);
            radio.setSelection(visibilityCode.equals(initialVisibility));
            radio.setEnabled(allowedVisibilities.contains(visibilityCode));
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    visibilityChangeListener.visibilityChanged((Integer)event.widget.getData());
                }
            });
            ++i;
        }
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    private static List<Integer> convertToIntegerList(int[] array) {
        ArrayList<Integer> result = new ArrayList<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            result.add(new Integer(array[i]));
            ++i;
        }
        return result;
    }

    public static JavaSourceViewer createSignaturePreview(Composite parent) {
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        JavaSourceViewer signaturePreview = new JavaSourceViewer(parent, null, null, false, 584, store);
        signaturePreview.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, null));
        StyledText textWidget = signaturePreview.getTextWidget();
        textWidget.setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
        textWidget.setAlwaysShowScrollBars(false);
        signaturePreview.adaptBackgroundColor((Control)parent);
        signaturePreview.setDocument((IDocument)new Document());
        signaturePreview.setEditable(false);
        GridData gdata = new GridData(1808);
        gdata.widthHint = new PixelConverter((Control)textWidget).convertWidthInCharsToPixels(50);
        gdata.heightHint = textWidget.getLineHeight() * 2;
        textWidget.setLayoutData((Object)gdata);
        return signaturePreview;
    }
}

