/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.wizard.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.PatternSyntaxException;
import org.eclipse.compare.Splitter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelFactory;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IDropWizardModel;
import org.jboss.tools.common.model.ui.editors.dnd.TagAttributesWizardPage;
import org.jboss.tools.common.model.ui.editors.dnd.ValidationException;
import org.jboss.tools.common.model.ui.editors.dnd.composite.TagAttributesComposite;
import org.jboss.tools.common.model.ui.objecteditor.XChildrenEditor;
import org.jboss.tools.common.model.util.AbstractTableHelper;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.model.pv.JSFPromptingProvider;
import org.jboss.tools.jsf.ui.JsfUIMessages;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.attribute.adapter.JSFKnowledgeBaseAdapter;
import org.jboss.tools.jsf.ui.wizard.palette.Helper;
import org.jboss.tools.jsf.ui.wizard.palette.SelectPropertiesWizard;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.dnd.TagProposal;

public class DataTableWizardPage
extends TagAttributesWizardPage {
    Properties properties;
    XAttributeSupport support = new XAttributeSupport();
    final XEntityData data;
    IDropWizardModel fWizardModel;
    XModelObject propertyListObject = XModelFactory.getDefaultInstance().createModelObject("JSFDataTablePropertySet", null);
    XChildrenEditorImpl propertyListEditor = new XChildrenEditorImpl();
    private PropertyChangeListener pcl;
    private PropertyChangeListener mpcl;
    private TabItem general = null;
    private TabFolder tabs = null;
    private Splitter composite = null;
    boolean flag = false;
    Map<String, String[]> propertiesHash = new HashMap<String, String[]>();

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public DataTableWizardPage() {
        this.data = XEntityDataImpl.create((String[][])new String[][]{{"JSFDataTableWizard", "yes"}, {"var", "no"}, {"value", "no"}, {"value bean class", "no"}});
    }

    public void setProperties(Properties p) {
        this.properties = p;
    }

    public void createControl(Composite parent) {
        Composite maincomposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        maincomposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        maincomposite.setLayoutData((Object)data);
        this.showAttributes(maincomposite);
        IModelPropertyEditorAdapter a = this.support.getPropertyEditorAdapterByName("value");
        if (a instanceof JSFKnowledgeBaseAdapter) {
            ISelection s = this.getSpecificWizard().getWizardModel().getDropData().getSelectionProvider().getSelection();
            if (s instanceof TextSelection) {
                int offset = ((TextSelection)s).getOffset();
                this.context.put("offset", new Integer(offset));
            }
            ((JSFKnowledgeBaseAdapter)a).setContext(this.context);
        }
        this.setControl((Control)maincomposite);
        this.getSpecificWizard().getWizardModel().addPropertyChangeListener("tagProposal", (PropertyChangeListener)((Object)this));
        this.updateTitle();
        this.runValidation();
    }

    public void showAttributes(Composite parent) {
        this.composite = new Splitter(parent, 256);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        this.composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.composite.setLayoutData((Object)data);
        this.tabs = new TabFolder((Composite)this.composite, 128);
        this.tabs.setLayoutData((Object)data);
        this.general = new TabItem(this.tabs, 0);
        this.general.setText(DropWizardMessages.General_Tab_Title);
        Composite generalTabContent = new Composite((Composite)this.tabs, 0);
        this.general.setControl((Control)this.fillGeneralOption(generalTabContent));
        TabItem advanced = new TabItem(this.tabs, 0);
        advanced.setText(DropWizardMessages.Advanced_Tab_Title);
        TagAttributesComposite advancedTabContent = new TagAttributesComposite((Composite)this.tabs, 0, this.getSpecificWizard().getWizardModel(), this.context);
        advanced.setControl((Control)advancedTabContent);
        this.tabs.addSelectionListener((SelectionListener)advancedTabContent);
        this.setControl((Control)this.composite);
        this.getSpecificWizard().getWizardModel().addPropertyChangeListener("tagProposal", (PropertyChangeListener)((Object)this));
        this.updateTitle();
        this.runValidation();
    }

    protected void updateTitle() {
        TagProposal tagProposal = (TagProposal)this.getDropWizardModel().getTagProposal();
        StringBuilder titleText = new StringBuilder();
        titleText.append("<");
        if (!"".equals(tagProposal.getPrefix())) {
            titleText.append(tagProposal.getPrefix()).append(":");
        }
        titleText.append(tagProposal.getName()).append(">");
        this.setTitle(titleText.toString());
    }

    public Composite fillGeneralOption(Composite generalTabContent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        generalTabContent.setLayout((Layout)layout);
        XModel model = this.getXModel();
        if (model == null) {
            model = XModelFactory.getDefaultInstance();
        }
        this.support.init(model.getRoot(), this.data);
        Composite c = this.support.createControl(generalTabContent);
        this.pcl = new PCL();
        this.support.addPropertyChangeListener(this.pcl);
        this.fWizardModel = this.getSpecificWizard().getWizardModel();
        this.mpcl = new MPCL();
        this.fWizardModel.addPropertyChangeListener(this.mpcl);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        c.setLayoutData((Object)data);
        data = new GridData(32);
        generalTabContent.setLayoutData((Object)data);
        Label properties = new Label(generalTabContent, 0);
        properties.setText(JsfUIMessages.DataTableWizardPage_Properties);
        data = new GridData(768);
        data.horizontalSpan = 3;
        properties.setLayoutData((Object)data);
        this.propertyListEditor.setObject(this.propertyListObject);
        Control propertiesTable = this.propertyListEditor.createControl(generalTabContent);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        propertiesTable.setLayoutData((Object)data);
        return generalTabContent;
    }

    public void validate() throws ValidationException {
        super.validate();
        String value = this.getValue();
        if (value != null) {
            value = value.trim();
        }
        if (value != null && value.length() > 0) {
            try {
                boolean b1 = value.matches("[#\\$]\\{[^#\\$\\}\\{]*\\}");
                if (!b1) {
                    throw new ValidationException(JsfUIMessages.DataTableWizardPage_ValueMustBeSetWithEL);
                }
                boolean b2 = value.matches("[#\\$]\\{[^#\\$\\}\\{\\.]+(\\.[^#\\$\\}\\{\\.]+)*\\}");
                if (!b2) {
                    throw new ValidationException(JsfUIMessages.DataTableWizardPage_ValueELNotCorrect);
                }
            }
            catch (PatternSyntaxException e) {
                JsfUiPlugin.getDefault().logError(e);
            }
        }
    }

    void onValueChanged(String ov, String nv) {
        String[] vs = this.propertiesHash.get(nv);
        if (vs == null) {
            vs = new String[]{};
        }
        String[] ovs = this.getSelectedProperties();
        if (ov != null && ovs != null) {
            this.propertiesHash.put(ov, ovs);
        }
        this.setSelectedProperties(vs);
        this.propertyListEditor.updateBar();
    }

    private void setSelectedProperties(String[] s) {
        XModelObject[] cs = this.propertyListObject.getChildren();
        int i = 0;
        while (i < cs.length) {
            cs[i].removeFromParent();
            ++i;
        }
        i = 0;
        while (i < s.length) {
            XModelObject c = this.propertyListObject.getModel().createModelObject("JSFDataTableProperty", null);
            c.setAttributeValue("name", s[i]);
            this.propertyListObject.addChild(c);
            ++i;
        }
        this.propertyListEditor.update();
    }

    public String[] getSelectedProperties() {
        this.support.store();
        XModelObject[] cs = this.propertyListObject.getChildren();
        String[] s = new String[cs.length];
        int i = 0;
        while (i < cs.length) {
            s[i] = cs[i].getAttributeValue("name");
            ++i;
        }
        return s;
    }

    private String[] getAvailableProperties(String value) {
        XModelObject f;
        IFile file;
        if (value == null || value.length() == 0) {
            return new String[0];
        }
        JSFPromptingProvider provider = new JSFPromptingProvider();
        XModel xModel = this.getXModel();
        if (xModel == null && (file = (IFile)this.properties.get("file")) != null && (f = EclipseResourceUtil.createObjectForResource((IResource)file)) != null) {
            xModel = f.getModel();
        }
        if (xModel == null) {
            return new String[0];
        }
        return provider.buildBeanProperties(xModel, value, null).toArray(new String[0]);
    }

    public void setTagAttributesValues() {
        this.support.store();
        this.fWizardModel.setAttributeValue("value", (Object)this.data.getValue("value"));
        this.fWizardModel.setAttributeValue("var", (Object)this.data.getValue("var"));
    }

    public String getVar() {
        return this.data.getValue("var");
    }

    public String getValue() {
        return this.data.getValue("value");
    }

    private XModel getXModel() {
        IFile file = (IFile)this.properties.get("file");
        return file == null ? null : DataTableWizardPage.getXModel(file);
    }

    public static XModel getXModel(IFile file) {
        if (file == null) {
            return null;
        }
        XModelObject fs = EclipseResourceUtil.getObjectByResource((IResource)file);
        if (fs != null) {
            return fs.getModel();
        }
        IProject project = file.getProject();
        IModelNature nature = EclipseResourceUtil.getModelNature((IProject)project);
        return nature == null ? null : nature.getModel();
    }

    public void dispose() {
        if (this.pcl != null && this.support != null) {
            this.support.removePropertyChangeListener(this.pcl);
            this.pcl = null;
        }
        if (this.mpcl != null && this.fWizardModel != null) {
            this.fWizardModel.removePropertyChangeListener(this.mpcl);
            this.mpcl = null;
        }
        super.dispose();
    }

    class MPCL
    implements PropertyChangeListener {
        MPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!DataTableWizardPage.this.flag) {
                DataTableWizardPage.this.flag = true;
                TagAttributesComposite.AttributeDescriptorValue[] value = DataTableWizardPage.this.fWizardModel.getAttributeValueDescriptors();
                int i = 0;
                while (i < 2) {
                    if (value[i].getName().equals("value")) {
                        DataTableWizardPage.this.support.store();
                        DataTableWizardPage.this.support.getPropertyEditorAdapterByName("value").setValue((Object)((String)value[i].getValue()));
                    }
                    if (value[i].getName().equals("var")) {
                        DataTableWizardPage.this.support.store();
                        DataTableWizardPage.this.support.getPropertyEditorAdapterByName("var").setValue((Object)((String)value[i].getValue()));
                    }
                    ++i;
                }
                DataTableWizardPage.this.flag = false;
            }
        }
    }

    class PCL
    implements PropertyChangeListener {
        PCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!DataTableWizardPage.this.flag) {
                DataTableWizardPage.this.flag = true;
                if ("IPropertyEditor.value".equals(evt.getPropertyName()) && evt.getSource() == DataTableWizardPage.this.support.getPropertyEditorAdapterByName("value bean class")) {
                    DataTableWizardPage.this.onValueChanged((String)evt.getOldValue(), (String)evt.getNewValue());
                }
                DataTableWizardPage.this.setTagAttributesValues();
                DataTableWizardPage.this.flag = false;
            }
        }
    }

    class XChildrenEditorImpl
    extends XChildrenEditor {
        XChildrenEditorImpl() {
        }

        protected AbstractTableHelper createHelper() {
            return new Helper();
        }

        protected String getAddActionPath() {
            return "CreateActions.AddProperties";
        }

        public void action(String command) {
            super.action(command);
        }

        protected boolean areUpDounActionsEnabled() {
            return true;
        }

        protected void add() {
            String s;
            String[] ap = DataTableWizardPage.this.getAvailableProperties(DataTableWizardPage.this.data.getValue("value bean class"));
            String[] sp = DataTableWizardPage.this.getSelectedProperties();
            Properties p = new Properties();
            HashSet<String> set1 = new HashSet<String>();
            TreeSet<String> set2 = new TreeSet<String>();
            int i = 0;
            while (i < sp.length) {
                set1.add(sp[i]);
                ++i;
            }
            i = 0;
            while (i < ap.length) {
                if (!set1.contains(ap[i])) {
                    set2.add(ap[i]);
                }
                ++i;
            }
            String[][] vs = new String[set1.size() + set2.size()][2];
            int k = 0;
            Iterator iterator = set1.iterator();
            while (iterator.hasNext()) {
                vs[k][0] = s = (String)iterator.next();
                vs[k][1] = "no";
                ++k;
            }
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                vs[k][0] = s = (String)iterator.next();
                vs[k][1] = "yes";
                ++k;
            }
            p.put("data", vs);
            SelectPropertiesWizard w = new SelectPropertiesWizard();
            p.setProperty("title", JsfUIMessages.DataTableWizardPage_BeanProperties);
            w.setObject(p);
            int r = w.execute();
            if (r != 0) {
                return;
            }
            vs = (String[][])p.get("data");
            ArrayList<String> list = new ArrayList<String>();
            int i2 = 0;
            while (i2 < vs.length) {
                if (vs[i2][1].equals("no")) {
                    list.add(vs[i2][0]);
                }
                ++i2;
            }
            sp = list.toArray(new String[0]);
            DataTableWizardPage.this.setSelectedProperties(sp);
        }

        protected void updateBar() {
            super.updateBar();
            String[] ap = DataTableWizardPage.this.getAvailableProperties(DataTableWizardPage.this.data.getValue("value bean class"));
            boolean addflag = false;
            if (ap.length > 0) {
                addflag = true;
            }
            this.bar.setEnabled(ADD, addflag);
        }
    }
}

