/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.el.refactoring;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.services.IServiceLocator;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELObject;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegment;
import org.jboss.tools.common.el.core.resolver.MessagePropertyELSegment;
import org.jboss.tools.common.model.ui.editor.EditorPartWrapper;
import org.jboss.tools.common.propertieseditor.PropertiesCompoundEditor;
import org.jboss.tools.jsf.el.refactoring.RenameELVariableProcessor;
import org.jboss.tools.jsf.el.refactoring.RenameMessagePropertyProcessor;
import org.jboss.tools.jsf.ui.JsfUIMessages;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.el.refactoring.RenameELVariableWizard;
import org.jboss.tools.jsf.ui.el.refactoring.RenameMessagePropertyWizard;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.ui.editors.WebCompoundEditor;

public class ELRefactorContributionFactory
extends AbstractContributionFactory {
    private static final String JAVA_EXT = "java";
    private static final String XML_EXT = "xml";
    private static final String XHTML_EXT = "xhtml";
    private static final String JSP_EXT = "jsp";
    private static final String PROPERTIES_EXT = "properties";
    private static IFile editorFile;
    private IEditorPart editor;
    private Shell shell;

    public ELRefactorContributionFactory() {
        super("", "");
    }

    public ELRefactorContributionFactory(String location, String namespace) {
        super(location, namespace);
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        if (serviceLocator.hasService(IWorkbenchLocationService.class)) {
            IWorkbenchLocationService service = (IWorkbenchLocationService)serviceLocator.getService(IWorkbenchLocationService.class);
            this.editor = service.getWorkbenchWindow().getActivePage().getActiveEditor();
            this.shell = service.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (!(this.editor.getEditorInput() instanceof FileEditorInput)) {
                return;
            }
            FileEditorInput input = (FileEditorInput)this.editor.getEditorInput();
            editorFile = input.getFile();
            String ext = editorFile.getFileExtension();
            if (!(JAVA_EXT.equalsIgnoreCase(ext) || XML_EXT.equalsIgnoreCase(ext) || XHTML_EXT.equalsIgnoreCase(ext) || JSP_EXT.equalsIgnoreCase(ext) || PROPERTIES_EXT.equalsIgnoreCase(ext))) {
                return;
            }
            MenuManager mm = new MenuManager(JsfUIMessages.REFACTOR_CONTRIBUTOR_MAIN_MENU);
            mm.setVisible(true);
            boolean separatorIsAdded = false;
            ISelection sel = this.editor.getEditorSite().getSelectionProvider().getSelection();
            if (sel == null || sel.isEmpty()) {
                return;
            }
            if (sel instanceof StructuredSelection) {
                if (this.editor instanceof PropertiesCompoundEditor) {
                    sel = ((PropertiesCompoundEditor)this.editor).getActiveEditor().getSite().getSelectionProvider().getSelection();
                } else if (this.editor instanceof EditorPartWrapper) {
                    EditorPartWrapper wrapperEditor = (EditorPartWrapper)this.editor;
                    if (wrapperEditor.getEditor() instanceof WebCompoundEditor) {
                        WebCompoundEditor xmlEditor = (WebCompoundEditor)wrapperEditor.getEditor();
                        sel = xmlEditor.getActiveEditor().getSite().getSelectionProvider().getSelection();
                    }
                } else if (this.editor instanceof WebCompoundEditor) {
                    sel = ((WebCompoundEditor)this.editor).getActiveEditor().getSite().getSelectionProvider().getSelection();
                }
            }
            if (sel instanceof TextSelection) {
                TextSelection selection = (TextSelection)sel;
                ELSegment segment = ELRefactorContributionFactory.findELSegment(editorFile, selection);
                if (segment == null) {
                    return;
                }
                if (segment instanceof MessagePropertyELSegment) {
                    mm.add((IAction)new RenameMessagePropertyAction((MessagePropertyELSegment)segment));
                    if (!separatorIsAdded) {
                        additions.addContributionItem((IContributionItem)new Separator(), null);
                        separatorIsAdded = true;
                    }
                }
                if (segment instanceof JavaMemberELSegment) {
                    mm.add((IAction)new RenameELVariableAction((JavaMemberELSegment)segment));
                    if (!separatorIsAdded) {
                        additions.addContributionItem((IContributionItem)new Separator(), null);
                        separatorIsAdded = true;
                    }
                }
                if (mm.getSize() > 0) {
                    additions.addContributionItem((IContributionItem)mm, null);
                }
            }
        }
    }

    public static ELSegment findELSegment(IFile file, TextSelection selection) {
        ELContext context = PageContextFactory.createPageContext((IFile)file);
        if (context == null) {
            return null;
        }
        ELReference reference = context.getELReference(selection.getOffset());
        if (reference == null) {
            return null;
        }
        ELResolver[] resolvers = context.getElResolvers();
        ELExpression[] eLExpressionArray = reference.getEl();
        int n = eLExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ELExpression operand = eLExpressionArray[n2];
            ELSegment segment = ELRefactorContributionFactory.getSegment(resolvers, context, selection, reference, operand);
            if (segment != null) {
                return segment;
            }
            for (ELObject child : operand.getChildren()) {
                if (!(child instanceof ELExpression) || (segment = ELRefactorContributionFactory.getSegment(resolvers, context, selection, reference, (ELExpression)child)) == null) continue;
                return segment;
            }
            ++n2;
        }
        return null;
    }

    private static ELSegment getSegment(ELResolver[] resolvers, ELContext context, TextSelection selection, ELReference reference, ELExpression operand) {
        ELResolver[] eLResolverArray = resolvers;
        int n = resolvers.length;
        int n2 = 0;
        while (n2 < n) {
            ELResolver resolver = eLResolverArray[n2];
            ELResolution resolution = resolver.resolve(context, operand, selection.getOffset());
            if (resolution != null) {
                List segments = resolution.getSegments();
                for (ELSegment segment : segments) {
                    if (!segment.isResolved()) break;
                    if (segment.getSourceReference().getStartPosition() < 0 || segment.getSourceReference().getLength() < 0 || selection.getOffset() > reference.getStartPosition() + segment.getSourceReference().getStartPosition() || selection.getOffset() + selection.getLength() < reference.getStartPosition() + segment.getSourceReference().getStartPosition() + segment.getSourceReference().getLength() || !(segment instanceof MessagePropertyELSegment) && !(segment instanceof JavaMemberELSegment)) continue;
                    return segment;
                }
            }
            ++n2;
        }
        return null;
    }

    private static void saveAndBuild() {
        if (!JsfUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true)) {
            return;
        }
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void invokeRenameELVariableWizard(String oldName, Shell activeShell) {
        ELRefactorContributionFactory.saveAndBuild();
        RenameELVariableProcessor processor = new RenameELVariableProcessor(editorFile, oldName);
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        RenameELVariableWizard wizard = new RenameELVariableWizard((Refactoring)refactoring, editorFile);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            String titleForFailedChecks = JsfUIMessages.EL_REFACTOR_RENAME_HANDLER_ERROR;
            op.run(activeShell, titleForFailedChecks);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void invokeRenameMessagePropertyWizard(MessagePropertyELSegment segment, Shell activeShell) {
        ELRefactorContributionFactory.saveAndBuild();
        RenameMessagePropertyProcessor processor = new RenameMessagePropertyProcessor(editorFile, segment);
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        RenameMessagePropertyWizard wizard = new RenameMessagePropertyWizard((Refactoring)refactoring, editorFile);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            String titleForFailedChecks = JsfUIMessages.EL_REFACTOR_RENAME_HANDLER_ERROR;
            op.run(activeShell, titleForFailedChecks);
        }
        catch (InterruptedException interruptedException) {}
    }

    class RenameELVariableAction
    extends Action {
        JavaMemberELSegment segment;

        public RenameELVariableAction(JavaMemberELSegment segment) {
            super(JsfUIMessages.REFACTOR_CONTRIBUTOR_RENAME_EL_VARIABLE);
            this.segment = segment;
        }

        public void run() {
            ELRefactorContributionFactory.saveAndBuild();
            ELRefactorContributionFactory.invokeRenameELVariableWizard(this.segment.getToken().getText(), ELRefactorContributionFactory.this.shell);
        }
    }

    class RenameMessagePropertyAction
    extends Action {
        MessagePropertyELSegment segment;

        public RenameMessagePropertyAction(MessagePropertyELSegment segment) {
            super(JsfUIMessages.REFACTOR_CONTRIBUTOR_RENAME_MESSAGE_PROPERTY);
            this.segment = segment;
        }

        public void run() {
            ELRefactorContributionFactory.saveAndBuild();
            ELRefactorContributionFactory.invokeRenameMessagePropertyWizard(this.segment, ELRefactorContributionFactory.this.shell);
        }
    }
}

