/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.edit.xpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.jboss.tools.jsf.ui.editor.figures.ConnectionFigure;
import org.jboss.tools.jsf.ui.editor.figures.GroupFigure;
import org.jboss.tools.jsf.ui.editor.figures.PageFigure;

public final class JSFConnectionRouter
extends AbstractRouter {
    private Set<Integer> rowsUsed = new HashSet<Integer>();
    private Set<Integer> colsUsed = new HashSet<Integer>();
    private static final int STEP = 8;
    private static final int STATUS_NOTHING = 0;
    private static final int STATUS_HOLD = 2;
    private static final int STATUS_SHIFT = 3;
    private Map<Connection, ReservedInfo> reservedInfo = new HashMap<Connection, ReservedInfo>();
    private static Ray UP = new Ray(0, -1);
    private static Ray DOWN = new Ray(0, 1);
    private static Ray LEFT = new Ray(-1, 0);
    private static Ray RIGHT = new Ray(1, 0);

    public void invalidate(Connection connection) {
        this.removeReservedLines(connection);
    }

    private int getColumnNear(Connection conn, int r, int n, int x, boolean flag) {
        int index = 0;
        int size = 0;
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        if (flag) {
            if (conn.getSourceAnchor().getOwner() != null) {
                IFigure fig = conn.getSourceAnchor().getOwner();
                GroupFigure group = null;
                if (fig instanceof GroupFigure) {
                    group = (GroupFigure)fig;
                } else if (fig instanceof PageFigure) {
                    group = (GroupFigure)fig.getParent();
                }
                if (group != null) {
                    index = group.group.getListOutputLinks().indexOf(((ConnectionFigure)conn).getLinkModel());
                    size = group.group.getListOutputLinks().size();
                } else {
                    flag = false;
                }
            } else {
                flag = false;
            }
        }
        if (flag) {
            int value = min + 100 + (size - index) * 8 - size / 2 * 8;
            if (value <= min) {
                return min + 8;
            }
            if (value >= max) {
                return max - 8;
            }
            return value;
        }
        int proximity = 0;
        int direction = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proximity < r) {
            Integer i = r + proximity * direction;
            if (!this.colsUsed.contains(i)) {
                this.colsUsed.add(i);
                this.reserveColumn(conn, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 8;
            }
            if (j >= max) {
                return j - 8;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 8;
        }
        return r;
    }

    protected Ray getDirection(Rectangle r, Point p) {
        int distance = Math.abs(r.x - p.x);
        Ray direction = LEFT;
        int i = Math.abs(r.y - p.y);
        if (i <= distance) {
            distance = i;
            direction = UP;
        }
        if ((i = Math.abs(r.bottom() - p.y)) <= distance) {
            distance = i;
            direction = DOWN;
        }
        if ((i = Math.abs(r.right() - p.x)) < distance) {
            distance = i;
            direction = RIGHT;
        }
        return direction;
    }

    protected Ray getEndDirection(Connection conn) {
        return LEFT;
    }

    protected int getRowNear(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proximity = 0;
        int direction = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proximity < r) {
            Integer i = r + proximity * direction;
            if (!this.rowsUsed.contains(i)) {
                this.rowsUsed.add(i);
                this.reserveRow(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 8;
            }
            if (j >= max) {
                return j - 8;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 8;
        }
        return r;
    }

    protected Ray getStartDirection(Connection conn) {
        return RIGHT;
    }

    protected void processPositions(Ray start, Ray end, List positions, boolean horizontal, Connection conn) {
        this.removeReservedLines(conn);
        int[] pos = new int[positions.size() + 2];
        pos[0] = horizontal ? start.x : start.y;
        int i = 0;
        while (i < positions.size()) {
            pos[i + 1] = (Integer)positions.get(i);
            ++i;
        }
        pos[++i] = horizontal == (positions.size() % 2 == 1) ? end.x : end.y;
        PointList points = new PointList();
        points.addPoint(new Point(start.x, start.y));
        i = 2;
        while (i < pos.length - 1) {
            Point p;
            int max;
            int min;
            boolean adjust;
            horizontal = !horizontal;
            int prev = pos[i - 1];
            int current = pos[i];
            boolean bl = adjust = i != pos.length - 2;
            if (horizontal) {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    pos[i] = current = this.getRowNear(conn, current, min, max);
                    current -= current % 8;
                    int n = i;
                    pos[n] = pos[n] - pos[i] % 8;
                }
                p = new Point(prev, current);
            } else {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    boolean flag = i == 2 && pos.length == 5;
                    pos[i] = current = this.getColumnNear(conn, current, min, max, flag);
                    current -= current % 8;
                    int n = i;
                    pos[n] = pos[n] - pos[i] % 8;
                }
                p = new Point(current, prev);
            }
            points.addPoint(p);
            ++i;
        }
        points.addPoint(new Point(end.x, end.y));
        conn.setPoints(points);
    }

    public void remove(Connection connection) {
        this.removeReservedLines(connection);
    }

    protected void removeReservedLines(Connection connection) {
        ReservedInfo rInfo = this.reservedInfo.get(connection);
        if (rInfo == null) {
            return;
        }
        int i = 0;
        while (i < rInfo.reservedRows.size()) {
            this.rowsUsed.remove(rInfo.reservedRows.get(i));
            ++i;
        }
        i = 0;
        while (i < rInfo.reservedCols.size()) {
            this.colsUsed.remove(rInfo.reservedCols.get(i));
            ++i;
        }
        this.reservedInfo.remove(connection);
    }

    protected void reserveColumn(Connection connection, Integer column) {
        ReservedInfo info = this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedCols.add(column);
    }

    protected void reserveRow(Connection connection, Integer row) {
        ReservedInfo info = this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedRows.add(row);
    }

    public void route(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        if (((ConnectionFigure)conn).getLinkModel() != null && ((ConnectionFigure)conn).getLinkModel().isShortcut()) {
            Point startPoint = this.getStartPoint(conn);
            conn.translateToRelative((Translatable)startPoint);
            ArrayList<Integer> positions = new ArrayList<Integer>(5);
            Ray start = new Ray(startPoint);
            positions.add(start.y);
            Point endPoint = new Point(startPoint.x + 18, startPoint.y);
            Ray end = new Ray(endPoint);
            this.processPositions(start, end, positions, true, conn);
            return;
        }
        if (((ConnectionFigure)conn).isManual()) {
            if (conn.getPoints().size() < 4) {
                PointList list = ((ConnectionFigure)conn).getLinkModel().getPointList();
                ((ConnectionFigure)conn).setOldPoints(list.getFirstPoint(), list.getLastPoint());
                conn.setPoints(list);
            }
            if (this.hold((ConnectionFigure)conn)) {
                return;
            }
            ((ConnectionFigure)conn).setManual(false);
            ((ConnectionFigure)conn).clear();
        }
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)endPoint);
        Ray start = new Ray(startPoint);
        Ray end = new Ray(endPoint);
        Ray average = start.getAveraged(end);
        Ray direction = new Ray(start, end);
        Ray startNormal = this.getStartDirection(conn);
        Ray endNormal = this.getEndDirection(conn);
        ArrayList<Integer> positions = new ArrayList<Integer>(5);
        boolean horizontal = true;
        positions.add(start.y);
        boolean bl = horizontal = !horizontal;
        if (start.x > end.x + 20 && Math.abs(end.y - start.y) < 100) {
            int i = startNormal.similarity(start.getAdded(startNormal.getScaled(10)));
            positions.add(i);
            boolean bl2 = horizontal = !horizontal;
            if (conn.getSourceAnchor().getOwner() == null) {
                i = average.y;
            } else {
                Rectangle rec = conn.getSourceAnchor().getOwner().getBounds();
                i = rec.y + rec.height + 8;
            }
            i -= i % 8;
            positions.add(i);
            horizontal = !horizontal;
            i = endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
            i -= i % 8;
            positions.add(i);
            horizontal = !horizontal;
        } else {
            if (startNormal.dotProduct(direction) < 16) {
                int i = startNormal.similarity(start.getAdded(startNormal.getScaled(10)));
                i -= i % 8;
                positions.add(i);
                horizontal = !horizontal;
            }
            int i = horizontal ? average.y : average.x;
            i -= i % 8;
            positions.add(i);
            boolean bl3 = horizontal = !horizontal;
            if (startNormal.dotProduct(direction) < 16) {
                i = endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
                i -= i % 8;
                positions.add(i);
                horizontal = !horizontal;
            }
        }
        positions.add(end.y);
        this.processPositions(start, end, positions, true, conn);
        ((ConnectionFigure)conn).setOldPoints(startPoint, endPoint);
    }

    private boolean hold(ConnectionFigure conn) {
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)endPoint);
        int status = this.check(conn);
        if (status == 0) {
            return true;
        }
        if (status == 3) {
            this.shift(conn);
            conn.setOldPoints(startPoint, endPoint);
            conn.save();
            return true;
        }
        PointList list = conn.getPoints();
        list.removePoint(0);
        list.insertPoint(startPoint, 0);
        list.removePoint(list.size() - 1);
        list.addPoint(endPoint);
        if (list.size() > 2) {
            Point p1 = list.getPoint(1);
            p1.y = startPoint.y;
            if (p1.x <= startPoint.x) {
                return false;
            }
            Point p2 = list.getPoint(list.size() - 2);
            p2.y = endPoint.y;
            if (p2.x >= endPoint.x) {
                return false;
            }
            list.removePoint(1);
            list.insertPoint(p1, 1);
            int index = list.size() - 2;
            list.removePoint(index);
            list.insertPoint(p2, index);
        }
        conn.setPoints(list);
        conn.setOldPoints(startPoint, endPoint);
        conn.save();
        return true;
    }

    private void shift(ConnectionFigure conn) {
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point oldStartPoint = conn.getOldStartPoint();
        Point shiftPoint = new Point(startPoint.x - oldStartPoint.x, startPoint.y - oldStartPoint.y);
        PointList list = conn.getPoints();
        if (list.getPoint((int)0).x == startPoint.x && list.getPoint((int)0).y == startPoint.y) {
            return;
        }
        int i = 0;
        while (i < list.size()) {
            Point point = list.getPoint(i);
            point.x += shiftPoint.x;
            point.y += shiftPoint.y;
            list.removePoint(i);
            list.insertPoint(point, i);
            ++i;
        }
        conn.setPoints(list);
    }

    private int check(ConnectionFigure conn) {
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)endPoint);
        Point oldStartPoint = conn.getOldStartPoint();
        Point oldEndPoint = conn.getOldEndPoint();
        if (startPoint.x == oldStartPoint.x && startPoint.y == oldStartPoint.y && endPoint.x == oldEndPoint.x && endPoint.y == oldEndPoint.y) {
            return 0;
        }
        if (startPoint.x - oldStartPoint.x == endPoint.x - oldEndPoint.x && startPoint.y - oldStartPoint.y == endPoint.y - oldEndPoint.y) {
            return 3;
        }
        return 2;
    }

    private class ReservedInfo {
        public List<Integer> reservedRows = new ArrayList<Integer>(2);
        public List<Integer> reservedCols = new ArrayList<Integer>(2);

        private ReservedInfo() {
        }
    }
}

