/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.util.Map;
import java.util.Properties;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.console.FakeTransaction;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;

class FakeTransactionManager
implements TransactionManager {
    public static FakeTransactionManager INSTANCE;
    private FakeTransaction current;
    ConnectionProvider connections;

    public FakeTransactionManager(Properties props) {
        ServiceRegistryBuilder builder = new ServiceRegistryBuilder();
        ServiceRegistry buildServiceRegistry = builder.applySettings((Map)props).buildServiceRegistry();
        this.connections = (ConnectionProvider)buildServiceRegistry.getService(ConnectionProvider.class);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.current = new FakeTransaction(this);
        this.current.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.current != null) {
            this.current.commit();
        }
    }

    public int getStatus() throws SystemException {
        if (this.current != null) {
            return this.current.getStatus();
        }
        return 6;
    }

    public Transaction getTransaction() throws SystemException {
        return this.current;
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.current = (FakeTransaction)tx;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.current != null) {
            this.current.rollback();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.current != null) {
            this.current.setRollbackOnly();
        }
    }

    public void setTransactionTimeout(int t) throws SystemException {
    }

    public Transaction suspend() throws SystemException {
        FakeTransaction result = this.current;
        this.current = null;
        return result;
    }

    public FakeTransaction getCurrent() {
        return this.current;
    }

    void endCurrent(FakeTransaction tx) {
        if (this.current == tx) {
            this.current = null;
        }
    }
}

