/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.resref.core;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.vpe.resref.core.CSSResourceReferenceValidator;
import org.jboss.tools.vpe.resref.core.Messages;
import org.jboss.tools.vpe.resref.core.ReferenceWizardPage;
import org.jboss.tools.vpe.resref.core.ResourceReferenceValidator;

public class CSSReferenceWizardPage
extends ReferenceWizardPage {
    private final String[] FILTER_EXTENSIONS = new String[]{"*.css"};
    private String browseDialogFilterPath = null;
    private Text cssName = null;
    private String cssNameStr = "";

    public CSSReferenceWizardPage(String pageName, String title, ImageDescriptor titleImage, Object fileLocation) {
        super(pageName, title, titleImage, fileLocation);
        if (fileLocation instanceof IFile) {
            this.browseDialogFilterPath = ((IFile)fileLocation).getProject().getLocation().toString();
        } else if (fileLocation instanceof IPath) {
            this.browseDialogFilterPath = ((IPath)fileLocation).toString();
        }
    }

    public void createControl(Composite parent) {
        Composite pageControl = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        pageControl.setLayout((Layout)gridLayout);
        GridData gd = new GridData(4, 4, true, true);
        pageControl.setLayoutData((Object)gd);
        Label pathLabel = new Label(pageControl, 131072);
        pathLabel.setText(Messages.CSS_FILE_PATH);
        gd = new GridData();
        pathLabel.setLayoutData((Object)gd);
        this.cssName = new Text(pageControl, 2048);
        gd = new GridData(4, 0, true, false);
        this.cssName.setLayoutData((Object)gd);
        this.cssName.setText(this.cssNameStr);
        final Button button = new Button(pageControl, 8);
        button.setText("&Browse...");
        gd = new GridData();
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog dialog = new FileDialog(button.getShell(), 4096);
                if (CSSReferenceWizardPage.this.browseDialogFilterPath != null) {
                    dialog.setFilterPath(CSSReferenceWizardPage.this.browseDialogFilterPath);
                }
                dialog.setFilterExtensions(CSSReferenceWizardPage.this.FILTER_EXTENSIONS);
                String newPath = dialog.open();
                if (newPath != null) {
                    newPath = newPath.trim();
                    CSSReferenceWizardPage.this.cssName.setText(newPath);
                    if (new File(newPath).exists()) {
                        CSSReferenceWizardPage.this.browseDialogFilterPath = newPath;
                    }
                }
            }
        });
        new Label(pageControl, 0);
        Group groupControl = this.createScopeGroup(pageControl);
        gd = new GridData(4, 0, true, false, 2, 1);
        groupControl.setLayoutData((Object)gd);
        this.cssName.addSelectionListener((SelectionListener)this);
        this.cssName.addListener(13, (Listener)this);
        this.cssName.addListener(24, (Listener)this);
        this.setControl((Control)pageControl);
    }

    @Override
    protected ResourceReferenceValidator getUpdatedValidator() {
        HashMap<String, String> fields = new HashMap<String, String>();
        if (this.cssName != null && this.cssName.getText() != null) {
            fields.put("cssFilePath", this.cssName.getText().trim());
        }
        if (this.validator == null) {
            this.validator = new CSSResourceReferenceValidator(fields);
        } else {
            this.validator.setFields(fields);
        }
        return this.validator;
    }

    public String getCssName() {
        if (this.cssName != null && this.cssName.getText() != null) {
            this.cssNameStr = this.cssName.getText().trim();
        }
        return this.cssNameStr;
    }

    @Override
    protected String getLocation() {
        return this.getCssName();
    }

    @Override
    protected String getProperties() {
        return "";
    }

    @Override
    protected void setLocation(String location) {
        this.cssNameStr = location;
    }

    @Override
    protected void setProperties(String properties) {
    }
}

