/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.wizard.service;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.java.ParametedTypeFactory;
import org.jboss.tools.common.ui.CommonUIImages;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.common.ui.wizard.service.RegisterServiceUtil;

public class RegisterAsServiceDialog
extends TitleAreaDialog {
    IType type;
    Map<String, IParametedType> types;
    IFieldEditor serviceTypeSelector;
    String result;
    private final int DIALOG_WIDTH = 400;
    private final int DIALOG_HEIGHT = 60;

    public RegisterAsServiceDialog(Shell parentShell, IType type) {
        super(parentShell);
        this.type = type;
        this.initTypes();
        this.setShellStyle(this.getShellStyle() | 0x10);
        ArrayList<String> serviceTypeNames = new ArrayList<String>(this.types.keySet());
        String defaultValue = serviceTypeNames.isEmpty() ? "" : (String)serviceTypeNames.get(0);
        this.serviceTypeSelector = IFieldEditorFactory.INSTANCE.createComboEditor("serviceType", CommonUIMessages.REGISTER_AS_SERVICE_TYPE_LABEL, serviceTypeNames, defaultValue);
    }

    void initTypes() {
        ParametedType parametedType = new ParametedTypeFactory().newParametedType(this.type);
        Collection ts = parametedType.getAllTypes();
        TreeMap<String, IParametedType> types = new TreeMap<String, IParametedType>();
        for (IParametedType t : ts) {
            if (t.getType() == null) continue;
            String q = t.getType().getFullyQualifiedName();
            types.put(q, t);
        }
        types.remove("java.lang.Object");
        types.remove(this.type.getFullyQualifiedName());
        this.types = types;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CommonUIMessages.REGISTER_AS_SERVICE_TITLE);
        this.setTitle(NLS.bind((String)CommonUIMessages.REGISTER_AS_SERVICE_SUB_TITLE, (Object)this.type.getFullyQualifiedName()));
        this.setTitleImage(CommonUIImages.getInstance().getOrCreateImage("wizard/JavaServiceProviderWizBan.png"));
        this.setMessage(CommonUIMessages.REGISTER_AS_SERVICE_MESSAGE);
        if (this.types.isEmpty()) {
            this.setErrorMessage(CommonUIMessages.REGISTER_AS_SERVICE_NO_TYPES_MESSAGE);
        }
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        Label dialogAreaSeparator = new Label(composite, 258);
        dialogAreaSeparator.setLayoutData((Object)new GridData(4, 0, true, false));
        Control pageArea = this.createField(composite);
        GridData gd = new GridData(4, 1, true, true);
        pageArea.setLayoutData((Object)gd);
        dialogAreaSeparator = new Label(composite, 258);
        dialogAreaSeparator.setLayoutData((Object)new GridData(4, 0, true, false));
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        gd.heightHint = 60;
        composite.setLayoutData((Object)gd);
        return composite;
    }

    Control createField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)gridLayout);
        this.serviceTypeSelector.doFillIntoGrid(composite);
        Object[] os = this.serviceTypeSelector.getEditorControls();
        if (os.length == 2 && os[1] instanceof Combo) {
            ((Combo)os[1]).setLayoutData((Object)new GridData(768));
        }
        this.serviceTypeSelector.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RegisterAsServiceDialog.this.validate();
            }
        });
        return composite;
    }

    void validate() {
        String serviceType = this.serviceTypeSelector.getValueAsString();
        if (serviceType == null || serviceType.length() == 0) {
            return;
        }
        IParametedType type = this.types.get(serviceType);
        String warning = null;
        if (type != null) {
            IType t = type.getType();
            try {
                if (!t.isInterface() && !Flags.isAbstract((int)t.getFlags())) {
                    warning = CommonUIMessages.REGISTER_AS_SERVICE_NON_ABSTRACT_MESSAGE;
                }
            }
            catch (CoreException e) {
                CommonUIPlugin.getDefault().logError(e);
            }
        }
        String typeName = this.type.getFullyQualifiedName();
        if (RegisterServiceUtil.isServiceRegistered(type.getType().getJavaProject().getProject(), typeName, serviceType)) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(CommonUIMessages.REGISTER_AS_SERVICE_ALREADY_REGISTERED_MESSAGE);
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            if (warning != null) {
                this.setMessage(warning, 2);
            } else {
                this.setMessage(CommonUIMessages.REGISTER_AS_SERVICE_MESSAGE);
            }
        }
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        if (this.types.isEmpty()) {
            Button ok = this.getButton(0);
            ok.setEnabled(false);
        }
        this.validate();
        return c;
    }

    public void okPressed() {
        this.result = this.serviceTypeSelector.getValueAsString();
        super.okPressed();
    }

    public String getResult() {
        return this.result;
    }

    public void setServiceType(String type) {
        if (!this.types.containsKey(type)) {
            throw new IllegalArgumentException(type);
        }
        this.serviceTypeSelector.setValue(type);
    }
}

