/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.widget.field;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;

class MouseHandler
extends MouseAdapter
implements MouseMoveListener {
    Combo combo;
    boolean isSettingFocus = false;
    int basePosition = -1;

    public MouseHandler(Combo combo) {
        this.combo = combo;
        combo.addMouseListener((MouseListener)this);
        combo.addMouseMoveListener((MouseMoveListener)this);
    }

    public void mouseDown(MouseEvent e) {
        if (this.isSettingFocus) {
            return;
        }
        this.isSettingFocus = true;
        try {
            if (!this.combo.isDisposed()) {
                this.combo.setFocus();
                int i = this.getPosition(e.x);
                this.combo.setSelection(new Point(i, i));
                this.basePosition = i;
            }
        }
        finally {
            this.isSettingFocus = false;
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (!this.combo.isDisposed()) {
            this.combo.setSelection(new Point(0, this.combo.getText().length()));
        }
    }

    public void mouseUp(MouseEvent e) {
        this.basePosition = -1;
    }

    public void mouseMove(MouseEvent e) {
        if (this.basePosition < 0 || this.combo.isDisposed()) {
            return;
        }
        int i = this.getPosition(e.x);
        this.combo.setSelection(new Point(this.basePosition, i));
    }

    private int getPosition(int x) {
        int result = 0;
        GC g = new GC((Drawable)this.combo);
        String text = this.combo.getText();
        int cp = this.combo.getCaretPosition();
        if (cp >= 0) {
            x -= this.combo.getCaretLocation().x - g.stringExtent((String)text.substring((int)0, (int)cp)).x;
        }
        int n = text.length();
        int width = g.stringExtent((String)text.substring((int)0, (int)n)).x;
        if (x < 3) {
            result = 0;
        } else if (width < x) {
            result = n;
        } else {
            int c1 = 0;
            int c2 = n;
            while (c2 > c1) {
                int c = (c2 + c1 + 1) / 2;
                int xi = g.stringExtent((String)text.substring((int)0, (int)c)).x;
                int w = g.stringExtent((String)text.substring((int)(c - 1), (int)c)).x;
                if (xi - w < x + 3 && xi > x - 1) {
                    if (xi - w / 2 > x + 3) {
                        result = c - 1;
                        break;
                    }
                    result = c;
                    break;
                }
                if (c == c2) {
                    result = c;
                    break;
                }
                if (x > xi) {
                    c1 = c;
                    continue;
                }
                c2 = c;
            }
        }
        g.dispose();
        return result;
    }
}

