/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.widget.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.widget.editor.BaseFieldEditor;
import org.jboss.tools.common.ui.widget.field.TextField;

public class TextFieldEditor
extends BaseFieldEditor
implements PropertyChangeListener {
    String message = null;
    public static final int UNLIMITED = -1;
    protected int style = -1;
    protected TextField fTextField = null;
    protected int fWidthInChars = 0;

    public TextFieldEditor(String name, String aLabelText, String defaultvalue) {
        super(name, aLabelText, defaultvalue);
    }

    public TextFieldEditor(String name, String aLabelText, String defaultvalue, boolean editable) {
        super(name, aLabelText, defaultvalue);
        this.setEditable(editable);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Object[] getEditorControls() {
        return new Control[]{this.getTextControl()};
    }

    @Override
    public void doFillIntoGrid(Object aParent) {
        Assert.isTrue((boolean)(aParent instanceof Composite), (String)CommonUIMessages.TEXT_FIELD_EDITOR_PARENT_CONTROL_SHOULD_BE_COMPOSITE);
        Assert.isTrue((boolean)(((Composite)aParent).getLayout() instanceof GridLayout), (String)CommonUIMessages.TEXT_FIELD_EDITOR_EDITOR_SUPPORTS_ONLY_GRID_LAYOUT);
        Composite aComposite = (Composite)aParent;
        Control[] cfr_ignored_0 = (Control[])this.getEditorControls(aComposite);
        GridLayout gl = (GridLayout)((Composite)aParent).getLayout();
        this.getTextControl(aComposite);
        GridData gd = new GridData();
        gd.horizontalSpan = gl.numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.fTextField.getTextControl().setLayoutData((Object)gd);
    }

    public Text getTextControl(Composite parent) {
        if (this.fTextField == null) {
            this.fTextField = new TextField(parent, this.getInitialStyle());
            Text textField = this.fTextField.getTextControl();
            textField.setFont(parent.getFont());
            this.getValue();
            textField.setText(this.getValue().toString());
            textField.setEditable(this.isEditable());
            textField.setEnabled(this.isEnabled());
            this.fTextField.addPropertyChangeListener(this);
            if (this.message != null) {
                this.fTextField.getTextControl().setMessage(this.message);
            }
        } else if (parent != null) {
            Assert.isTrue((parent == this.fTextField.getTextControl().getParent() ? 1 : 0) != 0);
        }
        return this.fTextField.getTextControl();
    }

    protected void updateWidgetValues() {
        this.setValueAsString(this.getValueAsString());
    }

    protected int getInitialStyle() {
        if (this.style >= 0) {
            return this.style;
        }
        return 2052;
    }

    private String checkCollection(Object value) {
        return value != null && !((Collection)value).isEmpty() ? this.prepareCollectionToString((Collection)value) : "";
    }

    private String prepareCollectionToString(Collection collection) {
        String stringValue = "";
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < objects.length) {
            stringValue = String.valueOf(stringValue) + objects[i];
            if (i < objects.length - 1) {
                stringValue = String.valueOf(stringValue) + " ";
            }
            ++i;
        }
        return stringValue;
    }

    private String checkSimple(Object value) {
        return value != null ? value.toString() : "";
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    protected Text getTextControl() {
        return this.fTextField != null ? this.fTextField.getTextControl() : null;
    }

    @Override
    public boolean setFocus() {
        boolean setfocus = false;
        if (this.fTextField != null && !this.fTextField.getTextControl().isDisposed()) {
            setfocus = this.fTextField.getTextControl().setFocus();
        }
        return setfocus;
    }

    @Override
    public Object[] getEditorControls(Object composite) {
        return new Control[]{this.getTextControl((Composite)composite)};
    }

    public void save(Object object) {
    }

    @Override
    public void setValue(Object newValue) {
        super.setValue(newValue);
        if (this.fTextField != null) {
            this.fTextField.removePropertyChangeListener(this);
            this.fTextField.getTextControl().setText(newValue.toString());
            this.fTextField.addPropertyChangeListener(this);
        }
    }

    @Override
    public void setEditable(boolean aEditable) {
        super.setEditable(aEditable);
        if (this.getTextControl() != null) {
            this.getTextControl().setEditable(aEditable);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.setValue(evt.getNewValue());
    }
}

