/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.marker;

import java.util.ArrayList;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.quickfix.IQuickFixGenerator;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.common.ui.marker.AddSuppressWarningsMarkerResolution;
import org.jboss.tools.common.ui.marker.ConfigureProblemSeverityMarkerResolution;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.java.TempJavaProblemAnnotation;

public class ConfigureProblemSeverityResolutionGenerator
implements IMarkerResolutionGenerator2,
IQuickFixGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<Object> resolutions = new ArrayList<Object>();
        int position = marker.getAttribute("charStart", 0);
        try {
            IResource resource = marker.getResource();
            String preferenceKey = this.getPreferenceKey(marker);
            String markerType = this.getProblemType(marker);
            IPreferenceInfo info = PreferenceInfoManager.getPreferenceInfo((String)markerType);
            if (this.hasResolutions(preferenceKey, markerType, info, resource)) {
                IJavaElement element;
                int severity;
                String propertyPageId = info.getPropertyPageId();
                String preferencePageId = info.getPreferencePageId();
                String pluginId = info.getPluginId();
                if (resource instanceof IFile && (severity = marker.getAttribute("severity", 0)) == 1 && (element = this.findJavaElement((IFile)resource, position)) != null) {
                    ILocalVariable parameter;
                    if (element instanceof IMethod && (parameter = this.findParameter((IMethod)element, position)) != null) {
                        resolutions.add(new AddSuppressWarningsMarkerResolution((IFile)resource, (IJavaElement)parameter, preferenceKey));
                    }
                    resolutions.add(new AddSuppressWarningsMarkerResolution((IFile)resource, element, preferenceKey));
                }
                resolutions.add(new ConfigureProblemSeverityMarkerResolution(resource.getProject(), preferencePageId, propertyPageId, preferenceKey, pluginId));
            }
        }
        catch (CoreException e) {
            CommonUIPlugin.getDefault().logError(e);
        }
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }

    private IJavaElement findJavaElement(IFile file, int position) {
        try {
            ICompilationUnit compilationUnit = EclipseUtil.getCompilationUnit((IFile)file);
            if (compilationUnit != null) {
                return compilationUnit.getElementAt(position);
            }
        }
        catch (CoreException e) {
            CommonUIPlugin.getDefault().logError(e);
        }
        return null;
    }

    private IJavaElement findJavaElement(TempJavaProblemAnnotation annotation, int position) {
        try {
            ICompilationUnit compilationUnit = annotation.getCompilationUnit();
            if (compilationUnit != null) {
                return compilationUnit.getElementAt(position);
            }
        }
        catch (CoreException e) {
            CommonUIPlugin.getDefault().logError(e);
        }
        return null;
    }

    private ILocalVariable findParameter(IMethod method, int position) throws JavaModelException {
        ILocalVariable[] iLocalVariableArray = method.getParameters();
        int n = iLocalVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalVariable parameter = iLocalVariableArray[n2];
            if (parameter.getSourceRange().getOffset() <= position && parameter.getSourceRange().getOffset() + parameter.getSourceRange().getLength() > position) {
                return parameter;
            }
            ++n2;
        }
        return null;
    }

    private boolean hasResolutions(String preferenceKey, String markerType, IPreferenceInfo markerInfo, IResource resource) {
        return preferenceKey != null && markerType != null && markerInfo != null;
    }

    public boolean hasResolutions(IMarker marker) {
        try {
            String preferenceKey = this.getPreferenceKey(marker);
            String markerType = this.getProblemType(marker);
            IPreferenceInfo info = PreferenceInfoManager.getPreferenceInfo((String)markerType);
            IResource resource = marker.getResource();
            return this.hasResolutions(preferenceKey, markerType, info, resource);
        }
        catch (CoreException e) {
            CommonUIPlugin.getDefault().logError(e);
            return false;
        }
    }

    private String getPreferenceKey(IMarker marker) {
        return marker.getAttribute("preference_key", null);
    }

    private String getProblemType(IMarker marker) throws CoreException {
        if (marker.exists()) {
            try {
                return marker.getType();
            }
            catch (ResourceException resourceException) {}
        }
        return null;
    }

    private String getAttribute(Annotation annotation, String attributeName) {
        if (annotation instanceof TemporaryAnnotation) {
            if (((TemporaryAnnotation)annotation).getAttributes() != null) {
                String attribute = (String)((TemporaryAnnotation)annotation).getAttributes().get(attributeName);
                return attribute;
            }
        } else if (annotation instanceof TempJavaProblemAnnotation && ((TempJavaProblemAnnotation)annotation).getAttributes() != null) {
            String attribute = (String)((TempJavaProblemAnnotation)annotation).getAttributes().get(attributeName);
            return attribute;
        }
        return null;
    }

    public boolean hasProposals(Annotation annotation, Position position) {
        String preferenceKey = this.getAttribute(annotation, "preference_key");
        String problemType = this.getAttribute(annotation, "jbt.type");
        IPreferenceInfo info = PreferenceInfoManager.getPreferenceInfo((String)problemType);
        return preferenceKey != null && problemType != null && info != null;
    }

    public IJavaCompletionProposal[] getProposals(Annotation annotation, Position position) {
        ArrayList<Object> proposals = new ArrayList<Object>();
        String preferenceKey = this.getAttribute(annotation, "preference_key");
        String problemType = this.getAttribute(annotation, "jbt.type");
        IPreferenceInfo info = PreferenceInfoManager.getPreferenceInfo((String)problemType);
        if (info == null) {
            return new IJavaCompletionProposal[0];
        }
        String preferencePageId = info.getPreferencePageId();
        String propertyPageId = info.getPropertyPageId();
        String pluginId = info.getPluginId();
        IFile file = null;
        if (annotation instanceof TempJavaProblemAnnotation) {
            int offset;
            IJavaElement element;
            TempJavaProblemAnnotation tAnnotation = (TempJavaProblemAnnotation)annotation;
            try {
                file = (IFile)tAnnotation.getCompilationUnit().getUnderlyingResource();
            }
            catch (JavaModelException e) {
                CommonUIPlugin.getDefault().logError(e);
            }
            if (file != null && "org.eclipse.jdt.ui.warning".equals(tAnnotation.getType()) && (element = this.findJavaElement(tAnnotation, offset = position.getOffset())) != null) {
                if (element instanceof IMethod) {
                    try {
                        ILocalVariable parameter = this.findParameter((IMethod)element, offset);
                        if (parameter != null) {
                            proposals.add(new AddSuppressWarningsMarkerResolution(file, (IJavaElement)parameter, preferenceKey, tAnnotation.getCompilationUnit()));
                        }
                    }
                    catch (JavaModelException ex) {
                        CommonUIPlugin.getDefault().logError(ex);
                    }
                }
                proposals.add(new AddSuppressWarningsMarkerResolution(file, element, preferenceKey, tAnnotation.getCompilationUnit()));
            }
        } else {
            file = MarkerResolutionUtils.getFile();
        }
        if (file != null) {
            proposals.add(new ConfigureProblemSeverityMarkerResolution(file.getProject(), preferencePageId, propertyPageId, preferenceKey, pluginId));
        }
        return proposals.toArray(new IJavaCompletionProposal[proposals.size()]);
    }
}

