/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.CommonUIPlugin;

public class CommonUIImages {
    private static CommonUIImages INSTANCE;
    public static final String JAVA_SERVICE_PROVIDER_IMAGE = "wizard/JavaServiceProviderWizBan.png";
    public static final String NEW_JAVA_SERVICE_PROVIDER_IMAGE = "wizard/NewJavaServiceProviderWizBan.png";
    public static final String WEB_SERVICE_IMAGE = "wizard/WebServiceWizBan.png";
    protected URL baseUrl;
    protected CommonUIImages parentRegistry;

    static {
        try {
            INSTANCE = new CommonUIImages(new URL(CommonUIPlugin.getDefault().getBundle().getEntry("/"), "icons/"));
        }
        catch (MalformedURLException e) {
            CommonUIPlugin.getDefault().logError(e);
        }
    }

    public static final Image getImage(ImageDescriptor descriptor) {
        return CommonUIPlugin.getImageDescriptorRegistry().get(descriptor);
    }

    public static void setImageDescriptors(IAction action, String iconName) {
        action.setImageDescriptor(CommonUIImages.getInstance().getOrCreateImageDescriptor(iconName));
    }

    public static CommonUIImages getInstance() {
        return INSTANCE;
    }

    protected CommonUIImages(URL registryUrl, CommonUIImages parent) {
        if (registryUrl == null) {
            throw new IllegalArgumentException(CommonUIMessages.IMAGESBASE_URL_FOR_IMAGE_REGISTRY_CANNOT_BE_NULL);
        }
        this.baseUrl = registryUrl;
        this.parentRegistry = parent;
    }

    protected CommonUIImages(URL url) {
        this(url, null);
    }

    protected ImageRegistry getImageRegistry() {
        return CommonUIPlugin.getDefault().getImageRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ImageDescriptor getOrCreateImageDescriptor(String key) {
        ImageRegistry registry;
        ImageDescriptor result = null;
        ImageRegistry imageRegistry = registry = this.getImageRegistry();
        synchronized (imageRegistry) {
            result = registry.getDescriptor(key);
        }
        if (result == null && (result = this.createImageDescriptor(key)) != null) {
            imageRegistry = registry;
            synchronized (imageRegistry) {
                registry.remove(key);
                registry.put(key, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Image getOrCreateImage(String key) {
        ImageRegistry registry;
        this.getOrCreateImageDescriptor(key);
        ImageRegistry imageRegistry = registry = this.getImageRegistry();
        synchronized (imageRegistry) {
            return registry.get(key);
        }
    }

    public final Image getImageByFileName(String key) {
        return this.getOrCreateImage(key);
    }

    public final ImageDescriptor createImageDescriptor(String key) {
        try {
            return ImageDescriptor.createFromURL((URL)this.makeIconFileURL(key));
        }
        catch (MalformedURLException malformedURLException) {
            if (this.parentRegistry == null) {
                return ImageDescriptor.getMissingImageDescriptor();
            }
            return this.parentRegistry.createImageDescriptor(key);
        }
    }

    private URL makeIconFileURL(String name) throws MalformedURLException {
        if (name == null) {
            throw new MalformedURLException(CommonUIMessages.IMAGESIMAGE_NAME_CANNOT_BE_NULL);
        }
        return new URL(this.baseUrl, name);
    }
}

