/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.ui.internal.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.war.ui.util.WebServletGroupItemProvider;
import org.eclipse.jst.j2ee.internal.wizard.AnnotationsStandaloneGroup;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupServletItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.WebAppProvider;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.jboss.tools.portlet.ui.Messages;
import org.jboss.tools.portlet.ui.MultiSelectFilteredFileSelectionDialog;
import org.jboss.tools.portlet.ui.PortletUIActivator;
import org.jboss.tools.portlet.ui.internal.wizard.xpl.NewJavaClassWizardPageEx;

public class NewPortletClassWizardPage
extends NewJavaClassWizardPageEx {
    protected AnnotationsStandaloneGroup annotationsGroup;
    protected Button existingClassButton;
    protected Label existingClassLabel;
    protected Text existingClassText;
    protected Button existingButton;

    public NewPortletClassWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle, String moduleType) {
        super(model, pageName, pageDesc, pageTitle, moduleType);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = super.createTopLevelComposite(parent);
        this.addSeperator(composite, 3);
        this.createUseExistingGroup(composite);
        this.model.setProperty("IAnnotationsDataModel.useAnnotations", (Object)false);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected boolean isProjectValid(IProject project) {
        boolean result;
        try {
            boolean bl = result = project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature");
            if ("External Plug-in Libraries".equals(project.getName()) || ".JETEmitters".equals(project.getName())) {
                result = false;
            }
        }
        catch (CoreException coreException) {
            result = false;
        }
        return result;
    }

    protected String getUseExistingCheckboxText() {
        return Messages.NewPortletClassWizardPage_Use_an_existing_Portlet_class;
    }

    protected String getUseExistingProperty() {
        return "NewServletClassDataModel.USE_EXISTING_CLASS";
    }

    protected IProject getExtendedSelectedProject(Object selection) {
        if (selection instanceof WebServletGroupItemProvider) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)((WebServletGroupItemProvider)selection).getParent();
            return ProjectUtilities.getProject((EObject)webApp);
        }
        if (selection instanceof WebAppProvider) {
            return ((WebAppProvider)selection).getProject();
        }
        if (selection instanceof GroupServletItemProvider) {
            WebApp webApp = (WebApp)((GroupServletItemProvider)selection).getJavaEEObject();
            return ProjectUtilities.getProject((Object)webApp);
        }
        return super.getExtendedSelectedProject(selection);
    }

    protected void handleClassButtonSelected() {
        this.getControl().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        IProject project = (IProject)this.model.getProperty("NewJavaClassDataModel.PROJECT");
        MultiSelectFilteredFileSelectionDialog ms = new MultiSelectFilteredFileSelectionDialog(this.getShell(), Messages.NewPortletClassWizardPage_New_Portlet, Messages.NewPortletClassWizardPage_Choose_a_portlet_class, new String[0], false, project);
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        Object root = null;
        root = component != null ? component.getRootFolder().getUnderlyingFolder() : project;
        ms.setInput(root);
        ms.open();
        if (ms.getReturnCode() == 0) {
            String qualifiedClassName = "";
            IType type = (IType)ms.getFirstResult();
            if (type != null) {
                qualifiedClassName = type.getFullyQualifiedName();
            }
            this.existingClassText.setText(qualifiedClassName);
        }
        this.getControl().setCursor(null);
    }

    private void createUseExistingGroup(Composite composite) {
        this.existingButton = new Button(composite, 32);
        this.existingButton.setText(this.getUseExistingCheckboxText());
        GridData data = new GridData(256);
        data.horizontalSpan = 3;
        this.existingButton.setLayoutData((Object)data);
        this.synchHelper.synchCheckbox(this.existingButton, this.getUseExistingProperty(), null);
        this.existingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPortletClassWizardPage.this.handleExistingButtonSelected();
            }
        });
        this.existingClassLabel = new Label(composite, 16384);
        this.existingClassLabel.setText(IWebWizardConstants.CLASS_NAME_LABEL);
        this.existingClassLabel.setLayoutData((Object)new GridData(32));
        this.existingClassLabel.setEnabled(false);
        this.existingClassText = new Text(composite, 2060);
        this.existingClassText.setLayoutData((Object)new GridData(768));
        this.existingClassText.setEnabled(false);
        this.synchHelper.synchText(this.existingClassText, "NewJavaClassDataModel.CLASS_NAME", null);
        this.existingClassButton = new Button(composite, 8);
        this.existingClassButton.setText(IWebWizardConstants.BROWSE_BUTTON_LABEL);
        this.existingClassButton.setLayoutData((Object)new GridData(256));
        this.existingClassButton.setEnabled(false);
        this.existingClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPortletClassWizardPage.this.handleClassButtonSelected();
            }
        });
    }

    private void handleExistingButtonSelected() {
        boolean enable = this.existingButton.getSelection();
        this.existingClassLabel.setEnabled(enable);
        this.existingClassButton.setEnabled(enable);
        this.packageText.setEnabled(!enable);
        this.packageButton.setEnabled(!enable);
        this.packageLabel.setEnabled(!enable);
        this.classText.setEnabled(!enable);
        this.classLabel.setEnabled(!enable);
        this.superText.setEnabled(!enable);
        this.superButton.setEnabled(!enable);
        this.superLabel.setEnabled(!enable);
    }

    protected void validatePage(boolean showMessage) {
        super.validatePage(showMessage);
        if (showMessage && this.getMessage() == null && this.getErrorMessage() == null) {
            IProject project = this.getTargetProject();
            boolean isFacetedProject = false;
            try {
                isFacetedProject = FacetedProjectFramework.isFacetedProject((IProject)project);
            }
            catch (CoreException coreException) {}
            if (!isFacetedProject) {
                this.setMessage(Messages.NewPortletClassWizardPage_Updating_web_xml_portlet_xml_is_not_possible_on_non_portlet_web_projects, 2);
            } else if (PortletUIActivator.getPortletXmlFile(project) == null) {
                this.setMessage(Messages.NewPortletClassWizardPage_The_portlet_xml_file_doesn_t_exist, 2);
            }
        }
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }
}

