/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.common.core.job;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class JobChainBuilder {
    private Job job;

    public JobChainBuilder(Job job) {
        this.job = job;
    }

    public JobConstraint runWhenSuccessfullyDone(Job constrainedJob) {
        return new JobConstraint(this.job).runWhenSuccessfullyDone(constrainedJob);
    }

    public JobConstraint runWhenDone(Job constrainedJob) {
        return new JobConstraint(this.job).runWhenDone(constrainedJob);
    }

    public class JobConstraint {
        private Job job;

        private JobConstraint(Job job) {
            this.job = job;
        }

        public JobConstraint runWhenDone(final Job constrainedJob) {
            this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    constrainedJob.schedule();
                }
            });
            return new JobConstraint(constrainedJob);
        }

        public JobConstraint runWhenSuccessfullyDone(final Job constrainedJob) {
            this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        constrainedJob.schedule();
                    }
                }
            });
            return new JobConstraint(constrainedJob);
        }

        public void schedule() {
            JobChainBuilder.this.job.schedule();
        }

        public Job build() {
            return JobChainBuilder.this.job;
        }
    }
}

