/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.common.core.connection;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.OpenShiftCoreException;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;

public class ConnectionUtils {
    private ConnectionUtils() {
    }

    public static Connection getConnectionByUrl(ConnectionURL connectionUrl, Map<ConnectionURL, Connection> connectionsByUrl) {
        if (connectionUrl == null) {
            return null;
        }
        return connectionsByUrl.get(connectionUrl);
    }

    public static Connection getConnectionByUsername(String username, Map<ConnectionURL, Connection> connectionsByUrl) {
        try {
            return ConnectionUtils.getConnectionByUrl(ConnectionURL.forUsername(username), connectionsByUrl);
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenShiftCoreException(NLS.bind((String)"Could not get url for connection {0}", (Object)username), new Object[]{e});
        }
        catch (MalformedURLException e) {
            throw new OpenShiftCoreException(NLS.bind((String)"Could not get url for connection {0}", (Object)username), new Object[]{e});
        }
    }
}

