/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.ui.internal.command;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.livereload.core.internal.util.WSTUtils;
import org.jboss.tools.livereload.ui.internal.command.OpenInWebBrowserViaLiveReloadUtils;
import org.jboss.tools.livereload.ui.internal.util.Logger;
import org.jboss.tools.livereload.ui.internal.util.Pair;

public class OpenInWebBrowserWithLiveReloadLauncher
implements IEditorLauncher {
    public void open(final IPath file) {
        try {
            Pair<IServer, Boolean> result = OpenInWebBrowserViaLiveReloadUtils.getLiveReloadServer(true, false);
            if (result != null) {
                final IServer liveReloadServer = (IServer)result.left;
                boolean needsStartOrRestart = (Boolean)result.right;
                if (needsStartOrRestart) {
                    Job startOrRestartJob = WSTUtils.startOrRestartServer((IServer)liveReloadServer, (int)30, (TimeUnit)TimeUnit.SECONDS);
                    startOrRestartJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            if (event.getResult().isOK()) {
                                OpenInWebBrowserViaLiveReloadUtils.openInWebBrowser(file, liveReloadServer);
                            }
                        }
                    });
                    startOrRestartJob.schedule();
                } else {
                    OpenInWebBrowserViaLiveReloadUtils.openInWebBrowser(file, liveReloadServer);
                }
            }
        }
        catch (Exception e) {
            Logger.error("Failed to Open in Web Browser via LiveReload", e);
        }
    }
}

