/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.ui.internal.command;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadProxyServer;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.NetworkUtils;
import org.jboss.tools.livereload.core.internal.util.WSTUtils;
import org.jboss.tools.livereload.ui.internal.command.DialogMessages;
import org.jboss.tools.livereload.ui.internal.command.OpenInWebBrowserViaLiveReloadUtils;
import org.jboss.tools.livereload.ui.internal.util.ImageRepository;

public class OpenInExternalDeviceWebBrowserViaQRCodeDialog
extends TitleAreaDialog {
    private static final Image TITLE_IMAGE = ImageRepository.getInstance().getImage("livereload_wiz.png");
    private final IServerModule serverModule;
    private Canvas qrcodeCanvas;
    private Table networkInterfacesTable;
    private Link locationLabel;
    private String serverModuleURL = null;
    private Image qrcodeImage = null;

    public OpenInExternalDeviceWebBrowserViaQRCodeDialog(IServerModule module, Shell parentShell) {
        super(parentShell);
        this.serverModule = module;
    }

    protected Point getInitialSize() {
        return new Point(400, 600);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        parent.getShell().setText(DialogMessages.QRCODE_DIALOG_NAME);
        this.setTitle(DialogMessages.QRCODE_DIALOG_TITLE);
        this.setTitleImage(TITLE_IMAGE);
        this.setMessage(DialogMessages.QRCODE_DIALOG_MESSAGE);
        OpenInExternalDeviceWebBrowserViaQRCodeDialog.setDialogHelpAvailable((boolean)false);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Label titleSeparator = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)titleSeparator);
        Composite dialogArea = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(300, 400).applyTo((Control)dialogArea);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(dialogArea);
        this.createNetworkInterfacesTable(dialogArea);
        this.createModuleLocation(dialogArea);
        Label buttonsSeparator = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)buttonsSeparator);
        return dialogArea;
    }

    private String computeURL(TableItem[] tableItems) {
        if (tableItems.length > 0) {
            LiveReloadProxyServer liveReloadProxyServer;
            Map.Entry selectedNetworkInterface;
            block4: {
                selectedNetworkInterface = (Map.Entry)tableItems[0].getData();
                liveReloadProxyServer = WSTUtils.findLiveReloadProxyServer((IServer)this.serverModule.getServer());
                if (liveReloadProxyServer != null) break block4;
                return null;
            }
            try {
                int proxyPort = liveReloadProxyServer.getProxyPort();
                String host = ((InetAddress)selectedNetworkInterface.getValue()).getHostAddress();
                URL url = new URL("http", host, proxyPort, "/" + this.serverModule.getModule()[0].getName());
                return url.toExternalForm();
            }
            catch (MalformedURLException e) {
                Logger.error((String)"Failed to compute URL", (Throwable)e);
            }
        }
        return null;
    }

    private void createNetworkInterfacesTable(Composite parent) {
        this.networkInterfacesTable = new Table(parent, 2816);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(200, 100).applyTo((Control)this.networkInterfacesTable);
        this.networkInterfacesTable.setHeaderVisible(true);
        TableViewer networkInterfaceViewer = new TableViewer(this.networkInterfacesTable);
        TableColumn networkInterfaceNameColumn = new TableColumn(this.networkInterfacesTable, 16384);
        this.networkInterfacesTable.setLinesVisible(true);
        this.networkInterfacesTable.setLinesVisible(true);
        networkInterfaceNameColumn.setAlignment(16384);
        networkInterfaceNameColumn.setText("Interface Name");
        networkInterfaceNameColumn.setWidth(100);
        TableColumn networkInterfaceAddressColumn = new TableColumn(this.networkInterfacesTable, 131072);
        networkInterfaceAddressColumn.setAlignment(16384);
        networkInterfaceAddressColumn.setText("IP Addresses");
        networkInterfaceAddressColumn.setWidth(100);
        networkInterfaceViewer.setContentProvider((IContentProvider)new NetworkInterfacesContentProvider());
        networkInterfaceViewer.setLabelProvider((IBaseLabelProvider)new NetworkInterfacesLabelProvider());
        networkInterfaceViewer.setInput(this.retrieveNetworkInterfaces());
        networkInterfaceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.serverModuleURL = OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.computeURL(OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.networkInterfacesTable.getSelection());
                if (OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.qrcodeCanvas != null) {
                    OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.qrcodeImage = null;
                    OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.qrcodeCanvas.redraw();
                }
                if (OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.locationLabel != null) {
                    OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.locationLabel.setText(OpenInExternalDeviceWebBrowserViaQRCodeDialog.toHtmlAnchor(OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.serverModuleURL));
                }
            }
        });
        if (this.networkInterfacesTable.getItemCount() > 0) {
            this.networkInterfacesTable.setSelection(0);
            this.serverModuleURL = this.computeURL(this.networkInterfacesTable.getSelection());
        }
    }

    private void createModuleLocation(Composite parent) {
        final Display display = Display.getCurrent();
        final Color whiteColor = display.getSystemColor(1);
        final Color blackColor = display.getSystemColor(2);
        Composite locationContainer = new Composite(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(300, 300).applyTo((Control)locationContainer);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(locationContainer);
        GridLayout layout = new GridLayout();
        locationContainer.setLayout((Layout)layout);
        locationContainer.setBackground(Display.getCurrent().getSystemColor(1));
        this.qrcodeCanvas = new Canvas(locationContainer, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.qrcodeCanvas);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo((Composite)this.qrcodeCanvas);
        this.qrcodeCanvas.setBackground(Display.getCurrent().getSystemColor(1));
        this.qrcodeCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                try {
                    event.gc.setBackground(whiteColor);
                    event.gc.setForeground(blackColor);
                    event.gc.fillRectangle(0, 0, ((OpenInExternalDeviceWebBrowserViaQRCodeDialog)OpenInExternalDeviceWebBrowserViaQRCodeDialog.this).qrcodeCanvas.getSize().x, ((OpenInExternalDeviceWebBrowserViaQRCodeDialog)OpenInExternalDeviceWebBrowserViaQRCodeDialog.this).qrcodeCanvas.getSize().y);
                    int qrcodeWidth = ((OpenInExternalDeviceWebBrowserViaQRCodeDialog)OpenInExternalDeviceWebBrowserViaQRCodeDialog.this).qrcodeCanvas.getSize().x;
                    int qrcodeHeight = ((OpenInExternalDeviceWebBrowserViaQRCodeDialog)OpenInExternalDeviceWebBrowserViaQRCodeDialog.this).qrcodeCanvas.getSize().y;
                    int horizontalOffset = qrcodeWidth > qrcodeHeight ? (qrcodeWidth - qrcodeHeight) / 2 : 0;
                    int verticalOffset = qrcodeHeight > qrcodeWidth ? (qrcodeHeight - qrcodeWidth) / 2 : 0;
                    int qrcodeSize = Math.min(qrcodeWidth, qrcodeHeight);
                    if (OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.serverModuleURL != null && (OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.qrcodeImage == null || qrcodeSize != ((OpenInExternalDeviceWebBrowserViaQRCodeDialog)OpenInExternalDeviceWebBrowserViaQRCodeDialog.this).qrcodeImage.getBounds().height)) {
                        Hashtable<EncodeHintType, ErrorCorrectionLevel> hintMap = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
                        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
                        QRCodeWriter qrCodeWriter = new QRCodeWriter();
                        BitMatrix qrcodeMatrix = qrCodeWriter.encode(OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.serverModuleURL, BarcodeFormat.QR_CODE, qrcodeSize, qrcodeSize, hintMap);
                        PaletteData palette = new PaletteData(255, 255, 255);
                        ImageData imageData = new ImageData(qrcodeSize, qrcodeSize, 8, palette);
                        int i = 0;
                        while (i < qrcodeSize) {
                            int j = 0;
                            while (j < qrcodeSize) {
                                if (qrcodeMatrix.get(i, j)) {
                                    imageData.setPixel(i, j, 0);
                                } else {
                                    imageData.setPixel(i, j, 255);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.qrcodeImage = new Image((Device)display, imageData);
                    }
                    if (OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.qrcodeImage != null) {
                        event.gc.drawImage(OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.qrcodeImage, horizontalOffset, verticalOffset);
                    }
                }
                catch (Exception e) {
                    Logger.error((String)"Failed to generate QRCode", (Throwable)e);
                }
            }
        });
        this.locationLabel = new Link(locationContainer, 0);
        this.locationLabel.setBackground(whiteColor);
        if (this.serverModuleURL != null) {
            this.locationLabel.setText(OpenInExternalDeviceWebBrowserViaQRCodeDialog.toHtmlAnchor(this.serverModuleURL));
        }
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)this.locationLabel);
        this.locationLabel.addListener(13, (Listener)new LinkListener());
        this.createContextMenu((Control)this.locationLabel, this.serverModuleURL);
    }

    private static String toHtmlAnchor(String location) {
        if (location != null) {
            return "<a href=\"" + location + "\">" + location + "</a>";
        }
        return null;
    }

    private void createContextMenu(Control control, String serverModuleURL) {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new GroupMarker("additions"));
        Menu contextMenu = menuManager.createContextMenu(control);
        control.setMenu(contextMenu);
        menuManager.add((IAction)new CopyToClipboardAction());
    }

    private Map<String, InetAddress> retrieveNetworkInterfaces() {
        try {
            return NetworkUtils.retrieveNetworkInterfaces();
        }
        catch (SocketException e) {
            Logger.error((String)"Failed to retrieve local network interfaces", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    public class CopyToClipboardAction
    extends Action {
        public CopyToClipboardAction() {
            super("Copy", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        }

        public void run() {
            Clipboard clipboard = new Clipboard(Display.getDefault());
            clipboard.setContents(new Object[]{OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.serverModuleURL}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public class LinkListener
    implements Listener {
        public void handleEvent(Event event) {
            try {
                OpenInWebBrowserViaLiveReloadUtils.openInWebBrowser(new URL(OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.serverModuleURL));
            }
            catch (Exception e) {
                Logger.error((String)("Failed to open URL '" + OpenInExternalDeviceWebBrowserViaQRCodeDialog.this.serverModuleURL + "' in an external Browser"), (Throwable)e);
            }
        }
    }

    static class NetworkInterfacesContentProvider
    implements IStructuredContentProvider {
        private Map<String, InetAddress> networkInterfaces;

        NetworkInterfacesContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.networkInterfaces = (Map)newInput;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Map.Entry<String, InetAddress>> entries = new ArrayList<Map.Entry<String, InetAddress>>(this.networkInterfaces.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<String, InetAddress>>(){

                @Override
                public int compare(Map.Entry<String, InetAddress> entry, Map.Entry<String, InetAddress> otherEntry) {
                    return entry.getKey().compareTo(otherEntry.getKey());
                }
            });
            return entries.toArray();
        }

        public void dispose() {
        }
    }

    static class NetworkInterfacesLabelProvider
    implements ITableLabelProvider {
        NetworkInterfacesLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                switch (columnIndex) {
                    case 0: {
                        return ((String)entry.getKey()).toString();
                    }
                    case 1: {
                        return ((InetAddress)entry.getValue()).getHostAddress();
                    }
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

