/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.ui.internal.command;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;
import org.jboss.tools.livereload.core.internal.util.WSTUtils;
import org.jboss.tools.livereload.ui.internal.command.OpenInExternalDeviceWebBrowserViaQRCodeDialog;
import org.jboss.tools.livereload.ui.internal.command.OpenInWebBrowserViaLiveReloadUtils;
import org.jboss.tools.livereload.ui.internal.util.Logger;
import org.jboss.tools.livereload.ui.internal.util.Pair;

public class OpenInExternalDeviceWebBrowserViaQRCodeCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IServerModule appModule = OpenInWebBrowserViaLiveReloadUtils.retrieveServerModuleFromSelectedElement(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        try {
            Pair<IServer, Boolean> result = OpenInWebBrowserViaLiveReloadUtils.getLiveReloadServer(true, true);
            if (result != null) {
                IServer liveReloadServer = (IServer)result.left;
                boolean needsStartOrRestart = (Boolean)result.right;
                if (needsStartOrRestart) {
                    Job startOrRestartJob = WSTUtils.startOrRestartServer((IServer)liveReloadServer, (int)30, (TimeUnit)TimeUnit.SECONDS);
                    startOrRestartJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            if (event.getResult().isOK()) {
                                OpenInExternalDeviceWebBrowserViaQRCodeCommandHandler.this.openQRCodeDialog(appModule);
                            }
                        }
                    });
                    startOrRestartJob.schedule();
                } else {
                    this.openQRCodeDialog(appModule);
                }
            }
        }
        catch (Exception e) {
            Logger.error("Failed to Open in Web Browser via LiveReload", e);
        }
        return null;
    }

    private void openQRCodeDialog(final IServerModule appModule) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                new OpenInExternalDeviceWebBrowserViaQRCodeDialog(appModule, Display.getDefault().getActiveShell()).open();
            }
        });
    }
}

