/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.core.resources;

import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VManager;
import org.jboss.tools.common.verification.vrules.VModel;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VTask;
import org.jboss.tools.common.verification.vrules.core.resources.VTaskListenerImpl;
import org.jboss.tools.common.verification.vrules.layer.VModelFactory;

public class GlobalBuilderImpl {
    protected XModel model;

    private VManager getRulesManager() {
        return VHelper.getManager();
    }

    public void setModel(XModel model) {
        this.model = model;
    }

    public void execute(XModelObject object) {
        if (object == null) {
            object = FileSystemsHelper.getWebInf((XModel)this.model);
        }
        if (object == null) {
            return;
        }
        VModel vmodel = VModelFactory.getModel(object.getModel());
        VObject vobject = vmodel.getObjectByPath(object.getPath());
        if (this.getRulesManager() == null) {
            return;
        }
        VRule[] rules = VHelper.getRules(this.getRulesManager(), vobject);
        if (rules == null) {
            return;
        }
        VTask task = this.getRulesManager().createTask(vobject);
        VTaskListenerImpl listener = new VTaskListenerImpl();
        listener.setModel(this.model);
        listener.setTask(task);
        listener.setSignificance(this.getRulesManager().getMinSignificance());
        task.addTaskListener(listener);
        task.run();
        task.removeTaskListener(listener);
    }
}

