/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jboss.tools.common.verification.vrules.VMessageFormat;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VResult;

public class VResultTemplate {
    private String id;
    private String name;
    private String description;
    private String type;
    private int significance;
    private VMessageFormat format;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String old = this.id;
        this.id = id;
        this.propertyChangeSupport.firePropertyChange("id", old, id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", old, name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String old = this.description;
        this.description = description;
        this.propertyChangeSupport.firePropertyChange("description", old, description);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        String old = this.type;
        this.type = type;
        this.propertyChangeSupport.firePropertyChange("type", old, type);
    }

    public int getSignificance() {
        return this.significance;
    }

    public void setSignificance(int significance) {
        int old = this.significance;
        this.significance = significance > 10 ? 10 : (significance < 0 ? 0 : significance);
        this.propertyChangeSupport.firePropertyChange("significance", old, significance);
    }

    public VMessageFormat getFormat() {
        return this.format;
    }

    public void setFormat(VMessageFormat format) {
        VMessageFormat old = this.format;
        this.format = format;
        this.propertyChangeSupport.firePropertyChange("format", old, format);
    }

    public VResult getResult(VObject sourceObject, Object sourcePosition, VObject targetObject, Object targetPosition, Object[] params) {
        VResult result = new VResult();
        result.setSignificance(this.significance);
        result.setSourceObject(sourceObject);
        result.setSourcePosition(sourcePosition);
        result.setTargetObject(targetObject);
        result.setTargetPosition(targetPosition);
        result.setType(this.type);
        if (this.format != null) {
            String message = this.format.format(params);
            VMessageFormat parent = this.format.getParent();
            if (parent != null) {
                Object[] params2 = new Object[]{sourceObject, sourcePosition, targetObject, targetPosition, message, this.type, this.significance};
                message = parent.format(params2);
            }
            result.setMessage(message);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof VResultTemplate) {
            return this.id.equals(((VResultTemplate)o).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

