/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.fixes;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.RuntimeClasspathProviderWrapper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.tools.project.examples.fixes.AbstractRuntimeFix;
import org.jboss.tools.project.examples.internal.Messages;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.internal.fixes.PortletRuntimeComponentProvider;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.RequirementModel;

public class WTPRuntimeFix
extends AbstractRuntimeFix {
    public static final String WTP_RUNTIME = "wtpruntime";
    private static final String TEIID_DEPLOYER = "teiid.deployer";
    private static final String RIFTSAW_SAR = "riftsaw.sar";
    private static final String BPEL = "bpel";
    private static final String TEIID = "teiid";
    private static final String JBOSSESB_SAR = "jbossesb.sar";
    private static final String JBOSSESB_ESB = "jbossesb.esb";
    private static final String ESB = "esb";
    private static final String PORTLET = "portlet";
    private static final String REQUIRED_COMPONENTS = "required-components";
    private static final IPath ESB_SERVER_SUPPLIED_CONTAINER_PATH = new Path("org.jboss.esb.runtime.classpath/server.supplied");

    WTPRuntimeFix(ProjectExample project, RequirementModel requirement) {
        super(project, requirement);
    }

    public boolean canFix() {
        return this.getBestRuntime(this.project, this.requirement) != null;
    }

    @Override
    public boolean fix(IProgressMonitor monitor) {
        if (!this.canFix()) {
            return false;
        }
        IProject[] eclipseProjects = ProjectExamplesActivator.getEclipseProject(this.project, this.requirement);
        if (eclipseProjects.length == 0) {
            return false;
        }
        boolean ret = true;
        int i = 0;
        while (i < eclipseProjects.length) {
            if (monitor.isCanceled()) {
                return false;
            }
            IProject eclipseProject = eclipseProjects[i];
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)eclipseProject);
                if (facetedProject == null) {
                    this.fixNonFacetedEsbProject(this.project, this.requirement, eclipseProject);
                } else {
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime wtpRuntime = facetedProject.getPrimaryRuntime();
                    if (wtpRuntime != null) {
                        IRuntime runtime = WTPRuntimeFix.getRuntime(wtpRuntime);
                        if (runtime == null && (runtime = this.getBestRuntime(this.project, this.requirement)) != null) {
                            facetedProject.removeTargetedRuntime(wtpRuntime, monitor);
                            wtpRuntime = RuntimeManager.getRuntime((String)runtime.getId());
                            facetedProject.addTargetedRuntime(wtpRuntime, monitor);
                            facetedProject.setPrimaryRuntime(wtpRuntime, monitor);
                            this.fixEsb(eclipseProject, this.requirement, runtime);
                        }
                    } else {
                        this.fixNonFacetedEsbProject(this.project, this.requirement, eclipseProject);
                    }
                }
            }
            catch (CoreException e) {
                ProjectExamplesActivator.log(e);
                ret = false;
            }
            ++i;
        }
        return ret;
    }

    private void fixNonFacetedEsbProject(ProjectExample project, RequirementModel fix, IProject eclipseProject) throws JavaModelException {
        IRuntime runtime = this.getBestRuntime(project, fix);
        if (runtime != null) {
            this.fixEsb(eclipseProject, fix, runtime);
        }
    }

    private void fixEsb(IProject eclipseProject, RequirementModel fix, IRuntime runtime) throws JavaModelException {
        IJavaProject javaProject;
        Collection<String> components = this.splitProperty(REQUIRED_COMPONENTS);
        if (components.isEmpty()) {
            return;
        }
        boolean esbRequired = false;
        for (String component : components) {
            if (!ESB.equals(component)) continue;
            esbRequired = true;
            break;
        }
        if (esbRequired && (javaProject = JavaCore.create((IProject)eclipseProject)) != null) {
            if (!javaProject.isOpen()) {
                javaProject.open(null);
            }
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length];
            boolean changed = false;
            IRuntimeType rt = runtime.getRuntimeType();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 5) {
                    IPath path = entry.getPath();
                    if (rt != null && new Path("org.eclipse.jst.server.core.container").isPrefixOf(path)) {
                        RuntimeClasspathProviderWrapper rcpw = JavaServerPlugin.findRuntimeClasspathProvider((IRuntimeType)rt);
                        IPath serverContainerPath = new Path("org.eclipse.jst.server.core.container").append(rcpw.getId()).append(runtime.getId());
                        newEntries[i] = JavaCore.newContainerEntry((IPath)serverContainerPath);
                        changed = true;
                    } else if (ESB_SERVER_SUPPLIED_CONTAINER_PATH.isPrefixOf(path)) {
                        IPath esbContainerPath = ESB_SERVER_SUPPLIED_CONTAINER_PATH.append(runtime.getId());
                        newEntries[i] = JavaCore.newContainerEntry((IPath)esbContainerPath);
                        changed = true;
                    } else {
                        newEntries[i] = entry;
                    }
                } else {
                    newEntries[i] = entry;
                }
                ++i;
            }
            if (changed) {
                javaProject.setRawClasspath(newEntries, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private IRuntime getBestRuntime(ProjectExample project, RequirementModel fix) {
        String allowedTypes = fix.getProperties().get("allowed-types");
        if (allowedTypes == null) {
            ProjectExamplesActivator.log(NLS.bind((String)Messages.WTPRuntimeFix_Invalid_WTP_runtime_fix, (Object)project.getName()));
            return null;
        }
        IRuntime[] runtimes = "any".equals(allowedTypes) ? ServerCore.getRuntimes() : WTPRuntimeFix.getRuntimesFromPattern(allowedTypes);
        IRuntime[] iRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime componentPresent;
            IRuntime runtime = iRuntimeArray[n2];
            IServer server = this.getServer(runtime);
            if (server != null && (componentPresent = this.isComponentPresent(fix, runtime)) != null) {
                return this.isComponentPresent(fix, runtime);
            }
            ++n2;
        }
        return null;
    }

    private IServer getServer(IRuntime runtime) {
        IServer[] servers;
        if (runtime == null) {
            return null;
        }
        IRuntimeType runtimeType = runtime.getRuntimeType();
        if (runtimeType == null || runtimeType.getId() == null) {
            return null;
        }
        IServer[] iServerArray = servers = ServerCore.getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeType serverRuntimeType;
            IServer server = iServerArray[n2];
            IServerType serverType = server.getServerType();
            if (serverType != null && (serverRuntimeType = serverType.getRuntimeType()) != null && runtimeType.getId().equals(serverRuntimeType.getId())) {
                return server;
            }
            ++n2;
        }
        return null;
    }

    private IRuntime isComponentPresent(RequirementModel fix, IRuntime runtime) {
        Collection<String> components = this.splitProperty(REQUIRED_COMPONENTS);
        if (components.isEmpty()) {
            return runtime;
        }
        File location = null;
        if (runtime == null || runtime.getLocation() == null) {
            return null;
        }
        location = runtime.getLocation().toFile();
        Iterator<String> iterator = components.iterator();
        if (iterator.hasNext()) {
            String component = iterator.next();
            if (PORTLET.equals(component) ? !PortletRuntimeComponentProvider.isPortalPresent(location, runtime, "isPortletRuntime") : (ESB.equals(component) ? !WTPRuntimeFix.isEsbPresent(location, runtime) : (BPEL.equals(component) ? !this.isBpelPresent(location, runtime) : TEIID.equals(component) && !WTPRuntimeFix.isTeiidPresent(location, runtime)))) {
                return null;
            }
            return runtime;
        }
        return null;
    }

    private boolean isBpelPresent(File location, IRuntime runtime) {
        IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossRuntime != null) {
            IPath jbossLocation = runtime.getLocation();
            IPath configPath = jbossLocation.append("server").append(jbossRuntime.getJBossConfiguration());
            File configFile = configPath.toFile();
            return WTPRuntimeFix.exists(configFile, RIFTSAW_SAR);
        }
        return false;
    }

    public static boolean isEsbPresent(File location, IRuntime runtime) {
        IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossRuntime != null) {
            IPath jbossLocation = runtime.getLocation();
            IPath configPath = jbossLocation.append("server").append(jbossRuntime.getJBossConfiguration());
            File configFile = configPath.toFile();
            return WTPRuntimeFix.exists(configFile, JBOSSESB_ESB) && WTPRuntimeFix.exists(configFile, JBOSSESB_SAR);
        }
        return false;
    }

    public static boolean isTeiidPresent(File location, IRuntime runtime) {
        IJBossServerRuntime jbossRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbossRuntime != null) {
            IPath jbossLocation = runtime.getLocation();
            IPath configPath = jbossLocation.append("server").append(jbossRuntime.getJBossConfiguration());
            IPath deployersPath = configPath.append("deployers");
            File deployersFile = deployersPath.toFile();
            File teiidFile = new File(deployersFile, TEIID_DEPLOYER);
            return teiidFile.exists();
        }
        return false;
    }

    private static boolean exists(File location, String esbDir) {
        File deployFile;
        if (Platform.getOS().equals("win32")) {
            esbDir = esbDir.replace("/", "\\");
        }
        if (!(deployFile = new File(location, "deploy")).exists() && !deployFile.isDirectory()) {
            return false;
        }
        File file = new File(deployFile, esbDir);
        return file.exists();
    }

    private static IRuntime getRuntime(org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) {
        IRuntime[] runtimes;
        if (runtime == null) {
            throw new IllegalArgumentException();
        }
        String id = runtime.getProperty("id");
        if (id == null) {
            return null;
        }
        IRuntime[] iRuntimeArray = runtimes = ServerCore.getRuntimes();
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime r = iRuntimeArray[n2];
            if (id.equals(r.getId())) {
                return r;
            }
            ++n2;
        }
        return null;
    }

    public static Set<IRuntimeType> getTargetedServerRuntimes(ProjectExample example) {
        IRuntime[] runtimes;
        HashSet<IRuntimeType> targetedRuntimes = new HashSet<IRuntimeType>();
        List<RequirementModel> fixes = example.getRequirements();
        if (fixes != null && !fixes.isEmpty() && (runtimes = ServerCore.getRuntimes()).length > 0) {
            for (RequirementModel fix : fixes) {
                String allowedTypes;
                if (!WTP_RUNTIME.equals(fix.getType()) || (allowedTypes = fix.getProperties().get("allowed-types")) == null) continue;
                if ("any".equals(allowedTypes)) {
                    targetedRuntimes.addAll(WTPRuntimeFix.toRuntimeTypes(runtimes));
                    continue;
                }
                targetedRuntimes.addAll(WTPRuntimeFix.toRuntimeTypes(WTPRuntimeFix.getRuntimesFromPattern(allowedTypes)));
            }
        }
        return targetedRuntimes;
    }

    static Collection<IRuntimeType> toRuntimeTypes(IRuntime[] runtimes) {
        if (runtimes == null || runtimes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IRuntimeType> runtimesTypes = new ArrayList<IRuntimeType>(runtimes.length);
        IRuntime[] iRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime r = iRuntimeArray[n2];
            IRuntimeType rt = r.getRuntimeType();
            if (rt != null) {
                runtimesTypes.add(rt);
            }
            ++n2;
        }
        return runtimesTypes;
    }

    @Override
    public boolean isSatisfied() {
        return this.getBestRuntime(this.project, this.requirement) != null;
    }

    @Override
    public String getLabel() {
        return "server/runtime";
    }
}

