/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal.fixes;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.discovery.core.internal.connectors.DiscoveryUtil;
import org.jboss.tools.discovery.core.internal.connectors.JBossDiscoveryUi;
import org.jboss.tools.project.examples.fixes.AbstractUIHandler;
import org.jboss.tools.project.examples.fixes.IProjectExamplesFix;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.internal.fixes.PluginFix;

public class PluginFixUIHandler
extends AbstractUIHandler {
    @Override
    public void handleDownloadRequest(Shell shell, IRunnableContext context, IProjectExamplesFix fix) {
        if (!fix.isSatisfied() && fix instanceof PluginFix) {
            PluginFix pluginFix = (PluginFix)fix;
            Collection<String> connectorIds = pluginFix.getConnectorIDs();
            try {
                this.discoverAndInstall(shell, context, connectorIds);
            }
            catch (InterruptedException | InvocationTargetException e) {
                ProjectExamplesActivator.log(e);
            }
        }
    }

    private void discoverAndInstall(Shell shell, IRunnableContext context, Collection<String> connectorIds) throws InvocationTargetException, InterruptedException {
        if (connectorIds == null || connectorIds.isEmpty()) {
            return;
        }
        final IStatus[] results = new IStatus[1];
        final ConnectorDiscovery[] connectorDiscoveries = new ConnectorDiscovery[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ConnectorDiscovery connectorDiscovery;
                connectorDiscoveries[0] = connectorDiscovery = DiscoveryUtil.createConnectorDiscovery();
                results[0] = connectorDiscoveries[0].performDiscovery(monitor);
                if (monitor.isCanceled()) {
                    results[0] = Status.CANCEL_STATUS;
                }
            }
        };
        context.run(true, true, runnable);
        if (results[0] == null) {
            return;
        }
        if (results[0].isOK()) {
            List connectors = connectorDiscoveries[0].getConnectors();
            ArrayList<DiscoveryConnector> installableConnectors = new ArrayList<DiscoveryConnector>();
            for (DiscoveryConnector connector : connectors) {
                if (!connectorIds.contains(connector.getId())) continue;
                installableConnectors.add(connector);
            }
            JBossDiscoveryUi.install(installableConnectors, (IRunnableContext)context);
        } else {
            String message = results[0].toString();
            switch (results[0].getSeverity()) {
                case 4: {
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)message);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)message);
                    break;
                }
                case 1: {
                    MessageDialog.openInformation((Shell)shell, (String)"Information", (String)message);
                }
            }
        }
    }

    @Override
    public void decorateInstallButton(Button button, IProjectExamplesFix fix, IProgressMonitor monitor) {
        if (button != null && !button.isDisposed()) {
            button.setEnabled(false);
            button.setToolTipText("");
        }
    }

    @Override
    public void decorateDownloadButton(Button button, IProjectExamplesFix fix, IProgressMonitor monitor) {
        if (button != null && !button.isDisposed()) {
            super.decorateInstallButton(button, fix, monitor);
            button.setToolTipText("Install required feature(s)");
        }
    }
}

