/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class UnArchiver {
    private File destinationFolder;
    private File zip;
    private Set<IPath> filters;

    public static UnArchiver create(File zip) {
        return UnArchiver.create(zip, null);
    }

    public static UnArchiver create(File zip, File destination) {
        Assert.isNotNull((Object)zip);
        UnArchiver unarchiver = new UnArchiver(zip);
        if (destination == null) {
            File parent = zip.getParentFile();
            if (parent == null) {
                throw new IllegalArgumentException("Can not infer a destination folder to extract " + zip);
            }
            String zipName = FilenameUtils.getBaseName((String)zip.getName());
            destination = new File(parent, zipName);
        }
        unarchiver.setDestination(destination);
        return unarchiver;
    }

    private void setDestination(File destination) {
        this.destinationFolder = destination;
    }

    private UnArchiver(File zip) {
        this.zip = zip;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean extract(IProgressMonitor monitor) throws IOException {
        this.destinationFolder.mkdirs();
        int filterCount = this.filters == null || this.filters.isEmpty() ? 0 : this.filters.size();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            Enumeration<? extends ZipEntry> entries;
            ZipFile zipFile = new ZipFile(this.zip);
            try {
                entries = zipFile.entries();
            }
            finally {
                if (entries.hasMoreElements()) {
                }
                return true;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private IPath findSegment(IPath filePath, IPath folder) {
        int i = 0;
        while (i < filePath.segmentCount() && i < 3) {
            if (filePath.segment(i).equals(folder.toString())) {
                if (i > 0) {
                    return filePath.removeFirstSegments(i);
                }
                return filePath;
            }
            ++i;
        }
        return null;
    }

    public void setFilters(Set<String> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        HashSet<IPath> paths = new HashSet<IPath>(filters.size());
        for (String folder : filters) {
            paths.add((IPath)new Path(folder));
        }
        this.filters = paths;
    }
}

