/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.project.examples.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.dmr.ModelNode;
import org.jboss.tools.project.examples.internal.IProjectExampleParser;
import org.jboss.tools.project.examples.internal.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;

public class ProjectExampleJsonParser
implements IProjectExampleParser {
    private static final String HITS_NODE = "hits";

    @Override
    public Collection<ProjectExample> parse(InputStream json, IProgressMonitor monitor) throws IOException {
        ModelNode hitsNode;
        ModelNode hitsWrapper;
        ModelNode results = ModelNode.fromJSONStream((InputStream)json);
        ArrayList<ProjectExample> examples = null;
        if (results.isDefined() && (hitsWrapper = results.get(HITS_NODE)).isDefined() && (hitsNode = hitsWrapper.get(HITS_NODE)).isDefined()) {
            List hits = hitsNode.asList();
            examples = new ArrayList<ProjectExample>(hits.size());
            for (ModelNode hit : hits) {
                if (monitor.isCanceled()) break;
                ProjectExample example = this.parse(hit);
                if (example == null) continue;
                examples.add(example);
            }
        }
        return examples == null ? Collections.emptyList() : Collections.unmodifiableList(examples);
    }

    private ProjectExample parse(ModelNode hit) {
        String id = hit.get("_id").asString();
        ModelNode fields = hit.get("fields");
        if (!(fields.isDefined() && fields.get("quickstart_id").isDefined() && fields.get("git_download").isDefined())) {
            return null;
        }
        String name = fields.get("quickstart_id").asString();
        try {
            String downloadUrl = fields.get("git_download").asString();
            String title = fields.get("sys_title").asString();
            String description = fields.get("sys_description").asString();
            ProjectExampleWorkingCopy example = new ProjectExampleWorkingCopy();
            example.setId(id);
            example.setImportType("maven");
            example.setName(name);
            example.setHeadLine(title);
            example.setDescription(description);
            example.setUrl(downloadUrl);
            LinkedHashSet<String> sys_tags = new LinkedHashSet<String>();
            String tag = "";
            if (fields.get("git_tag").isDefined()) {
                tag = fields.get("git_tag").asString();
                example.setVersion(tag);
            }
            if (fields.get("target_product").isDefined()) {
                StringBuilder productTag = new StringBuilder("product:");
                String targetProduct = fields.get("target_product").asString().toLowerCase();
                if (tag.toLowerCase().startsWith(targetProduct)) {
                    productTag.append(tag);
                } else {
                    productTag.append(targetProduct);
                    if (!tag.isEmpty()) {
                        productTag.append("-").append(tag);
                    }
                }
                sys_tags.add(productTag.toString());
            }
            sys_tags.addAll(this.asSet(fields.get("sys_tags")));
            example.setTags(sys_tags);
            HashSet<String> importFilter = new HashSet<String>();
            importFilter.add(name);
            Set<String> prerequisites = this.asSet(fields.get("prerequisites"));
            importFilter.addAll(prerequisites);
            example.setImportFilter(importFilter);
            return example;
        }
        catch (Exception O_o) {
            ProjectExamplesActivator.log("Error parsing " + name + " : " + O_o.getMessage());
            return null;
        }
    }

    private Set<String> asSet(ModelNode node) {
        if (!node.isDefined()) {
            return Collections.emptySet();
        }
        String asString = node.asString();
        Set<String> results = Collections.emptySet();
        if (asString.startsWith("[") && asString.endsWith("]")) {
            results = new HashSet<String>();
            for (ModelNode n : node.asList()) {
                String value = n.asString().toLowerCase();
                if (!this.isValid(value)) continue;
                results.add(value);
            }
        } else if (this.isValid(asString)) {
            results = Collections.singleton(asString);
        }
        return results;
    }

    private boolean isValid(String value) {
        return !"".equals(value) && !"none".equalsIgnoreCase(value);
    }
}

