/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class PlatformUiUtil {
    private static Boolean internalBrowserAvailable;

    public static String[] getFilterExtensions(String ... extensions) {
        int i = 0;
        while (i < extensions.length) {
            int j;
            String extension = extensions[i];
            if ("macosx".equals(Platform.getOS()) && (j = extension.lastIndexOf(46)) != -1) {
                extension = extension.substring(j);
            }
            extensions[i] = "*" + extension;
            ++i;
        }
        return extensions;
    }

    public static int getToolTipXShift() {
        if ("gtk".equals(SWT.getPlatform()) || "carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform())) {
            return -26;
        }
        return -23;
    }

    public static int getTreeImageOffset() {
        if ("carbon".equals(SWT.getPlatform())) {
            return 16;
        }
        if ("cocoa".equals(SWT.getPlatform())) {
            return 13;
        }
        return 20;
    }

    public static int getIncomingImageOffset() {
        if ("carbon".equals(SWT.getPlatform())) {
            return 5;
        }
        if ("cocoa".equals(SWT.getPlatform())) {
            return 2;
        }
        return 6;
    }

    public static int getTreeItemSquish() {
        if ("gtk".equals(SWT.getPlatform())) {
            return 8;
        }
        if (PlatformUiUtil.isMac()) {
            return 3;
        }
        return 0;
    }

    private static boolean isMac() {
        return "carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform());
    }

    @Deprecated
    public static boolean isPaintItemClippingRequired() {
        return "gtk".equals(SWT.getPlatform());
    }

    public static boolean spinnerHasNativeBorder() {
        return PlatformUiUtil.isMac() && !PlatformUiUtil.isEclipse36orLater();
    }

    private static boolean isEclipse36orLater() {
        return Eclipse36Checker.result;
    }

    public static boolean hasNarrowToolBar() {
        return "win32".equals(SWT.getPlatform());
    }

    public static int getToolbarSectionClientVerticalSpacing() {
        if ("win32".equals(SWT.getPlatform())) {
            return 5;
        }
        return 7;
    }

    public static int getViewMenuWidth() {
        return 32;
    }

    public static boolean supportsMultipleHyperlinkPresenter() {
        if (PlatformUiUtil.isMac()) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
            if (bundle != null) {
                String versionString = (String)bundle.getHeaders().get("Bundle-Version");
                Version version = new Version(versionString);
                return version.compareTo(new Version("3.7.0.v201101192000")) >= 0;
            }
            bundle = Platform.getBundle((String)"org.eclipse.swt");
            if (bundle != null) {
                String versionString = (String)bundle.getHeaders().get("Bundle-Version");
                Version version = new Version(versionString);
                return version.compareTo(new Version("3.7.0.v3721")) >= 0;
            }
            return false;
        }
        return true;
    }

    public static int getSwtTooltipStyle() {
        if ("gtk".equals(SWT.getPlatform())) {
            return 4096;
        }
        return 0;
    }

    public static boolean usesMouseWheelEventsForScrolling() {
        return "cocoa".equals(SWT.getPlatform());
    }

    public static boolean hasInternalBrowser() {
        block4: {
            if (internalBrowserAvailable == null) {
                try {
                    Shell[] shells = Display.getDefault().getShells();
                    if (shells.length > 0) {
                        Browser browser = new Browser((Composite)shells[0], 0);
                        browser.dispose();
                        internalBrowserAvailable = Boolean.TRUE;
                        break block4;
                    }
                    return false;
                }
                catch (SWTError sWTError) {
                    internalBrowserAvailable = Boolean.FALSE;
                }
            }
        }
        return internalBrowserAvailable;
    }

    private static class Eclipse36Checker {
        public static final boolean result;

        static {
            boolean methodAvailable = false;
            try {
                StyledText.class.getMethod("setTabStops", int[].class);
                methodAvailable = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            result = methodAvailable;
        }

        private Eclipse36Checker() {
        }
    }
}

