/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;

public class SeamProjectSelectionDialog
extends ListDialog
implements ISelectionChangedListener {
    Button check;
    boolean allowAllProjects = false;

    public SeamProjectSelectionDialog(Shell parent, final boolean allowAllProjects) {
        super(parent);
        this.allowAllProjects = allowAllProjects;
        this.setTitle(SeamCoreMessages.SEAM_PROJECT_SELECTION_DIALOG_SEAM_WEB_PROJECT);
        this.setMessage(SeamCoreMessages.SEAM_PROJECT_SELECTION_DIALOG_SELECT_SEAM_WEB_PROJECT);
        this.setLabelProvider((ILabelProvider)new WorkbenchLabelProvider());
        this.setInput(new Object());
        this.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<IProject> seamProjects = new ArrayList<IProject>();
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    try {
                        if (project.isAccessible() && (allowAllProjects || SeamProjectSelectionDialog.this.check != null && SeamProjectSelectionDialog.this.check.getSelection() || project.hasNature("org.jboss.tools.seam.core.seamnature") && SeamCorePlugin.getSeamPreferences((IProject)project) != null && project.getAdapter(IFacetedProject.class) != null && ((IFacetedProject)project.getAdapter(IFacetedProject.class)).hasProjectFacet(ProjectFacetsManager.getProjectFacet((String)"jst.web")) && !"".equals(SeamCorePlugin.getSeamPreferences((IProject)project).get("seam.project.deployment.type", "")))) {
                            seamProjects.add(project);
                        }
                    }
                    catch (CoreException e) {
                        SeamCorePlugin.getPluginLog().logError((Throwable)e);
                    }
                    ++n2;
                }
                return seamProjects.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    public SeamProjectSelectionDialog(Shell parent) {
        this(parent, false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOkButton().setEnabled(false);
        this.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.getOkButton().setEnabled(!event.getSelection().isEmpty());
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        if (!this.allowAllProjects) {
            this.check = new Button(parent, 32);
            this.check.setText(SeamCoreMessages.SEAM_PROJECT_SELECTION_DIALOG_SHOW_ALL_PROJECTS);
            this.check.setSelection(false);
            this.check.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    TableViewer v = SeamProjectSelectionDialog.this.getTableViewer();
                    v.refresh();
                }
            });
        }
        return parent;
    }
}

