/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.marker;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamProperty;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.SeamComponentDeclaration;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.marker.AddAnnotatedMethodMarkerResolution;
import org.jboss.tools.seam.ui.marker.AddAnnotationMarkerResolution;
import org.jboss.tools.seam.ui.marker.AddSetterMarkerResolution;
import org.jboss.tools.seam.ui.marker.ChangeScopeMarkerResolution;
import org.jboss.tools.seam.ui.marker.DeleteAnnotationMarkerResolution;
import org.jboss.tools.seam.ui.marker.RenameAnnotationMarkerResolution;

public class SeamProblemMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private static final String JAVA_EXTENSION = "java";
    private static final String XML_EXTENSION = "xml";

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            return this.findResolutions(marker);
        }
        catch (CoreException ex) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)ex);
            return new IMarkerResolution[0];
        }
    }

    private int getMessageID(IMarker marker) throws CoreException {
        Integer attribute = (Integer)marker.getAttribute("Message_id");
        if (attribute != null) {
            return attribute;
        }
        return -1;
    }

    private IMarkerResolution[] findResolutions(IMarker marker) throws CoreException {
        ISeamProperty property;
        int messageId = this.getMessageID(marker);
        if (messageId == -1) {
            return new IMarkerResolution[0];
        }
        IFile file = (IFile)marker.getResource();
        Integer attribute = (Integer)marker.getAttribute("charStart");
        if (attribute == null) {
            return new IMarkerResolution[0];
        }
        int start = attribute;
        attribute = (Integer)marker.getAttribute("charEnd");
        if (attribute == null) {
            return new IMarkerResolution[0];
        }
        int end = attribute;
        if (JAVA_EXTENSION.equals(file.getFileExtension())) {
            if (messageId == 1) {
                return new IMarkerResolution[]{new RenameAnnotationMarkerResolution(SeamCoreMessages.RENAME_NAME_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Name", file, start, end), new DeleteAnnotationMarkerResolution(SeamCoreMessages.DELETE_NAME_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Name", file, start, end)};
            }
            if (messageId == 2) {
                return new IMarkerResolution[]{new DeleteAnnotationMarkerResolution(SeamCoreMessages.DELETE_REMOVE_ANNOTATION_MARKER_RESOLUTION_TITLE, "javax.ejb.Remove", file, start, end)};
            }
            if (messageId == 3) {
                return new IMarkerResolution[]{new DeleteAnnotationMarkerResolution(SeamCoreMessages.DELETE_DESTROY_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Destroy", file, start, end)};
            }
            if (messageId == 4) {
                return new IMarkerResolution[]{new DeleteAnnotationMarkerResolution(SeamCoreMessages.DELETE_CREATE_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Create", file, start, end)};
            }
            if (messageId == 5) {
                return new IMarkerResolution[]{new DeleteAnnotationMarkerResolution(SeamCoreMessages.DELETE_UNWRAP_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Unwrap", file, start, end)};
            }
            if (messageId == 6) {
                return new IMarkerResolution[]{new DeleteAnnotationMarkerResolution(SeamCoreMessages.DELETE_DESTROY_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Destroy", file, start, end)};
            }
            if (messageId == 7) {
                return new IMarkerResolution[]{new AddAnnotationMarkerResolution(SeamCoreMessages.ADD_NAME_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Name", file, start, end, true), new DeleteAnnotationMarkerResolution(SeamCoreMessages.DELETE_CREATE_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Create", file, start, end)};
            }
            if (messageId == 8) {
                return new IMarkerResolution[]{new AddAnnotationMarkerResolution(SeamCoreMessages.ADD_NAME_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Name", file, start, end, true), new DeleteAnnotationMarkerResolution(SeamCoreMessages.DELETE_UNWRAP_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Unwrap", file, start, end)};
            }
            if (messageId == 9) {
                return new IMarkerResolution[]{new AddAnnotationMarkerResolution(SeamCoreMessages.ADD_NAME_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Name", file, start, end, true), new DeleteAnnotationMarkerResolution(SeamCoreMessages.DELETE_OBSERVER_ANNOTATION_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Observer", file, start, end)};
            }
            if (messageId == 10) {
                return new IMarkerResolution[]{new AddAnnotatedMethodMarkerResolution(SeamCoreMessages.ADD_ANNOTATED_REMOVE_METHOD_MARKER_RESOLUTION_TITLE, "javax.ejb.Remove", file, start, end)};
            }
            if (messageId == 11) {
                return new IMarkerResolution[]{new AddAnnotatedMethodMarkerResolution(SeamCoreMessages.ADD_ANNOTATED_DESTROY_METHOD_MARKER_RESOLUTION_TITLE, "org.jboss.seam.annotations.Destroy", file, start, end)};
            }
            if (messageId == 12) {
                return new IMarkerResolution[]{new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.APPLICATION", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.BUSINESS_PROCESS", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.CONVERSATION", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.EVENT", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.METHOD", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.SESSION", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.UNSPECIFIED", file, start, end)};
            }
            if (messageId == 13) {
                return new IMarkerResolution[]{new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.APPLICATION", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.BUSINESS_PROCESS", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.CONVERSATION", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.EVENT", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.METHOD", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.PAGE", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.SESSION", file, start, end), new ChangeScopeMarkerResolution(SeamCoreMessages.CHANGE_SCOPETYPE_MARKER_RESOLUTION_TITLE, "ScopeType.UNSPECIFIED", file, start, end)};
            }
        } else if (XML_EXTENSION.equals(file.getFileExtension()) && messageId == 14 && (property = this.findSeamProperty(file, start, end)) != null && property.getParent() != null && property.getParent() instanceof SeamComponentDeclaration) {
            SeamComponentDeclaration xmlDeclaration = (SeamComponentDeclaration)property.getParent();
            if (xmlDeclaration == null) {
                return new IMarkerResolution[0];
            }
            for (ISeamComponent component : xmlDeclaration.getComponents()) {
                ISeamJavaComponentDeclaration javaDeclaration = component.getJavaDeclaration();
                if (javaDeclaration == null) continue;
                return new IMarkerResolution[]{new AddSetterMarkerResolution(property, javaDeclaration)};
            }
        }
        return new IMarkerResolution[0];
    }

    private ISeamProperty findSeamProperty(IFile file, int start, int end) {
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
        if (seamProject == null) {
            return null;
        }
        Set components = seamProject.getComponentsByPath(file.getFullPath());
        for (ISeamComponent component : components) {
            Set declarations = component.getXmlDeclarations();
            for (ISeamXmlComponentDeclaration declaration : declarations) {
                Collection properties = declaration.getProperties();
                for (ISeamProperty property : properties) {
                    ITextSourceReference location = property.getLocationFor("name");
                    if (location.getStartPosition() > start || location.getStartPosition() + location.getLength() < end) continue;
                    return property;
                }
            }
        }
        return null;
    }

    public boolean hasResolutions(IMarker marker) {
        if (marker.exists()) {
            try {
                return this.getMessageID(marker) >= 0;
            }
            catch (CoreException ex) {
                SeamGuiPlugin.getPluginLog().logError((Throwable)ex);
            }
        }
        return false;
    }
}

