/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.internal.reveng;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.reveng.ReverseEngineeringRuntimeInfo;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.util.StringHelper;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.internal.reveng.TablesColumnsCollector;

public class JDBCTablesColumnsReader {
    private static final Log log = LogFactory.getLog(JDBCTablesColumnsReader.class);
    private MetaDataDialect metadataDialect;
    private String currentCatalog;
    private final ConnectionProvider provider;
    private final SQLExceptionConverter sec;

    public JDBCTablesColumnsReader(MetaDataDialect dialect, ConnectionProvider provider, SQLExceptionConverter sec) {
        this.metadataDialect = dialect;
        this.provider = provider;
        this.sec = sec;
        this.currentCatalog = null;
    }

    private boolean safeEquals(Object value, Object tf) {
        if (value == tf) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return value.equals(tf);
    }

    private String quote(String columnName) {
        if (columnName == null) {
            return null;
        }
        if (!this.metadataDialect.needQuote(columnName)) {
            return columnName;
        }
        if (columnName.length() > 1 && columnName.charAt(0) == '`' && columnName.charAt(columnName.length() - 1) == '`') {
            return columnName;
        }
        return "`" + columnName + "`";
    }

    private void collectTables(TablesColumnsCollector tcc, String catalog, String schema) {
        Iterator tableIterator = null;
        try {
            String tablesMask = null;
            tableIterator = this.metadataDialect.getTables(StringHelper.replace((String)catalog, (String)".*", (String)"%"), StringHelper.replace((String)schema, (String)".*", (String)"%"), StringHelper.replace(tablesMask, (String)".*", (String)"%"));
            while (tableIterator.hasNext()) {
                Map tableRs = (Map)tableIterator.next();
                String catalogName = (String)tableRs.get("TABLE_CAT");
                String schemaName = (String)tableRs.get("TABLE_SCHEM");
                String tableName = (String)tableRs.get("TABLE_NAME");
                String tableType = (String)tableRs.get("TABLE_TYPE");
                if ("TABLE".equals(tableType) || "VIEW".equals(tableType)) {
                    log.debug((Object)("Adding table " + tableName + " of type " + tableType));
                    tcc.addTableName(catalogName, schemaName, this.quote(tableName));
                    continue;
                }
                log.debug((Object)("Ignoring table " + tableName + " of type " + tableType));
            }
        }
        catch (Throwable throwable) {
            if (tableIterator != null) {
                this.metadataDialect.close(tableIterator);
            }
            throw throwable;
        }
        if (tableIterator != null) {
            this.metadataDialect.close(tableIterator);
        }
    }

    public void readDatabaseTables(TablesColumnsCollector tcc, String catalog, String schema) {
        try {
            ReverseEngineeringRuntimeInfo info = ReverseEngineeringRuntimeInfo.createInstance((ConnectionProvider)this.provider, (SQLExceptionConverter)this.sec, null);
            this.metadataDialect.configure(info);
            tcc.init();
            this.initCurrentCatalog(info);
            this.collectTables(tcc, catalog, schema);
            tcc.adjust();
        }
        finally {
            this.metadataDialect.close();
        }
    }

    private void collectColumns(TablesColumnsCollector tcc, String catalog, String schema) {
        Iterator columnIterator = null;
        try {
            String tablesMask = null;
            String columnsMask = null;
            columnIterator = this.metadataDialect.getColumns(StringHelper.replace((String)catalog, (String)".*", (String)"%"), StringHelper.replace((String)schema, (String)".*", (String)"%"), StringHelper.replace(tablesMask, (String)".*", (String)"%"), StringHelper.replace(columnsMask, (String)".*", (String)"%"));
            while (columnIterator.hasNext()) {
                Map columnRs = (Map)columnIterator.next();
                String catalogName = (String)columnRs.get("TABLE_CAT");
                if (catalogName == null) {
                    catalogName = this.currentCatalog;
                }
                String schemaName = (String)columnRs.get("TABLE_SCHEM");
                String tableName = (String)columnRs.get("TABLE_NAME");
                String columnName = (String)columnRs.get("COLUMN_NAME");
                log.debug((Object)("Adding column " + tableName + "." + columnName));
                tcc.addColumnName(catalogName, schemaName, this.quote(tableName), columnName);
            }
        }
        catch (Throwable throwable) {
            if (columnIterator != null) {
                this.metadataDialect.close(columnIterator);
            }
            throw throwable;
        }
        if (columnIterator != null) {
            this.metadataDialect.close(columnIterator);
        }
    }

    public void readDatabaseColumns(TablesColumnsCollector tcc, String catalog, String schema) {
        try {
            ReverseEngineeringRuntimeInfo info = ReverseEngineeringRuntimeInfo.createInstance((ConnectionProvider)this.provider, (SQLExceptionConverter)this.sec, null);
            this.metadataDialect.configure(info);
            tcc.init();
            this.initCurrentCatalog(info);
            this.collectColumns(tcc, catalog, schema);
            tcc.adjust();
        }
        finally {
            this.metadataDialect.close();
        }
    }

    public void readDatabaseTablesColumns(TablesColumnsCollector tcc, String catalog, String schema) {
        try {
            ReverseEngineeringRuntimeInfo info = ReverseEngineeringRuntimeInfo.createInstance((ConnectionProvider)this.provider, (SQLExceptionConverter)this.sec, null);
            this.metadataDialect.configure(info);
            tcc.init();
            this.initCurrentCatalog(info);
            this.collectTables(tcc, catalog, schema);
            this.collectColumns(tcc, catalog, schema);
            tcc.adjust();
        }
        finally {
            this.metadataDialect.close();
        }
    }

    private void initCurrentCatalog(ReverseEngineeringRuntimeInfo info) {
        this.currentCatalog = null;
        try {
            this.currentCatalog = info.getConnectionProvider().getConnection().getCatalog();
        }
        catch (SQLException ignore) {
            SeamGuiPlugin.getPluginLog().logError((Throwable)ignore);
        }
    }
}

