/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterable;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphIterable<E>
implements Iterable<E> {
    private final Iterable<? extends E> roots;
    private final Transformer<? super E, ? extends Iterator<? extends E>> transformer;

    public GraphIterable(Iterable<? extends E> roots, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        if (roots == null || transformer == null) {
            throw new NullPointerException();
        }
        this.roots = roots;
        this.transformer = TransformerTools.toIterator(transformer);
    }

    @Override
    public Iterator<E> iterator() {
        return IteratorTools.graphIterator(this.roots.iterator(), this.transformer);
    }

    public String toString() {
        return ListTools.list(this).toString();
    }
}

