/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.comparator;

import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparatorChain<E>
implements Comparator<E> {
    private final Iterable<Comparator<? super E>> comparators;

    public ComparatorChain(Iterable<Comparator<? super E>> comparators) {
        if (IterableTools.isOrContainsNull(comparators)) {
            throw new NullPointerException();
        }
        if (IterableTools.isEmpty(comparators)) {
            throw new IllegalArgumentException("comparators must not empty");
        }
        this.comparators = comparators;
    }

    @Override
    public int compare(E o1, E o2) {
        int result = 0;
        Iterator<Comparator<E>> stream = this.comparators.iterator();
        while (stream.hasNext() && result == 0) {
            result = stream.next().compare(o1, o2);
        }
        return result;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.comparators);
    }
}

