/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.InterruptibleCommand;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class SafeInterruptibleCommandWrapper
implements InterruptibleCommand {
    private final InterruptibleCommand command;
    private final ExceptionHandler exceptionHandler;

    public SafeInterruptibleCommandWrapper(InterruptibleCommand command, ExceptionHandler exceptionHandler) {
        if (command == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.command = command;
        this.exceptionHandler = exceptionHandler;
    }

    public void execute() throws InterruptedException {
        try {
            this.command.execute();
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.command);
    }
}

