/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.StatefulCommandContext;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.LinkedQueue;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueueingCommandContext<E extends StatefulCommandContext>
implements StatefulCommandContext {
    protected final E commandContext;
    protected final SynchronizedBoolean active = new SynchronizedBoolean(false);
    private LinkedQueue<Command> queue = new LinkedQueue();

    protected AbstractQueueingCommandContext(E commandContext) {
        if (commandContext == null) {
            throw new NullPointerException();
        }
        this.commandContext = commandContext;
    }

    @Override
    public synchronized void start() {
        if (this.active.isTrue()) {
            throw new IllegalStateException("Not stopped.");
        }
        this.commandContext.start();
        while (!this.queue.isEmpty()) {
            this.commandContext.execute(this.queue.dequeue());
        }
        this.active.setTrue();
    }

    @Override
    public void execute(Command command) {
        if (this.commandIsToBeExecuted(command)) {
            this.commandContext.execute(command);
        }
    }

    private synchronized boolean commandIsToBeExecuted(Command command) {
        if (this.active.isFalse()) {
            this.queue.enqueue(command);
            return false;
        }
        return true;
    }

    @Override
    public synchronized void stop() throws InterruptedException {
        if (this.active.isFalse()) {
            throw new IllegalStateException("Not started.");
        }
        this.active.setFalse();
        this.commandContext.stop();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.queue);
    }
}

