/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.jdt.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.launching.SocketAttachConnector;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.jboss.tools.common.jdt.debug.VmModel;
import org.jboss.tools.common.jdt.debug.internal.RemoteDebugLaunchUtil;
import org.jboss.tools.common.jdt.debug.internal.SourceLookupUtil;
import org.jboss.tools.common.jdt.debug.internal.VmModelCache;
import org.jboss.tools.common.jdt.debug.sourcelookup.DebugLaunchConfigurationListener;
import org.jboss.tools.common.jdt.debug.tools.ToolsCore;
import org.jboss.tools.common.jdt.debug.tools.ToolsCoreException;
import org.jboss.tools.common.jdt.debug.tools.internal.Tools;
import org.jboss.tools.foundation.core.plugin.BaseCorePlugin;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RemoteDebugActivator
extends BaseCorePlugin
implements Preferences.IPropertyChangeListener {
    public static final String PLUGIN_ID = "org.jboss.tools.common.jdt.debug";
    public static final String UNKNOWN = "<Unknown>";
    public static final String LOCALHOST = "localhost";
    public static final String LAUNCH_CONFIGURATION_ID = "org.jboss.tools.common.jdt.debug.launching.JBossRemoteJavaApplication";
    public static final String REMOTE_JAVA_APPLICATION_ID = IJavaLaunchConfigurationConstants.ID_REMOTE_JAVA_APPLICATION;
    public static final String JBOSS_REMOTE_JAVA_APPLICATION = "JBossRemoteJavaApplication";
    public static final String JBOSS_SOURCE_PATH_COMPUTER_ID = "org.jboss.tools.common.jdt.debug.sourceLookup.remoteDebugSourcePathComputer";
    public static final String DT_SOCKET = "dt_socket";
    public static final String LAUNCH_CATEGORY = "org.eclipse.debug.ui.launchGroup.debug";
    public static final String ATTR_SELECTED_PROJECTS = "selectedProjects";
    public static final String MAVEN_SOURCEPATH_PROVIDER = "org.eclipse.m2e.launchconfig.sourcepathProvider";
    public static final String MAVEN_CLASSPATH_PROVIDER = "org.eclipse.m2e.launchconfig.classpathProvider";
    private static final String MAVEN_PLUGIN_ID = "org.eclipse.m2e.core";
    public static final String MAVEN_NATURE = "org.eclipse.m2e.core.maven2Nature";
    @Deprecated
    public static final String SET_AS_DEFAULT = "setAsDefault";
    @Deprecated
    public static final String JDT_JAVA_APPLICATION = "org.eclipse.jdt.launching.localJavaApplication";
    @Deprecated
    public static final String JDT_JUNIT_TEST = "org.eclipse.jdt.junit.launchconfig";
    @Deprecated
    public static final String DEFAULT_REMOTE_JBOSS_APP = "Remote myapp";
    @Deprecated
    public static final String JBOSS_TEMP_JAVA_APPLICATION = "jbossTempJavaApplication";
    private static RemoteDebugActivator plugin;
    private static BundleContext context;
    private DebugLaunchConfigurationListener listener;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
        JavaRuntime.getPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.listener = new DebugLaunchConfigurationListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this.listener);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        JavaRuntime.getPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this.listener);
    }

    public static RemoteDebugActivator getDefault() {
        return plugin;
    }

    private List<VmModel> getVmModels(String hostname, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<VmModel> models = new ArrayList<VmModel>();
        try {
            Set<Integer> vmPids = ToolsCore.getActiveVmPids(hostname);
            int i = 1;
            int size = vmPids.size();
            monitor.beginTask("Discovering Remote Aplications", vmPids.size() + 1);
            for (Integer vmPid : vmPids) {
                monitor.worked(1);
                monitor.setTaskName(String.valueOf(i++) + " out of " + size + ": Discovering port, main class and arguments for process id " + vmPid);
                VmModel model = this.getVmModel(hostname, vmPid, true, monitor);
                if (model == null) continue;
                models.add(model);
            }
        }
        catch (ToolsCoreException tce) {
            RemoteDebugActivator.pluginLog().logError((Throwable)((Object)tce));
        }
        return models;
    }

    public VmModel getCachedVmModel(String hostname, Integer vmPid) {
        return VmModelCache.getDefault().getModel(hostname, vmPid);
    }

    public VmModel getVmModel(String hostname, Integer vmPid, IProgressMonitor monitor) {
        VmModel model = this.getVmModelsUsingTools(hostname, vmPid, monitor);
        VmModelCache.getDefault().cacheModel(hostname, vmPid, model);
        return model;
    }

    public VmModel getVmModel(String hostname, Integer vmPid, boolean useCommand, IProgressMonitor monitor) {
        return this.getVmModel(hostname, vmPid, monitor);
    }

    private VmModel getVmModelsUsingTools(String hostname, Integer vmPid, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return null;
        }
        boolean running = false;
        try {
            running = ToolsCore.processIsRunning(hostname, vmPid);
        }
        catch (ToolsCoreException c) {
            RemoteDebugActivator.pluginLog().logWarning((Throwable)((Object)c));
        }
        if (running) {
            VmModel model = new VmModel();
            model.setPid(String.valueOf(vmPid));
            try {
                model.setJvmArgs(ToolsCore.getJvmArgs(hostname, vmPid));
                model.setMainClass(ToolsCore.getMainClass(hostname, vmPid));
                model.setMainArgs(ToolsCore.getMainArgs(hostname, vmPid));
            }
            catch (ToolsCoreException toolsCoreException) {}
            return model;
        }
        return null;
    }

    public VmModel getDebugModel(String hostname, int pid, boolean useCommand, IProgressMonitor monitor) {
        VmModel model = this.getVmModel(hostname, pid, useCommand, monitor);
        if (model != null && this.isDebugModel(model)) {
            return model;
        }
        return null;
    }

    public boolean isDebugModel(VmModel model) {
        return model.getPort() != null && DT_SOCKET.equals(model.getTransport());
    }

    public VmModel[] getDebugModels(String hostname, IProgressMonitor monitor) {
        ArrayList<VmModel> debugModels = new ArrayList<VmModel>();
        List<VmModel> models = this.getVmModels(hostname, monitor);
        if (models == null) {
            return null;
        }
        for (VmModel model : models) {
            if (!this.isDebugModel(model)) continue;
            debugModels.add(model);
        }
        return debugModels.toArray(new VmModel[0]);
    }

    public boolean isJdk() {
        return Tools.getInstance().isReady();
    }

    public static IVMConnector getDefaultVMConnector() {
        IVMConnector[] connectors;
        IVMConnector[] iVMConnectorArray = connectors = JavaRuntime.getVMConnectors();
        int n = connectors.length;
        int n2 = 0;
        while (n2 < n) {
            IVMConnector connector = iVMConnectorArray[n2];
            if (connector instanceof SocketAttachConnector) {
                return connector;
            }
            ++n2;
        }
        return null;
    }

    public VmModel[] getDebugModels(IProgressMonitor monitor) {
        return this.getDebugModels(LOCALHOST, monitor);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        String property = event.getProperty();
        if (JavaRuntime.PREF_VM_XML.equals(property)) {
            Tools.getInstance().reset();
        }
    }

    public static boolean m2eExists() {
        Bundle bundle = Platform.getBundle((String)MAVEN_PLUGIN_ID);
        return bundle != null;
    }

    public ILaunchConfiguration getDefaultLaunchConfiguration() {
        return RemoteDebugLaunchUtil.getDefaultLaunchConfiguration();
    }

    public ILaunchConfiguration[] getLaunchConfigurations() {
        return RemoteDebugLaunchUtil.getLaunchConfigurations();
    }

    public static boolean isRemoteDebuggerConnected(String host, int port) {
        return RemoteDebugActivator.getExistingRemoteDebugLaunch(host, port) != null;
    }

    public static ILaunch getExistingRemoteDebugLaunch(String host, int port) {
        return RemoteDebugLaunchUtil.getExistingRemoteDebugLaunch(host, port);
    }

    public static ILaunchConfiguration createTemporaryLaunchConfiguration(String projectName, String typeId) throws CoreException {
        return RemoteDebugLaunchUtil.createTemporaryLaunchConfiguration(projectName, typeId);
    }

    public static ILaunchConfigurationWorkingCopy createNewLaunchConfiguration(ILaunchConfigurationType type) throws CoreException {
        return RemoteDebugLaunchUtil.createNewLaunchConfiguration(type);
    }

    public static ILaunchConfigurationType getRemoteJavaApplicationConfigurationType() {
        return RemoteDebugLaunchUtil.getRemoteJavaApplicationConfigurationType();
    }

    public static ILaunchConfiguration createOrGetDefaultLaunchConfiguration(String port, String host, IJavaProject javaProject, IJavaElement[] selection) throws CoreException {
        return RemoteDebugLaunchUtil.createOrGetDefaultLaunchConfiguration(port, host, javaProject, selection);
    }

    public static void configureSourceLookup(ILaunchConfigurationWorkingCopy wc, IJavaElement[] selection, IJavaProject javaProject) throws CoreException {
        new SourceLookupUtil().addSelectedProjects(wc, selection, javaProject);
    }

    public static IPluginLog pluginLog() {
        return RemoteDebugActivator.getDefault().pluginLogInternal();
    }

    public static StatusFactory statusFactory() {
        return RemoteDebugActivator.getDefault().statusFactoryInternal();
    }
}

