/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import java.util.LinkedHashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.PackageFragmentRootTools;
import org.eclipse.jpt.common.core.internal.utility.PathTools;
import org.eclipse.jpt.common.core.resource.ResourceLocator;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJavaResourceLocator
implements ResourceLocator {
    protected static final IPath META_INF_PATH = new Path("META-INF");
    protected static final Transformer<IPackageFragmentRoot, IContainer> ROOT_CONTAINER_TRANSFORMER = new RootContainerTransformer();

    @Override
    public boolean locationIsValid(IProject project, IContainer container) {
        try {
            return this.locationIsValid_(project, container);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    protected boolean locationIsValid_(IProject project, IContainer container) throws JavaModelException {
        IJavaProject javaProject = this.getJavaProject(project);
        if (javaProject.isOnClasspath((IResource)container)) {
            return true;
        }
        LinkedHashSet<IPath> outputPaths = new LinkedHashSet<IPath>();
        outputPaths.add(javaProject.getOutputLocation());
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3 && entry.getOutputLocation() != null) {
                outputPaths.add(entry.getOutputLocation());
            }
            ++i;
        }
        IPath containerPath = container.getFullPath();
        for (IPath outputPath : outputPaths) {
            if (container.equals((Object)project) && outputPath.isPrefixOf(containerPath)) {
                return true;
            }
            if (!outputPath.isPrefixOf(containerPath)) continue;
            return false;
        }
        Object[] objectArray = javaProject.getNonJavaResources();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolder folder;
            Object resource = objectArray[n2];
            if (resource instanceof IFolder && (folder = (IFolder)resource).getFullPath().isPrefixOf(containerPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public IContainer getDefaultLocation(IProject project) {
        try {
            return this.getDefaultLocation_(project);
        }
        catch (Exception ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return null;
        }
    }

    protected IContainer getDefaultLocation_(IProject project) throws JavaModelException {
        IFolder defaultLocation = null;
        for (IContainer sourceFolder : this.getSourceFolders(project)) {
            IFolder metaInfFolder = sourceFolder.getFolder(META_INF_PATH);
            if (metaInfFolder.exists()) {
                return metaInfFolder;
            }
            if (defaultLocation != null) continue;
            defaultLocation = metaInfFolder;
        }
        IFolder metaInfFolder = project.getFolder(META_INF_PATH);
        if (metaInfFolder.exists()) {
            return metaInfFolder;
        }
        return defaultLocation;
    }

    @Override
    public IPath getWorkspacePath(IProject project, IPath runtimePath) {
        try {
            return this.getWorkspacePath_(project, runtimePath);
        }
        catch (Exception ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return null;
        }
    }

    protected IPath getWorkspacePath_(IProject project, IPath runtimePath) throws JavaModelException {
        IPath defaultResourcePath = null;
        for (IContainer sourceFolder : this.getSourceFolders(project)) {
            IPath resourcePath = sourceFolder.getFullPath().append(runtimePath);
            IFile file = project.getWorkspace().getRoot().getFile(resourcePath);
            if (file.exists()) {
                return file.getFullPath();
            }
            if (defaultResourcePath != null) continue;
            defaultResourcePath = resourcePath;
        }
        return defaultResourcePath;
    }

    @Override
    public IPath getRuntimePath(IProject project, IPath resourcePath) {
        try {
            return this.getRuntimePath_(project, resourcePath);
        }
        catch (Exception ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return resourcePath.makeRelativeTo(project.getFullPath());
        }
    }

    protected IPath getRuntimePath_(IProject project, IPath resourcePath) throws JavaModelException {
        IFile file = PathTools.getFile(resourcePath);
        for (IContainer sourceFolder : this.getSourceFolders(project)) {
            if (!sourceFolder.contains((ISchedulingRule)file)) continue;
            return resourcePath.makeRelativeTo(sourceFolder.getFullPath());
        }
        return resourcePath.makeRelativeTo(project.getFullPath());
    }

    protected Iterable<IContainer> getSourceFolders(IProject project) throws JavaModelException {
        return new TransformationIterable(this.getSourcePackageFragmentRoots(project), ROOT_CONTAINER_TRANSFORMER);
    }

    protected Iterable<IPackageFragmentRoot> getSourcePackageFragmentRoots(IProject project) throws JavaModelException {
        return IterableTools.filter(this.getPackageFragmentRoots(project), PackageFragmentRootTools.IS_FOLDER);
    }

    protected Iterable<IPackageFragmentRoot> getPackageFragmentRoots(IProject project) throws JavaModelException {
        return IterableTools.iterable((Object[])this.getPackageFragmentRootsArray(project));
    }

    protected IPackageFragmentRoot[] getPackageFragmentRootsArray(IProject project) throws JavaModelException {
        return this.getJavaProject(project).getPackageFragmentRoots();
    }

    protected IJavaProject getJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RootContainerTransformer
    extends TransformerAdapter<IPackageFragmentRoot, IContainer> {
        protected RootContainerTransformer() {
        }

        public IContainer transform(IPackageFragmentRoot pfr) {
            try {
                return this.transform_(pfr);
            }
            catch (JavaModelException ex) {
                throw new RuntimeException(ex);
            }
        }

        protected IContainer transform_(IPackageFragmentRoot pfr) throws JavaModelException {
            return (IContainer)pfr.getUnderlyingResource();
        }
    }
}

