/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.metamodel.domain;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.jboss.tools.ws.jaxrs.core.internal.utils.ConstantUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementCategory;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;

public class JaxrsElementDelta
implements Comparable<JaxrsElementDelta> {
    public static final int F_FINE_GRAINED = 1;
    public static final int F_ELEMENT_KIND = 2;
    public static final int F_SOURCE_TYPE = 4;
    public static final int F_PATH_ANNOTATION = 8;
    public static final int F_APPLICATION_PATH_ANNOTATION = 16;
    public static final int F_APPLICATION_CLASS_NAME = 32;
    public static final int F_APPLICATION_PATH_VALUE_OVERRIDE = 64;
    public static final int F_APPLICATION_HIERARCHY = 128;
    public static final int F_HTTP_METHOD_ANNOTATION = 256;
    public static final int F_PATH_PARAM_ANNOTATION = 512;
    public static final int F_QUERY_PARAM_ANNOTATION = 1024;
    public static final int F_MATRIX_PARAM_ANNOTATION = 2048;
    public static final int F_DEFAULT_VALUE_ANNOTATION = 4096;
    public static final int F_CONSUMES_ANNOTATION = 8192;
    public static final int F_PRODUCES_ANNOTATION = 16384;
    public static final int F_METHOD_PARAMETERS = 32768;
    public static final int F_METHOD_RETURN_TYPE = 65536;
    public static final int F_TARGET_ANNOTATION = 131072;
    public static final int F_RETENTION_ANNOTATION = 262144;
    public static final int F_PROVIDER_ANNOTATION = 524288;
    public static final int F_ENCODED_ANNOTATION = 0x100000;
    public static final int F_PROVIDER_HIERARCHY = 0x200000;
    public static final int F_NAME_BINDING_ANNOTATION = 0x400000;
    public static final int F_PARAM_CONVERTER_PROVIDER_HIERARCHY = 0x800000;
    public static final int F_BEAN_PARAM_ANNOTATION = 0x1000000;
    public static final int F_FORM_PARAM_ANNOTATION = 0x2000000;
    public static final int F_HEADER_PARAM_ANNOTATION = 0x4000000;
    private final IJaxrsElement element;
    private final int deltaKind;
    private Flags flags;

    public JaxrsElementDelta(IJaxrsElement element, int deltaKind, int flags) {
        this.element = element;
        this.deltaKind = deltaKind;
        this.flags = new Flags(flags);
    }

    public JaxrsElementDelta(IJaxrsElement element, int deltaKind, Flags flags) {
        this.element = element;
        this.deltaKind = deltaKind;
        this.flags = flags;
    }

    public boolean isRelevant() {
        return this.element != null && (this.deltaKind == 1 || this.deltaKind == 2 || this.deltaKind == 4 && this.flags.hasValue());
    }

    public IJaxrsElement getElement() {
        return this.element;
    }

    public int getDeltaKind() {
        return this.deltaKind;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public void addFlag(Flags flags) {
        this.flags.addFlags(flags);
    }

    public void addFlag(int flags) {
        this.flags.addFlags(flags);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("JaxrsElementChange: ").append(this.element).append(" [").append(ConstantUtils.getStaticFieldName(IJavaElementDelta.class, this.deltaKind)).append("] ");
        try {
            if (this.flags.hasValue()) {
                ArrayList<String> matchFlags = new ArrayList<String>();
                Field[] fieldArray = JaxrsElementDelta.class.getFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (this.flags.hasValue(field.getInt(field))) {
                        matchFlags.add(ConstantUtils.getStaticFieldName(JaxrsElementDelta.class, field.getInt(field), "F_"));
                    }
                    ++n2;
                }
                s.append(":{");
                Iterator iterator = matchFlags.iterator();
                while (iterator.hasNext()) {
                    String flag = (String)iterator.next();
                    s.append(flag);
                    if (!iterator.hasNext()) continue;
                    s.append("+");
                }
                s.append("}");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return s.toString();
    }

    @Override
    public int compareTo(JaxrsElementDelta other) {
        EnumElementCategory elementKind = this.element.getElementKind().getCategory();
        EnumElementCategory otherElementKind = other.getElement().getElementKind().getCategory();
        return elementKind.ordinal() - otherElementKind.ordinal();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.deltaKind;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JaxrsElementDelta other = (JaxrsElementDelta)obj;
        if (this.deltaKind != other.deltaKind) {
            return false;
        }
        if (this.element == null ? other.element != null : !this.element.equals(other.element)) {
            return false;
        }
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }
}

