/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;

public class Annotation {
    public static final String VALUE = "value";
    private final IAnnotation javaAnnotation;
    private final String javaAnnotationName;
    private final Map<String, List<String>> javaAnnotationElements;
    private final Annotation primaryCopy;
    private final boolean isWorkingCopy;
    private Annotation workingCopy = null;

    public Annotation(IAnnotation javaAnnotation, String javaAnnotationName, Map<String, List<String>> javaAnnotationElements) {
        this.javaAnnotation = javaAnnotation;
        this.javaAnnotationName = javaAnnotationName;
        this.javaAnnotationElements = new HashMap<String, List<String>>(javaAnnotationElements);
        this.primaryCopy = null;
        this.isWorkingCopy = false;
    }

    private Annotation(IAnnotation javaAnnotation, String javaAnnotationName, Map<String, List<String>> javaAnnotationElements, Annotation primaryCopy) {
        this.javaAnnotation = javaAnnotation;
        this.javaAnnotationName = javaAnnotationName;
        this.javaAnnotationElements = new HashMap<String, List<String>>(javaAnnotationElements);
        this.primaryCopy = primaryCopy;
        this.isWorkingCopy = true;
        this.workingCopy = this;
        primaryCopy.workingCopy = this;
    }

    public Annotation(IAnnotation annotation, String annotationName, String annotationValue) {
        this(annotation, annotationName, CollectionUtils.toMap(VALUE, Arrays.asList(annotationValue)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Annotation createWorkingCopy() {
        Annotation annotation = this;
        synchronized (annotation) {
            HashMap<String, List<String>> duplicateJavaAnnotationElements = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : this.javaAnnotationElements.entrySet()) {
                duplicateJavaAnnotationElements.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
            return new Annotation(this.javaAnnotation, this.javaAnnotationName, duplicateJavaAnnotationElements, this);
        }
    }

    public Annotation getWorkingCopy() {
        return this.workingCopy;
    }

    public Annotation getPrimaryCopy() {
        return this.primaryCopy;
    }

    public boolean isWorkingCopy() {
        return this.isWorkingCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Annotation otherAnnotation) {
        Annotation annotation = this;
        synchronized (annotation) {
            block4: {
                if (otherAnnotation != null && this.hasChanges(otherAnnotation)) break block4;
                return false;
            }
            this.javaAnnotationElements.clear();
            this.javaAnnotationElements.putAll(otherAnnotation.getJavaAnnotationElements());
            return true;
        }
    }

    public boolean hasChanges(Annotation otherAnnotation) {
        return !this.javaAnnotationElements.equals(otherAnnotation.getJavaAnnotationElements());
    }

    public IAnnotation getJavaAnnotation() {
        return this.javaAnnotation;
    }

    public IJavaElement getJavaParent() {
        if (this.javaAnnotation == null) {
            return null;
        }
        return this.javaAnnotation.getParent();
    }

    public String getFullyQualifiedName() {
        return this.javaAnnotationName;
    }

    public Map<String, List<String>> getJavaAnnotationElements() {
        return this.javaAnnotationElements;
    }

    public List<String> getValues(String elementName) {
        return this.javaAnnotationElements.get(elementName);
    }

    public String getValue() {
        return this.getValue(VALUE);
    }

    public List<String> getValues() {
        return this.getValues(VALUE);
    }

    public String getValue(String elementName) {
        List<String> values = this.javaAnnotationElements.get(elementName);
        if (values != null) {
            assert (values.size() <= 1);
            if (values.size() == 1) {
                return values.get(0);
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('@').append(this.getFullyQualifiedName());
        if (!this.javaAnnotationElements.isEmpty()) {
            builder.append('(');
            Iterator<Map.Entry<String, List<String>>> iterator = this.javaAnnotationElements.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<String>> entry = iterator.next();
                builder.append(entry.getKey()).append('=');
                if (entry.getValue().size() == 1) {
                    builder.append('\"').append(entry.getValue().get(0)).append('\"');
                } else {
                    builder.append(entry.getValue());
                }
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(')');
        }
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.javaAnnotation == null ? 0 : this.javaAnnotation.getHandleIdentifier().hashCode());
        result = 31 * result + (this.javaAnnotationElements == null ? 0 : this.javaAnnotationElements.hashCode());
        result = 31 * result + (this.javaAnnotationName == null ? 0 : this.javaAnnotationName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Annotation other = (Annotation)obj;
        if (this.javaAnnotationElements == null ? other.javaAnnotationElements != null : !this.javaAnnotationElements.equals(other.javaAnnotationElements)) {
            return false;
        }
        return !(this.javaAnnotationName == null ? other.javaAnnotationName != null : !this.javaAnnotationName.equals(other.javaAnnotationName));
    }
}

