/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;

public class JavaMemberSearchResultCollector
extends SearchRequestor {
    private final ArrayList<IMember> resultMembers = new ArrayList();
    private final int kind;
    private final IJavaSearchScope searchScope;

    public JavaMemberSearchResultCollector(int k, IJavaSearchScope scope) {
        this.kind = k;
        this.searchScope = scope;
    }

    public final void acceptSearchMatch(SearchMatch match) throws CoreException {
        IMember element = (IMember)match.getElement();
        if (!this.searchScope.encloses((IJavaElement)element)) {
            return;
        }
        IMember member = (IMember)element.getAncestor(this.kind);
        if (member != null && !this.resultMembers.contains(member)) {
            this.resultMembers.add(member);
        }
    }

    public final <T> Set<T> getResult() {
        HashSet<IMember> results = new HashSet<IMember>();
        for (IMember member : this.resultMembers) {
            results.add(member);
        }
        return results;
    }

    public boolean hasResult() {
        return !this.resultMembers.isEmpty();
    }
}

