/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamAnnotations;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParameterAggregatorProperty;
import org.jboss.tools.ws.jaxrs.core.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.jdt.FlagsUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsParameterAggregator;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsElementDelta;

public class JaxrsParameterAggregator
extends JaxrsJavaElement<IType>
implements IJaxrsParameterAggregator {
    private final Map<String, JaxrsParameterAggregatorField> fields = new HashMap<String, JaxrsParameterAggregatorField>();
    private final Map<String, JaxrsParameterAggregatorProperty> properties = new HashMap<String, JaxrsParameterAggregatorProperty>();

    public static Builder from(IJavaElement javaElement) throws JavaModelException {
        CompilationUnit ast = JdtUtils.parse(javaElement, (IProgressMonitor)new NullProgressMonitor());
        return JaxrsParameterAggregator.from(javaElement, ast);
    }

    public static Builder from(IJavaElement javaElement, CompilationUnit ast) {
        switch (javaElement.getElementType()) {
            case 5: {
                return new Builder(((ICompilationUnit)javaElement).findPrimaryType(), ast);
            }
            case 7: {
                return new Builder((IType)javaElement, ast);
            }
        }
        return null;
    }

    private JaxrsParameterAggregator(Builder builder) {
        this(builder.javaType, (Map<String, Annotation>)null, builder.metamodel, (JaxrsParameterAggregator)null);
    }

    private JaxrsParameterAggregator(IType javaType, Map<String, Annotation> annotations, JaxrsMetamodel metamodel, JaxrsParameterAggregator primaryCopy) {
        super(javaType, annotations, metamodel, primaryCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JaxrsParameterAggregator createWorkingCopy() {
        JaxrsParameterAggregator jaxrsParameterAggregator = this;
        synchronized (jaxrsParameterAggregator) {
            JaxrsParameterAggregator paramAggregatorWorkingCopy = new JaxrsParameterAggregator((IType)this.getJavaElement(), AnnotationUtils.createWorkingCopies(this.getAnnotations()), this.getMetamodel(), this);
            for (Map.Entry<String, JaxrsParameterAggregatorField> entry : this.fields.entrySet()) {
                entry.getValue().createWorkingCopy(paramAggregatorWorkingCopy);
            }
            for (Map.Entry<String, JaxrsParameterAggregatorElement> entry : this.properties.entrySet()) {
                ((JaxrsParameterAggregatorProperty)entry.getValue()).createWorkingCopy(paramAggregatorWorkingCopy);
            }
            return paramAggregatorWorkingCopy;
        }
    }

    @Override
    public JaxrsParameterAggregator getWorkingCopy() {
        return (JaxrsParameterAggregator)super.getWorkingCopy();
    }

    public void addElement(JaxrsParameterAggregatorField field) {
        if (field != null) {
            this.fields.put(field.getIdentifier(), field);
        }
    }

    public void addElement(JaxrsParameterAggregatorProperty method) {
        if (method != null) {
            this.properties.put(((IMethod)method.getJavaElement()).getHandleIdentifier(), method);
        }
    }

    @Override
    public EnumElementKind getElementKind() {
        return EnumElementKind.PARAMETER_AGGREGATOR;
    }

    @Override
    public final String getName() {
        return ((IType)this.getJavaElement()).getFullyQualifiedName();
    }

    @Override
    public List<JaxrsParameterAggregatorField> getAllFields() {
        return Collections.unmodifiableList(new ArrayList<JaxrsParameterAggregatorField>(this.fields.values()));
    }

    public Map<String, JaxrsParameterAggregatorField> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public List<JaxrsParameterAggregatorField> getFieldsAnnotatedWith(String annotationName) {
        ArrayList<JaxrsParameterAggregatorField> matches = new ArrayList<JaxrsParameterAggregatorField>();
        for (JaxrsParameterAggregatorField field : this.fields.values()) {
            if (!field.hasAnnotation(annotationName)) continue;
            matches.add(field);
        }
        return matches;
    }

    public JaxrsParameterAggregatorField getFieldAnnotatedWith(String annotationName, String annotationValue) {
        for (Map.Entry<String, JaxrsParameterAggregatorField> entry : this.fields.entrySet()) {
            JaxrsParameterAggregatorField field = entry.getValue();
            Annotation annotation = field.getAnnotation(annotationName);
            if (annotation == null || !annotationValue.equals(annotation.getValue())) continue;
            return field;
        }
        return null;
    }

    @Override
    public List<JaxrsParameterAggregatorProperty> getAllProperties() {
        return Collections.unmodifiableList(new ArrayList<JaxrsParameterAggregatorProperty>(this.properties.values()));
    }

    public Map<String, JaxrsParameterAggregatorProperty> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public List<JaxrsParameterAggregatorProperty> getPropertiesAnnotatedWith(String annotationName) {
        ArrayList<JaxrsParameterAggregatorProperty> matches = new ArrayList<JaxrsParameterAggregatorProperty>();
        for (JaxrsParameterAggregatorProperty method : this.properties.values()) {
            if (!method.hasAnnotation(annotationName)) continue;
            matches.add(method);
        }
        return matches;
    }

    public JaxrsParameterAggregatorProperty getPropertyAnnotatedWith(String annotationName, String annotationValue) {
        for (Map.Entry<String, JaxrsParameterAggregatorProperty> entry : this.properties.entrySet()) {
            JaxrsParameterAggregatorProperty property = entry.getValue();
            Annotation annotation = property.getAnnotation(annotationName);
            if (annotation == null || !annotationValue.equals(annotation.getValue())) continue;
            return property;
        }
        return null;
    }

    public void removeField(JaxrsParameterAggregatorField parameterAggregatorField) {
        this.fields.remove(parameterAggregatorField.getIdentifier());
    }

    public void removeProperty(JaxrsParameterAggregatorProperty parameterAggregatorProperty) {
        this.properties.remove(parameterAggregatorProperty.getIdentifier());
    }

    public List<String> getPathParamValues() {
        Annotation aggregatorFieldPathParamAnnotation;
        ArrayList<String> pathParamValues = new ArrayList<String>();
        for (JaxrsParameterAggregatorField aggregatorField : this.fields.values()) {
            aggregatorFieldPathParamAnnotation = aggregatorField.getAnnotation("javax.ws.rs.PathParam");
            if (aggregatorFieldPathParamAnnotation == null || aggregatorFieldPathParamAnnotation.getValue() == null) continue;
            pathParamValues.add(aggregatorFieldPathParamAnnotation.getValue());
        }
        for (JaxrsParameterAggregatorProperty aggregatorProperties : this.properties.values()) {
            aggregatorFieldPathParamAnnotation = aggregatorProperties.getAnnotation("javax.ws.rs.PathParam");
            if (aggregatorFieldPathParamAnnotation == null || aggregatorFieldPathParamAnnotation.getValue() == null) continue;
            pathParamValues.add(aggregatorFieldPathParamAnnotation.getValue());
        }
        return pathParamValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IJavaElement javaElement, CompilationUnit ast) throws CoreException {
        JaxrsParameterAggregator jaxrsParameterAggregator = this;
        synchronized (jaxrsParameterAggregator) {
            JaxrsParameterAggregator transientAggregator = JaxrsParameterAggregator.from(javaElement, ast).buildTransient();
            Flags annotationsFlags = FlagsUtils.computeElementFlags(this);
            if (transientAggregator == null) {
                this.remove(annotationsFlags);
                return;
            }
            Flags updateAnnotationsFlags = this.updateAnnotations(transientAggregator.getAnnotations());
            JaxrsElementDelta delta = new JaxrsElementDelta((IJaxrsElement)this, 4, updateAnnotationsFlags);
            this.updateProperties(transientAggregator, ast);
            this.updateFields(transientAggregator, ast);
            if (this.isMarkedForRemoval()) {
                this.remove(annotationsFlags);
            } else if (this.hasMetamodel()) {
                this.getMetamodel().update(delta);
            }
        }
    }

    private void updateProperties(JaxrsParameterAggregator transientAggregator, CompilationUnit ast) throws CoreException {
        List<JaxrsParameterAggregatorProperty> allTransientInstanceProperties = transientAggregator.getAllProperties();
        List<JaxrsParameterAggregatorProperty> allCurrentProperties = this.getAllProperties();
        List<JaxrsParameterAggregatorProperty> addedProperties = CollectionUtils.difference(allTransientInstanceProperties, allCurrentProperties);
        for (JaxrsParameterAggregatorProperty addedProperty : addedProperties) {
            JaxrsParameterAggregatorProperty.from((IMethod)addedProperty.getJavaElement(), ast).buildInParentAggregator(this);
        }
        List<JaxrsParameterAggregatorProperty> changedProperties = CollectionUtils.intersection(allCurrentProperties, allTransientInstanceProperties);
        for (JaxrsParameterAggregatorProperty changedProperty : changedProperties) {
            changedProperty.update(transientAggregator.getProperties().get(changedProperty.getIdentifier()));
        }
        List<JaxrsParameterAggregatorProperty> removedProperties = CollectionUtils.difference(allCurrentProperties, allTransientInstanceProperties);
        for (JaxrsParameterAggregatorProperty removedProperty : removedProperties) {
            removedProperty.remove(FlagsUtils.computeElementFlags(removedProperty));
        }
    }

    private void updateFields(JaxrsParameterAggregator transientAggregator, CompilationUnit ast) throws CoreException {
        List<JaxrsParameterAggregatorField> allTransientInstanceFields = transientAggregator.getAllFields();
        List<JaxrsParameterAggregatorField> allCurrentFields = this.getAllFields();
        List<JaxrsParameterAggregatorField> addedFields = CollectionUtils.difference(allTransientInstanceFields, allCurrentFields);
        for (JaxrsParameterAggregatorField addedField : addedFields) {
            JaxrsParameterAggregatorField.from((IField)addedField.getJavaElement(), ast).buildInParentAggregator(this);
        }
        List<JaxrsParameterAggregatorField> changedFields = CollectionUtils.intersection(allCurrentFields, allTransientInstanceFields);
        for (JaxrsParameterAggregatorField changedField : changedFields) {
            changedField.update(transientAggregator.getFields().get(changedField.getIdentifier()));
        }
        List<JaxrsParameterAggregatorField> removedFields = CollectionUtils.difference(allCurrentFields, allTransientInstanceFields);
        for (JaxrsParameterAggregatorField removedField : removedFields) {
            removedField.remove(FlagsUtils.computeElementFlags(removedField));
        }
    }

    @Override
    boolean isMarkedForRemoval() {
        return this.getAllFields().isEmpty() && this.getAllProperties().isEmpty();
    }

    @Override
    public void remove(Flags flags) throws CoreException {
        super.remove(flags);
        for (JaxrsParameterAggregatorField field : this.getAllFields()) {
            field.remove(FlagsUtils.computeElementFlags(field));
        }
        for (JaxrsParameterAggregatorProperty property : this.getAllProperties()) {
            property.remove(FlagsUtils.computeElementFlags(property));
        }
    }

    @Override
    public void resetProblemLevel() {
        super.resetProblemLevel();
        for (Map.Entry<String, JaxrsParameterAggregatorField> entry : this.fields.entrySet()) {
            entry.getValue().resetProblemLevel();
        }
        for (Map.Entry<String, JaxrsParameterAggregatorElement> entry : this.properties.entrySet()) {
            ((JaxrsParameterAggregatorProperty)entry.getValue()).resetProblemLevel();
        }
    }

    /* synthetic */ JaxrsParameterAggregator(Builder builder, JaxrsParameterAggregator jaxrsParameterAggregator) {
        this(builder);
    }

    public static class Builder {
        private final IType javaType;
        private final CompilationUnit ast;
        private JaxrsMetamodel metamodel;

        private Builder(IType javaType, CompilationUnit ast) {
            this.javaType = javaType;
            this.ast = ast;
        }

        public JaxrsParameterAggregator buildTransient() throws CoreException {
            return this.buildInMetamodel(null);
        }

        public JaxrsParameterAggregator buildInMetamodel(JaxrsMetamodel metamodel) throws CoreException {
            long start;
            block13: {
                JaxrsParameterAggregator jaxrsParameterAggregator;
                block12: {
                    block11: {
                        start = System.currentTimeMillis();
                        if (this.javaType != null && this.javaType.exists() && this.javaType.isStructureKnown()) break block11;
                        long end = System.currentTimeMillis();
                        Logger.tracePerf("Built JAX-RS Parameter Aggreagator in {}ms", end - start);
                        return null;
                    }
                    JdtUtils.makeConsistentIfNecessary((IMember)this.javaType);
                    this.metamodel = metamodel;
                    Map<String, Annotation> typeAnnotations = JdtUtils.resolveAllAnnotations((IMember)this.javaType, this.ast);
                    if (!CollectionUtils.hasIntersection(typeAnnotations.keySet(), Arrays.asList("javax.ws.rs.ApplicationPath", "javax.ws.rs.Path", "javax.ws.rs.ext.Provider", "javax.ws.rs.HttpMethod"))) break block12;
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Parameter Aggreagator in {}ms", end - start);
                    return null;
                }
                try {
                    IField[] allFields = this.javaType.getFields();
                    ArrayList<IField> relevantFields = new ArrayList<IField>();
                    IField[] iFieldArray = allFields;
                    int n = allFields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IField field = iFieldArray[n2];
                        Map<String, Annotation> fieldAnnotations = JdtUtils.resolveAllAnnotations((IMember)field, this.ast);
                        if (JaxrsParamAnnotations.matchesAtLeastOne(fieldAnnotations.keySet())) {
                            relevantFields.add(field);
                        }
                        ++n2;
                    }
                    IMethod[] allProperties = this.javaType.getMethods();
                    ArrayList<IMethod> relevantProperties = new ArrayList<IMethod>();
                    IMethod[] iMethodArray = allProperties;
                    int n3 = allProperties.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMethod method = iMethodArray[n4];
                        Map<String, Annotation> methodAnnotations = JdtUtils.resolveAllAnnotations((IMember)method, this.ast);
                        if (JaxrsParamAnnotations.matchesAtLeastOne(methodAnnotations.keySet())) {
                            relevantProperties.add(method);
                        }
                        ++n4;
                    }
                    if (relevantFields.isEmpty() && relevantProperties.isEmpty()) break block13;
                    JaxrsParameterAggregator parameterAggregator = new JaxrsParameterAggregator(this, null);
                    if (this.metamodel != null) {
                        parameterAggregator.joinMetamodel();
                    }
                    for (IField field : relevantFields) {
                        JaxrsParameterAggregatorField.from(field, this.ast).buildInParentAggregator(parameterAggregator);
                    }
                    for (IMethod method : relevantProperties) {
                        JaxrsParameterAggregatorProperty.from(method, this.ast).buildInParentAggregator(parameterAggregator);
                    }
                    jaxrsParameterAggregator = parameterAggregator;
                }
                catch (Throwable throwable) {
                    long end = System.currentTimeMillis();
                    Logger.tracePerf("Built JAX-RS Parameter Aggreagator in {}ms", end - start);
                    throw throwable;
                }
                long end = System.currentTimeMillis();
                Logger.tracePerf("Built JAX-RS Parameter Aggreagator in {}ms", end - start);
                return jaxrsParameterAggregator;
            }
            long end = System.currentTimeMillis();
            Logger.tracePerf("Built JAX-RS Parameter Aggreagator in {}ms", end - start);
            return null;
        }
    }
}

