/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain;

import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.core.jdt.Flags;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;

public abstract class JaxrsBaseElement
implements IJaxrsElement {
    private final JaxrsMetamodel metamodel;
    private int problemSeverity;
    public boolean exist = true;
    private JaxrsBaseElement workingCopy;
    private JaxrsBaseElement primaryCopy;
    private final boolean isWorkingCopy;

    JaxrsBaseElement(JaxrsMetamodel metamodel, JaxrsBaseElement primaryCopy) {
        this.metamodel = metamodel;
        this.isWorkingCopy = primaryCopy != null;
        this.primaryCopy = primaryCopy;
        if (this.isWorkingCopy) {
            this.primaryCopy.setWorkingCopy(this);
        }
    }

    public boolean exists() {
        return this.exist;
    }

    public void resetProblemLevel() {
        if (this.isWorkingCopy) {
            this.getPrimaryCopy().resetProblemLevel();
        } else {
            this.problemSeverity = 0;
        }
    }

    public void setProblemSeverity(int severity) {
        if (this.isWorkingCopy) {
            this.getPrimaryCopy().setProblemSeverity(severity);
        } else {
            this.problemSeverity = Math.max(this.problemSeverity, severity);
        }
    }

    @Override
    public final int getProblemSeverity() {
        if (this.isWorkingCopy()) {
            return this.getPrimaryCopy().getProblemSeverity();
        }
        return this.problemSeverity;
    }

    public boolean hasProblem() {
        return this.problemSeverity > 0;
    }

    @Override
    public final JaxrsMetamodel getMetamodel() {
        return this.metamodel;
    }

    protected void joinMetamodel() throws CoreException {
        if (this.metamodel != null) {
            this.metamodel.add(this);
        }
    }

    public void remove(Flags flags) throws CoreException {
        this.exist = false;
        if (this.getMetamodel().containsElement(this)) {
            this.getMetamodel().remove(this, flags);
        } else {
            Logger.debug("Element {} was already removed from the metamodel", this.getName());
        }
    }

    abstract boolean isMarkedForRemoval();

    protected boolean hasMetamodel() {
        return this.getMetamodel() != null;
    }

    public abstract JaxrsBaseElement createWorkingCopy();

    public JaxrsBaseElement getWorkingCopy() {
        this.workingCopy = this.createWorkingCopy();
        return this.workingCopy;
    }

    public boolean hasWorkingCopy() {
        return this.workingCopy != null;
    }

    private void setWorkingCopy(JaxrsBaseElement workingCopy) {
        this.workingCopy = workingCopy;
    }

    public JaxrsBaseElement getPrimaryCopy() {
        return this.primaryCopy;
    }

    public void setPrimaryCopy(JaxrsBaseElement primaryCopy) {
        this.primaryCopy = primaryCopy;
    }

    public boolean isWorkingCopy() {
        return this.isWorkingCopy;
    }
}

